--
-- Straw Specialization for Combines
--
-- @author  Templaer
-- @Edit: Unknown, MRA-Modding(Alex2009(www.alex2009.de))(www.mra-modding.de)
-- @MP Ready: MRA-Modding(Alex2009(www.alex2009.de))(www.mra-modding.de)
-- @Graintank & addChopper particle system Scipt from: SFM(Face)
-- @date  24/05/09

strawSpec = {};

function strawSpec.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function strawSpec:load(xmlFile)
    self.setStrwaState = SpecializationUtil.callSpecializationsFunction("setStrwaState");
    self.UpdateLexionChopperPS = SpecializationUtil.callSpecializationsFunction("UpdateLexionChopperPS");
    self.backupChopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));   
    -----------------------------Radial Verteiler----------------------
    local radialNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strawSystem#RadialNode"));
    self.radialChar = 0;
    if radialNode ~= nil then
        self.radialChar = getAnimCharacterSet(radialNode);
        if self.radialChar ~= 0 then
            local clipname = getAnimClipIndex(self.radialChar, getXMLString(xmlFile, "vehicle.strawSystem#RadialClip"));
            assignAnimTrackClip(self.radialChar, 0, clipname);
            setAnimTrackLoopState(self.radialChar, 0, false);
            self.radialDurat = getAnimClipDuration(self.radialChar, clipname);
			self.radialClip = clipname;
        end;
    end;
    -----------------------------Radial Verteiler----------------------
    local schwadKlappenNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strawSystem#schwadKlappenNode"));
    self.schwadKlappenChar = 0;
    if schwadKlappenNode ~= nil then
        self.schwadKlappenChar = getAnimCharacterSet(schwadKlappenNode);
        if self.schwadKlappenChar ~= 0 then
            local clipname = getAnimClipIndex(self.schwadKlappenChar, getXMLString(xmlFile, "vehicle.strawSystem#schwadKlappenClip"));
            assignAnimTrackClip(self.schwadKlappenChar, 0, clipname);
            setAnimTrackLoopState(self.schwadKlappenChar, 0, false);
            self.schwadKlappenDurat = getAnimClipDuration(self.schwadKlappenChar, clipname);
			self.schwadKlappenClip = clipname;
        end;
    end;
    local spreuverteilerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strawSystem#spreuverteilerNode"));
    self.spreuverteilerChar = 0;
    if spreuverteilerNode ~= nil then
        self.spreuverteilerChar = getAnimCharacterSet(spreuverteilerNode);
        if self.spreuverteilerChar ~= 0 then
            local clipname = getAnimClipIndex(self.spreuverteilerChar, getXMLString(xmlFile, "vehicle.strawSystem#spreuverteilerClip"));
            assignAnimTrackClip(self.spreuverteilerChar, 0, clipname);
            setAnimTrackLoopState(self.spreuverteilerChar, 0, true);
			self.spreuverteilerClip = clipname;
        end;
    end;
    local verteilerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strawSystem#verteilerNode"));
    self.verteilerChar = 0;
    if verteilerNode ~= nil then
        self.verteilerChar = getAnimCharacterSet(verteilerNode);
        if self.verteilerChar ~= 0 then
            local clipname = getAnimClipIndex(self.verteilerChar, getXMLString(xmlFile, "vehicle.strawSystem#verteilerClip"));
            assignAnimTrackClip(self.verteilerChar, 0, clipname);
            setAnimTrackLoopState(self.verteilerChar, 0, true);
			self.verteilerClip = clipname;
        end;
    end;

	self.ChopperParticleSystemLexion750 = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.addChopperParticleSystems.chopperParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.ChopperParticleSystemLexion750[desc.index] = currentPS;
			if self.addDefaultChopperParticleSystem == nil then
				self.addDefaultChopperParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
    
    self.GrainTankParticleSystemLexion750 = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.graintankParticleSystems.graintankParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
			self.GrainTankParticleSystemLexion750[desc.index] = currentPS;
			if self.defaultGraintankParticleSystem == nil then
				self.defaultGraintankParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
    self.currentGraintankParticleSystem = nil;
    
    -- chopper dust particle system
	self.chopperDustParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.chopperDustParticleSystems.chopperDustParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.chopperDustParticleSystems[desc.index] = currentPS;
			if self.defaultChopperDustParticleSystem == nil then
				self.defaultChopperDustParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
    ----------------------------Other----------------------------------
    self.VerteilerSourceAnimSpeed = 0.0;
    self.strawActive = false;
    self.chopperLexionEnabled = false;
    self.LexionStrawWarning = 0;
end;

function strawSpec:delete()
    for k,v in pairs(self.ChopperParticleSystemLexion750) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.GrainTankParticleSystemLexion750) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.chopperDustParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
end;

function strawSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function strawSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function strawSpec:update(dt)
	if self:getIsActive() and self:getIsActiveForInput() then
        if self.isThreshing then
            if InputBinding.hasEvent(InputBinding.LEX750_STRAW_TOGGLE) then
                local fruitType = "unknown";
                if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                    fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
                end;
                if(fruitType == "rape") or (fruitType == "maize") then
                    self.LexionStrawWarning = 90;
                    if self.strawActive then
                        self:setStrwaState(false);
                    end;
                else
                    self:setStrwaState(not self.strawActive);
                end;
            end;
        end;
    end;
    if self.LexionStrawWarning > 0 then
        g_currentMission:addWarning("\n"..g_i18n:getText("Straw_Not_Allowed"), 0.018, 0.033);
        self.LexionStrawWarning = (self.LexionStrawWarning-1);
    end;
end;

function strawSpec:updateTick(dt)
    if self:getIsActive() then
        if self.strawActive then
            local fruitType = "unknown";
            if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
            end;
            if(fruitType == "rape") or (fruitType == "maize") then
                self:setStrwaState(false);
            end;
        end;
        for key, particle in pairs(self.ChopperParticleSystemLexion750) do
            Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
        end;
        for key, particle in pairs(self.chopperDustParticleSystems) do
			Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
		end;
        --for key, particle in pairs(self.GrainTankParticleSystemLexion750) do
        --    Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
        --end;
        self.chopperActivated = not self.strawActive;
		if not self.strawActive then
            local disableChopperEmit = true;
			self.strawEmitState = false;
            self.strawEnableTime = nil;
			self.chopperBlind = nil;	
			if self.lastArea > 0 then
				if self.chopperActivated then
                    if self.chopperEnableTime == nil then
						self.chopperEnableTime = self.time + self.chopperToggleTime;
					else
						self.chopperDisableTime = nil;
					end;
					disableChopperEmit = false;
				end;
                if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
                    self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
                    if self.currentChopperParticleSystem == nil then
                        self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
                    end;
                    Utils.setEmittingState(self.currentChopperParticleSystem, true);
			    end;
			end;
			if self.grainTankFillLevel == self.grainTankCapacity then
				Utils.setEmittingState(self.currentChopperParticleSystem, false);
			end;
			if not self.isThreshing then
				Utils.setEmittingState(self.currentChopperParticleSystem, false);
			end;	
			if self.ignitionKey ~= nil then
				if not self.ignitionKey then
					Utils.setEmittingState(self.currentChopperParticleSystem, false);
				end;
			end;
		elseif self.strawActive then
			self.chopperBlind = self.backupChopperBlind;
			self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
            if self.isThreshing then
                if getAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip) > self.schwadKlappenDurat then
                    setAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip, self.schwadKlappenDurat);
                    disableAnimTrack(self.schwadKlappenChar, self.schwadKlappenClip);      
                end;
                if getAnimTrackTime(self.radialChar, self.radialClip) > self.radialDurat then
                    setAnimTrackTime(self.radialChar, self.radialClip, self.radialDurat);
                    disableAnimTrack(self.radialChar, self.radialClip);      
                end;
            end;
		end;
	else
		if self.currentChopperParticleSystem ~= nil then
			Utils.setEmittingState(self.currentChopperParticleSystem, false);
		end;
		if self.currentChopperParticleSystem ~= nil then
			Utils.setEmittingState(self.currentStrawParticleSystem, false);
		end;
        for key, particle in pairs(self.ChopperParticleSystemLexion750) do
            Utils.setEmittingState(particle, false);
        end;
        for key, particle in pairs(self.chopperDustParticleSystems) do
			Utils.setEmittingState(particle, false);
		end;
	end;
    if not self.strawActive then
        if self.isThreshing then
            if self.VerteilerSourceAnimSpeed < 1 then
                if self.spreuverteilerChar ~= 0 then
                    self.VerteilerSourceAnimSpeed = self.VerteilerSourceAnimSpeed + 0.0035;
                    setAnimTrackSpeedScale(self.spreuverteilerChar, 0, self.VerteilerSourceAnimSpeed);
                    setAnimTrackSpeedScale(self.verteilerChar, 0, self.VerteilerSourceAnimSpeed);
                end;
            else
                if self.spreuverteilerChar ~= 0 then
                    self.VerteilerSourceAnimSpeed = 1;
                    setAnimTrackSpeedScale(self.spreuverteilerChar, 0, self.VerteilerSourceAnimSpeed);
                    setAnimTrackSpeedScale(self.verteilerChar, 0, self.VerteilerSourceAnimSpeed);
                end;
            end;
            local trackTime = getAnimTrackTime(self.radialChar, self.radialClip);
            if (trackTime <= 1770 and trackTime >= 1690) then
                setAnimTrackTime(self.radialChar, self.radialClip, 1770);
                disableAnimTrack(self.radialChar, self.radialClip); 
            end;
            if getAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip) < 0 then
                setAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip, 0);
                disableAnimTrack(self.schwadKlappenChar, self.schwadKlappenClip);      
            end;
        end;
    end;
    if self.strawActive or not self.isThreshing then
        if self.VerteilerSourceAnimSpeed > 0 then
            if self.spreuverteilerChar ~= 0 then
                self.VerteilerSourceAnimSpeed = self.VerteilerSourceAnimSpeed - 0.0035;
                setAnimTrackSpeedScale(self.spreuverteilerChar, 0, self.VerteilerSourceAnimSpeed);
                setAnimTrackSpeedScale(self.verteilerChar, 0, self.VerteilerSourceAnimSpeed);
            end;
        else
            if self.spreuverteilerChar ~= 0 then
                self.VerteilerSourceAnimSpeed = 0;
                setAnimTrackSpeedScale(self.spreuverteilerChar, 0, self.VerteilerSourceAnimSpeed);
                setAnimTrackSpeedScale(self.verteilerChar, 0, self.VerteilerSourceAnimSpeed);
                disableAnimTrack(self.spreuverteilerChar, self.schwadKlappenClip);
                disableAnimTrack(self.verteilerChar, self.schwadKlappenClip);
            end;
        end;
    end;
    if getAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip) < 0 then
        setAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip, 0);
        disableAnimTrack(self.schwadKlappenChar, self.schwadKlappenClip);      
    elseif getAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip) > self.schwadKlappenDurat then
        setAnimTrackTime(self.schwadKlappenChar, self.schwadKlappenClip, self.schwadKlappenDurat);
        disableAnimTrack(self.schwadKlappenChar, self.schwadKlappenClip);      
    end;
    if getAnimTrackTime(self.radialChar, self.radialClip) < 0 then
        setAnimTrackTime(self.radialChar, self.radialClip, 0);
        disableAnimTrack(self.radialChar, self.radialClip); 
    elseif getAnimTrackTime(self.radialChar, self.radialClip) > self.radialDurat then
        setAnimTrackTime(self.radialChar, self.radialClip, self.schwadKlappenDurat);
        disableAnimTrack(self.radialChar, self.radialClip);   
    end;
end;

function strawSpec:draw()
    if self.isThreshing then
        if self.strawActive then
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("straw_disable"), self.typeDesc), InputBinding.LEX750_STRAW_TOGGLE);
        else
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("straw_enable"), self.typeDesc), InputBinding.LEX750_STRAW_TOGGLE);
        end;
    end;
end;

function strawSpec:UpdateLexionChopperPS(state,id,noEventSend)
    strawSpecChopperPSUpdateEvent.sendEvent(self,state,id,noEventSend);
    if state then
        self.currentChopperParticleSystem = self.chopperParticleSystems[id];
        if self.currentChopperParticleSystem == nil then
            self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
        end;
        Utils.setEmittingState(self.currentChopperParticleSystem, true);
    else
        Utils.setEmittingState(self.currentChopperParticleSystem, false);
    end;
end;

function strawSpec:setStrwaState(state,noEventSend)
    if self.strawActive ~= state then
        self.strawActive = state;
        if self.strawActive then
            if self.schwadKlappenChar ~= 0 then
                setAnimTrackSpeedScale(self.schwadKlappenChar, 0, 1);
                enableAnimTrack(self.schwadKlappenChar, 0);
            end;
            if self.radialChar ~= 0 then
                setAnimTrackSpeedScale(self.radialChar, 0, 1);
                enableAnimTrack(self.radialChar, 0);
            end;
        else
            if getAnimTrackTime(self.radialChar, self.radialClip) < 1770 then
                if self.radialChar ~= 0 then
                    setAnimTrackSpeedScale(self.radialChar, 0, 1);
                    enableAnimTrack(self.radialChar, 0);
                end;
            else
                if self.radialChar ~= 0 then
                    setAnimTrackSpeedScale(self.radialChar, 0, -1);
                    enableAnimTrack(self.radialChar, 0);
                end;
            end;
            if self.schwadKlappenChar ~= 0 then
                setAnimTrackSpeedScale(self.schwadKlappenChar, 0, -1);
                enableAnimTrack(self.schwadKlappenChar, 0);
            end;
            if self.spreuverteilerChar ~= 0 then
                setAnimTrackSpeedScale(self.spreuverteilerChar, 0, self.VerteilerSourceAnimSpeed);
                enableAnimTrack(self.spreuverteilerChar, 0);
                setAnimTrackSpeedScale(self.verteilerChar, 0, self.VerteilerSourceAnimSpeed);
                enableAnimTrack(self.verteilerChar, 0);
            end;
        end;
        strawSpecEvent.sendEvent(self,state,noEventSend);
    end;
end;

function strawSpec:stopThreshing()
    if self.radialChar ~= 0 then
        setAnimTrackSpeedScale(self.radialChar, 0, -1);
        enableAnimTrack(self.radialChar, 0);
    end;
    if self.schwadKlappenChar ~= 0 then
        setAnimTrackSpeedScale(self.schwadKlappenChar, 0, -1);
        enableAnimTrack(self.schwadKlappenChar, 0);
    end;
    for k,v in pairs(self.ChopperParticleSystemLexion750) do
        Utils.setEmittingState(v, false);
    end;
	for k,v in pairs(self.chopperDustParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
end;

function strawSpec:startThreshing()
    if self.numAttachedCutters > 0 then
        if self.strawActive then
            if self.schwadKlappenChar ~= 0 then
                setAnimTrackSpeedScale(self.schwadKlappenChar, 0, 1);
                enableAnimTrack(self.schwadKlappenChar, 0);
            end;
            if self.radialChar ~= 0 then
                setAnimTrackSpeedScale(self.radialChar, 0, 1);
                enableAnimTrack(self.radialChar, 0);
            end;
        else
            if self.radialChar ~= 0 then
                setAnimTrackSpeedScale(self.radialChar, 0, 1);
                enableAnimTrack(self.radialChar, 0);
            end;
            if self.schwadKlappenChar ~= 0 then
                setAnimTrackSpeedScale(self.schwadKlappenChar, 0, -1);
                enableAnimTrack(self.schwadKlappenChar, 0);
            end;
            if self.spreuverteilerChar ~= 0 then
                setAnimTrackSpeedScale(self.spreuverteilerChar, 0, self.VerteilerSourceAnimSpeed);
                enableAnimTrack(self.spreuverteilerChar, 0);
                setAnimTrackSpeedScale(self.verteilerChar, 0, self.VerteilerSourceAnimSpeed);
                enableAnimTrack(self.verteilerChar, 0);
            end;
        end;
    end;
end;

function strawSpec:onDeactivate()
    for k,v in pairs(self.ChopperParticleSystemLexion750) do
        Utils.setEmittingState(v, false);
    end;
    for k,v in pairs(self.GrainTankParticleSystemLexion750) do
        Utils.setEmittingState(v, false);
    end;
    for k,v in pairs(self.chopperDustParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
end;

function strawSpec:onLeave()
    self.LexionStrawWarning = 0;
end;

local oldCombineSetStrawEnableEvent = CombineSetStrawEnableEvent.execute;
CombineSetStrawEnableEvent.execute = function(object, enabled, fruitType)
	oldCombineSetStrawEnableEvent(object, enabled, fruitType);
	if object.GrainTankParticleSystemLexion750 ~= nil then
		if object.currentGraintankParticleSystem ~= nil then
			Utils.setEmittingState(object.currentGraintankParticleSystem, false);
		end;
		object.currentGraintankParticleSystem = object.GrainTankParticleSystemLexion750[fruitType];
		if object.currentGraintankParticleSystem == nil then
			object.currentGraintankParticleSystem = object.defaultGraintankParticleSystem;
		end;
		local visible = Utils.getNoNil(object.particleSystemsVisible, true);
		Utils.setEmittingState(object.currentGraintankParticleSystem, enabled and visible);	
	end;
end;

local oldCombineSetChopperEnableEvent = CombineSetChopperEnableEvent.execute;
CombineSetChopperEnableEvent.execute = function(object, enabled, fruitType)
	oldCombineSetChopperEnableEvent(object, enabled, fruitType);
	if object.GrainTankParticleSystemLexion750 ~= nil then
		if object.currentGraintankParticleSystem ~= nil then
			Utils.setEmittingState(object.currentGraintankParticleSystem, false);
		end;
		object.currentGraintankParticleSystem = object.GrainTankParticleSystemLexion750[fruitType];
		if object.currentGraintankParticleSystem == nil then
			object.currentGraintankParticleSystem = object.defaultGraintankParticleSystem;
		end;
		local visible = Utils.getNoNil(object.particleSystemsVisible, true);
		Utils.setEmittingState(object.currentGraintankParticleSystem, enabled and visible);	
	end;
end;

----------------------------StrawSpecEvent---------------------------------------
--
-- strawSpecEvent
--
-- @author  MRA-Modding(Alex2009)
-- @website www.alex2009.de, www.mra-modding.de
-- @date    30.11.2011

strawSpecEvent = {};
strawSpecEvent_mt = Class(strawSpecEvent, Event);

InitEventClass(strawSpecEvent, "strawSpecEvent");

function strawSpecEvent:emptyNew()
    local self = Event:new(strawSpecEvent_mt);
    self.className="strawSpecEvent";
    return self;
end;

function strawSpecEvent:new(object, state)
		local self = strawSpecEvent:emptyNew()
		self.object = object;
		self.state = state;
		return self;
end;

function strawSpecEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function strawSpecEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function strawSpecEvent:run(connection)
	self.object:setStrwaState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(strawSpecEvent:new(self.object, self.state), nil, connection, self.object);
    end;	
end;

function strawSpecEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(strawSpecEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(strawSpecEvent:new(vehicle, state));
		end;
	end;
end;

strawSpecChopperPSUpdateEvent = {};
strawSpecChopperPSUpdateEvent_mt = Class(strawSpecChopperPSUpdateEvent, Event);

InitEventClass(strawSpecChopperPSUpdateEvent, "strawSpecChopperPSUpdateEvent");

function strawSpecChopperPSUpdateEvent:emptyNew()
    local self = Event:new(strawSpecChopperPSUpdateEvent_mt);
    self.className="strawSpecChopperPSUpdateEvent";
    return self;
end;

function strawSpecChopperPSUpdateEvent:new(object, state, id)
    local self = strawSpecChopperPSUpdateEvent:emptyNew()
	self.object = object;
	self.state = state;
    self.id = id;
	return self;
end;

function strawSpecChopperPSUpdateEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self.id = streamReadInt32(streamId);
    self:run(connection);
end;

function strawSpecChopperPSUpdateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
    streamWriteInt32(streamId, self.id);
end;

function strawSpecChopperPSUpdateEvent:run(connection)
	self.object:UpdateLexionChopperPS(self.state, self.id, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(strawSpecChopperPSUpdateEvent:new(self.object, self.state, self.id), nil, connection, self.object);
    end;	
end;

function strawSpecChopperPSUpdateEvent.sendEvent(vehicle, state, id, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(strawSpecChopperPSUpdateEvent:new(vehicle, state, id), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(strawSpecChopperPSUpdateEvent:new(vehicle, state, id));
		end;
	end;
end;