--
-- InteractiveComponent Interface
-- Specifies an interactive component
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--
-- @edit:
-- MRA-Modding(Alex2009(http://www.alex2009.de))

InteractiveComponentInterface = {};

function InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, basedir, mt)

	local mTable = mt;
	if mTable == nil then
		mTable = Class(InteractiveComponentInterface);
	end;
    local instance = {};
    setmetatable(instance, mTable);
	
	instance.node = node;
	instance.highlight = highlight;
	instance.scaleX, instance.scaleY, instance.scaleZ = getScale(instance.highlight);
	instance.name = name;
	instance.mark = mark;
	setVisibility(mark,false);
	instance.scale = 0.01;
	instance.size = size;
	instance.isActive = true;
	instance.isMouseOver = false;
	instance.isOpen = false;
	instance.onMessage = Utils.getNoNil(g_i18n:getText("IC_Click_Button"),"LMB:")..Utils.getNoNil(g_i18n:getText(name.."_open"),"ERROR");
	instance.offMessage = Utils.getNoNil(g_i18n:getText("IC_Click_Button"),"LMB:")..Utils.getNoNil(g_i18n:getText(name.."_close"),"ERROR");	
	
	instance.infoBarX = 0.3422;
	instance.infoBarY = 0.001999999;
	
	instance.infoBarWidth = 0.3156;
	instance.infoBar = Overlay:new("icInfobar", Utils.getFilename("Textur/interactiveControl_info.dds", basedir), instance.infoBarX, instance.infoBarY, instance.infoBarWidth, 0.0526);
    
	return instance;	
end;


function InteractiveComponentInterface:delete()
end;

function InteractiveComponentInterface:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveComponentInterface:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveComponentInterface:update(dt)	
	if self.isActive then
		if self.highlight ~= nil then
			if self.isMouseOver then	
				self.scale = self.scale - 0.0006 * dt;
				setScale(self.highlight, self.scaleX + self.scale, self.scaleY + self.scale, self.scaleZ);				
				if self.scaleX + self.scale <= 0.95 then
					self.scale = 0.05;
				end;				
			end;
		end;
	end;
end;

function InteractiveComponentInterface:draw()
	--[[if self.isMouseOver then
		if self.isOpen then
			g_currentMission:addExtraPrintText(string.format(self.offMessage, self.name));
		else
			g_currentMission:addExtraPrintText(string.format(self.onMessage, self.name));
		end;
	end;]]--
	if self.isMouseOver then
		self.infoBar:render();
		setTextBold(true);
		setTextColor(1,1,1,1);
		setTextAlignment(RenderText.ALIGN_LEFT);
		if self.isOpen then
			renderText(self.infoBarX + 0.016, self.infoBarY + 0.017, 0.018, string.format(self.offMessage));
		else
			renderText(self.infoBarX + 0.016, self.infoBarY + 0.017, 0.018, string.format(self.onMessage));
		end;
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(false);
	end;
end;

function InteractiveComponentInterface:doAction(dt)
	self.isOpen = not self.isOpen;
end;

function InteractiveComponentInterface:onEnter(dt)
	self.isMouseOver = true;
end;

function InteractiveComponentInterface:onExit(dt)
	self.isMouseOver = false;
end;

function InteractiveComponentInterface:setActive(isActive)
	self.isActive = isActive;
end;

function InteractiveComponentInterface:setVisible(isVisible)
	if self.mark ~= nil then
		setVisibility(self.mark, isVisible);
	end;
end;