--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--
-- @edit:
-- MRA-Modding(Alex2009(http://www.alex2009.de))

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);	
	if self.count ~= 0 then	
		for i=1, self.count do	
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);	
			local name = Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#name"), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = "--"; --g_i18n:getText("ic_button_on");
			local offMessage = "--"; --g_i18n:getText("ic_button_off");
		
			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.baseDirectory);

			table.insert(self.interactiveObjects, button);
		end;
	end;
	
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--
-- @edit:
-- MRA-Modding(Alex2009(http://www.alex2009.de), Repi(www.mra-modding.de))

Button = {};
Button.Folder = g_currentModDirectory;

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, basedir)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, basedir, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
  instance.name = name;
	instance.MacOSWarningTime = 0;
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
        if self.MacOSWarningTime > 0 then
            g_currentMission:addWarning("\n"..g_i18n:getText("NotForMacOS"), 0.018, 0.033);
            self.MacOSWarningTime = (self.MacOSWarningTime - 1);
        end;
        if (self.name == "light") then
            if self.vehicle.lightsActive ~= self.isOpen then
                self.isOpen = self.vehicle.lightsActive;
                self.lightActive = self.vehicle.lightsActive;
            end;
        elseif (self.name == "rulWorklight") then
            if self.vehicle.beaconLightsActive ~= self.isOpen then
                self.isOpen = self.vehicle.beaconLightsActive;
                self.rulActive = self.vehicle.beaconLightsActive;
            end;
        elseif (self.name == "BEL3WARN") then
            if self.vehicle.B3.wl ~= self.isOpen then
                self.isOpen = self.vehicle.B3.wl;
            end;
        elseif (self.name == "motorWork") then
            if self.vehicle.ignitionKey ~= self.isOpen then
                self.isOpen = self.vehicle.ignitionKey;
            end;
        end;
		--self.isOpen = self.vehicle.currentLight == 2;
	end; 
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(dt)
    if self.event == "toggleFrontwork" then
        if self.vehicle ~= nil then
            if self.frontworkActive then
                self.isOpen = false;
                self.vehicle:setState("work:1", false);
                self.frontworkActive = false;
            else
                self.isOpen = true;
                self.vehicle:setState("work:1", true);
                self.frontworkActive = true;
            end;
        end;
    elseif self.event == "toggleRearwork" then
        if self.vehicle ~= nil then
            if self.backworkActive then
                self.isOpen = false;
                self.vehicle:setState("work:2", false);
                self.backworkActive = false;
            else
                self.isOpen = true;
                self.vehicle:setState("work:2", true);
                self.backworkActive = true;
            end;
        end;
    elseif self.event == "togglePipework" then
        if self.vehicle ~= nil then
            if self.pipeworkActive then
                self.isOpen = false;
                self.vehicle:setState("work:3", false);
                self.pipeworkActive = false;
            else
                self.isOpen = true;
                self.vehicle:setState("work:3", true);
                self.pipeworkActive = true;
            end;
        end;
    elseif self.event == "toggleRUL" then
        if self.vehicle ~= nil then
            if self.rulActive then
                self.isOpen = false;
                if self.vehicle.isServer then
                    self.vehicle:setBeaconLightsVisibility(false);
                end;
                self.rulActive = false;
            else
                self.isOpen = true;
                if self.vehicle.isServer then
                    self.vehicle:setBeaconLightsVisibility(true);
                end;
                self.rulActive = true;
            end;
        end;
    elseif self.event == "toggleLightstate" then
        if self.vehicle ~= nil then
            if self.lightActive then
                self.isOpen = false;
                self.vehicle:setLightsVisibility(false);
                self.lightActive = false;
            else
                self.isOpen = true;
                self.vehicle:setLightsVisibility(true);
                self.lightActive = true;
            end;
        end;
    elseif self.event == "toggleLexionmotor" then
		if self.vehicle ~= nil then
            if self.vehicle.isServer then
                if self.vehicle.ignitionKey then
                    self.isOpen = false;               
					self.vehicle:updateVehicleState(false);
				else
					self.isOpen = true;
					self.vehicle:updateVehicleState(true);
				end;
			end;
		end;
	elseif self.event == "toggleWarningLights" then
		if self.vehicle ~= nil then
			if self.vehicle.B3.wl then
				self.isOpen = false;
				self.vehicle:setState("warnlights", false);
				self.vehicle:setState("dirLeft", false);
				self.vehicle:setState("dirRight", false);
			else
				self.isOpen = true;
				self.vehicle:setState("warnlights", true);
				self.vehicle:setState("dirLeft", true);
				self.vehicle:setState("dirRight", true);
			end;
		end;
    elseif self.event == "toggleCamwork" then
        if self.vehicle ~= nil then
            local nBeginn, nEnde = string.find(Button.Folder,"/Library/Application Support/");
            if(nBeginn == nil or nEnde == nil) then
                if self.vehicle.LEXM then
                    self.isOpen = false;
                    self.vehicle.LEXM = false;
                    setCamera(0,1);
                    self.vehicle.viewportID = 0;
                else
                    self.isOpen = true;
                    self.vehicle.LEXM = true;
                    self.vehicle.viewportID = 0;
                end;
            else
                self.MacOSWarningTime = 90;
            end;
        end;
    end;	
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;