szecskaEvent = {};
szecskaEvent_mt = Class(szecskaEvent, Event);

InitEventClass(szecskaEvent, "szecskaEvent");

function szecskaEvent:emptyNew()
    local self = Event:new(szecskaEvent_mt);
    self.className="szecskaEvent";
    return self;
end;

function szecskaEvent:new(object, isActive)
    local self = szecskaEvent:emptyNew()
    self.object = object;
	self.isActive = isActive;
    return self;
end;

function szecskaEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isActive = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function szecskaEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isActive);
end;

function szecskaEvent:run(connection)
	self.object:setszecskaActive(self.isActive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(szecskaEvent:new(self.object, self.isActive), nil, connection, self.object);
    end;	
end;

function szecskaEvent.sendEvent(szecska, isActive)
	if g_server ~= nil then
		g_server:broadcastEvent(szecskaEvent:new(szecska, isActive), nil, nil, szecska);
	else
		g_client:getServerConnection():sendEvent(szecskaEvent:new(szecska, isActive));
	end;
end;

