--
-- Straw Specialization for Combines
-- Szecskazo Script Kombajnokhoz! 100% Multiplayer ready!
--
-- @author  Templaer
-- @date  24/05/09
-- @edit Farok
-- @date 2012/10/06


szecska = {};

function szecska.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function szecska:load(xmlFile)
	self.setszecskaActive = SpecializationUtil.callSpecializationsFunction("setszecskaActive");

   

    -- Straw Active Boolean
    self.strawActive = true;
	
	
end;

function szecska:readStream(streamId, connection)
	self:setszecskaActive(streamReadBool(streamId), true);
end;

function szecska:writeStream(streamId, connection)
	streamWriteBool(streamId, self.strawActive);
end;

function szecska:delete()
end;

function szecska:mouseEvent(posX, posY, isDown, isUp, button)
end;

function szecska:keyEvent(unicode, sym, modifier, isDown)
end;

function szecska:update(dt)
    -- Check for input
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.szecska) then
		    self:setszecskaActive(not self.strawActive);
		end;
    end;
	-- Check if straw is enabled
	if not self.strawActive then
		self.strawEmitState = false;
		self.strawEnableTime = nil;
		self.chopperActivated = true;
		self.chopperBlind = nil;
			
		
					
		-- Enable chopper particle system					
		if self.lastArea > 0 then
			if self.chopperActivated then
				if self.chopperEnableTime == nil then
					self.chopperEnableTime = self.time + self.chopperToggleTime;
				else
					self.chopperDisableTime = nil;
				end;
				disableChopperEmit = false;
			end;
			
			-- Chopper starting delay
			if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
				self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
				if self.currentChopperParticleSystem == nil then
					self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
				end;
				Utils.setEmittingState(self.currentChopperParticleSystem, true);
			end;
		end;	
	elseif self.strawActive then
		self.chopperBlind = self.backupChopperBlind;
	end;
end;

function szecska:draw()
end;

function szecska:setszecskaActive(isActive, noEventSend)
	self.strawActive = isActive;
	if noEventSend ~= true then
		szecskaEvent.sendEvent(self, isActive);
	end;
	
end;