script = {};
local RTK_mt = Class(script);


function script.prerequisitesPresent(specializations)
    return true;
	end;

function script:load(xmlFile)
	local numCuttingAreasBow = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreasBow#count"), 0);
	self.cuttingAreasBow = {};
    for i=1, numCuttingAreasBow do
        self.cuttingAreasBow[i] = {};
        local areanamei = string.format("vehicle.cuttingAreasBow.cuttingArea%d", i);
        self.cuttingAreasBow[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasBow[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasBow[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;

	self.rotors = {};
    local psFile = getXMLString(xmlFile, "vehicle.rotors.rotor(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.rotors.rotor(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.rotors, node);
            end;
            i = i+1;
        end;
    end;
	
	self.up = false;

end;

function script:delete()
end;

function script:onAttach(attacherVehicle)
end;

function script:onDetach()
end;

function script:readStream(streamId, connection)
end;

function script:writeStream(streamId, connection)
end;

function script:mouseEvent(posX, posY, isDown, isUp, button)
end;

function script:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_b then
		self.markOn = not self.markOn; 
	end; 	

end;

function script:update(dt)
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self.up = not self.up;
			end;
	if self.markOn and not self.up then		
			for i=1, table.getn(self.rotors) do
				local rotor = self.rotors[i].index;
				local rotorRot = (-0.04*self.rotors[i].direction)*dt;
				rotate(rotor, 0, rotorRot, 0);
			end;
				if self.cuttingAreasBow[1] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[1].height);		
					Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
					Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
					Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
				end;
				if self.cuttingAreasBow[2] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[2].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[2].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[2].height);		
					Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
					Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
					Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
				end;
				if self.cuttingAreasBow[3] ~= nil then
					local x,y,z = getWorldTranslation(self.cuttingAreasBow[3].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreasBow[3].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreasBow[3].height);		
					Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
					Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
					Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
				end;
	end; 

end;

function script:updateTick(dt)
end;

function script:draw()
end;

function script:addOperatingTime(addTime)
end;

function script:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
end;

function script:getSaveAttributesAndNodes(nodeIdent)
end;