wheelextra = {};

function wheelextra.prerequisitesPresent(specializations)
    return true;
end;

function wheelextra:load(xmlFile)

	self.on = false;
	
	wheelextra.cultiId = g_currentMission.cultivatorChannel;
	wheelextra.sowingId = g_currentMission.sowingChannel;
	wheelextra.detailId = g_currentMission.terrainDetailId;
	wheelextra.ploughId = g_currentMission.ploughChannel;
	wheelextra.sprayId = g_currentMission.sprayChannel;
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
	
	local numWheelAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelAreas#count"), 0);
    self.wheelAreas = {}
    for i=1, numWheelAreas do
        self.wheelAreas[i] = {};
        local areanamei = string.format("vehicle.wheelAreas.wheelArea%d", i);
        self.wheelAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.wheelAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.5)
        self.wheelAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;
	
	-- Dclaration de la prise de force et de la lame dans le XML
    self.PriseDeForce = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PriseDeForce#index"));
    self.PriseDeForceSpeed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PriseDeForce#speed"));
    self.Lame = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lame#index"));
    self.LameSpeed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lame#speed"));  
end;

function wheelextra:delete()
end;

function wheelextra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelextra:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_t and isDown then
		self.on = not self.on;
	end;

end;

function wheelextra:update(dt)

	if self:getIsActive() then
		if self.on then	
			
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);	

            if terrainHeight+self.groundReferenceThreshold >= y then -- On vrifie si la machine est bien contre le sol
				for k, wheelArea in pairs(self.wheelAreas) do
					local x,y,z = getWorldTranslation(wheelArea.point);
					local w = wheelArea.width;
					local h = wheelArea.height;
					local x1 = x + h/2
					local x2 = x - h/2
					local z1 = z + w/2
					local z2 = z - w/2					
					
				for k, cuttingArea in pairs(self.cuttingAreas) do
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2);
					Utils.updateDestroyCommonArea(x, z, x1, z1, x2, z2)
--					setDensityMaskedParallelogram(detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, ploughId, 0, detailId, sowingId, 1, 1)
--					setDensityMaskedParallelogram(detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, ploughId, 0, detailId, cultiId, 1, 1)
--					setDensityMaskedParallelogram(detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, sowingId, 1, detailId, sowingId, 1, 1)
--					setDensityMaskedParallelogram(detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, sowingId, 1, detailId, cultiId, 1, 1)
					setDensityParallelogram(wheelextra.detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, wheelextra.sowingId, 1, 0)
					setDensityParallelogram(wheelextra.detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, wheelextra.ploughId, 1, 0)
					setDensityParallelogram(wheelextra.detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, wheelextra.cultiId, 1, 0)
					setDensityParallelogram(wheelextra.detailId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, wheelextra.sprayId, 1, 0)
--					Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
				end;
					Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
					Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);					
					Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
					Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
				end;
			end;
			-- On "dit" a la lame et  la prise de force de tourner
			rotate(self.PriseDeForce, 0, 0, dt*self.PriseDeForceSpeed);
			rotate(self.Lame, 0, dt*self.LameSpeed, 0);			
		end;
	end;
end;


function wheelextra:draw()
	if self.on then
		g_currentMission:addExtraPrintText("Touche T: Stop Kuhn Bav 1545");
	else
		g_currentMission:addExtraPrintText("Touche T: Start Kuhn Bav 1545");
	end;
end;

