wheelextra = {};

function wheelextra.prerequisitesPresent(specializations)
    return true;
end;

function wheelextra:load(xmlFile)
	local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end; 
	self.isTurnedOn = false;
	self.groundCheck = {};
	self.groundCheck = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundCheck#index"));
	-- Dclaration de la prise de force et de la lame dans le XML
    self.PriseDeForce = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PriseDeForce#index"));
    self.PriseDeForceSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PriseDeForce#speed"), 1);
end;

function wheelextra:delete()
end;

function wheelextra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelextra:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_b and isDown then
		self.isTurnedOn = not self.isTurnedOn;
	end;

end;

function wheelextra:update(dt)

		if self.isTurnedOn then	
			-- On "dit" a la lame et  la prise de force de tourner
			rotate(self.PriseDeForce, 0, 0, 1*self.PriseDeForceSpeed);
			local x,y,z = getWorldTranslation(self.groundCheck);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gC = y-terrainHeight; 
		
			if (math.min(gC) < 0.5) then
			  self.go = true;
			else
			  self.go = false;
			end;	

	if self.go then
		        if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
				Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
				Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
				Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
				end;
	end;
		if not self.mowerSoundRunning then
                print("start");
                playSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = true;				
		end;	
	else
	   if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
		
	  end;	
	end;	
end;


function wheelextra:draw()
	if self.isTurnedOn then
		g_currentMission:addExtraPrintText("Touche B : Stop broyeur Kuhn BPR240");
	else
		g_currentMission:addExtraPrintText("Touche B : Start broyeur Kuhn BPR240");
	end;
end;

function epareuse:onDetach()
  self.isTurnedOn = false;
	 stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;   
end;



function epareuse:onDeactivateSounds()
   if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
			end;
end;
