ecrasement = {};

function ecrasement.prerequisitesPresent(specializations)
    return true;
end;

function ecrasement:load(xmlFile)

	self.on = true;

	local numWheelAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelAreas#count"), 0);
    self.wheelAreas = {}
    for i=1, numWheelAreas do
        self.wheelAreas[i] = {};
        local areanamei = string.format("vehicle.wheelAreas.wheelArea%d", i);
        self.wheelAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.wheelAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.5)
        self.wheelAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;
end;

function ecrasement:delete()
end;

function ecrasement:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ecrasement:keyEvent(unicode, sym, modifier, isDown)
end;

function ecrasement:update(dt)
	if self.on then
		for k, wheelArea in pairs(self.wheelAreas) do
			local x,y,z = getWorldTranslation(wheelArea.point);
			local w = wheelArea.width;
			local h = wheelArea.height;
			local x1 = x + h/2
			local x2 = x - h/2
			local z1 = z + w/2
			local z2 = z - w/2
		
		
			Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 8, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 9, x1, z2, x1, z1, x2, z2);

		end;
	end;
end;

function ecrasement:draw()
end;