--
-- Claas Quadrant 3200 Haecksler
-- Specialization for Claas Quadrant 3200 Haecksler

QuadrantHaecksler = {};

function QuadrantHaecksler.prerequisitesPresent(specializations)
    return true;
end;


function QuadrantHaecksler:load(xmlFile)
	self.setAllumer = SpecializationUtil.callSpecializationsFunction("setAllumer");	

	-- Rotor --	
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	self.allumer = false;
	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;

	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;

end;

function QuadrantHaecksler:delete()
	if self.workSound ~= nil then
        delete(self.workSound);
		self.workSound = nil;
    end;
end;

function QuadrantHaecksler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function QuadrantHaecksler:keyEvent(unicode, sym, modifier, isDown)
end;
function QuadrantHaecksler:readStream(streamId, connection)
   self:setAllumer(streamReadBool(streamId), true);
end;

function QuadrantHaecksler:writeStream(streamId, connection)
	streamWriteBool(streamId, self.allumer);
end;

function QuadrantHaecksler:readUpdateStream(streamId, timestamp, connection)
end;

function QuadrantHaecksler:writeUpdateStream(streamId, connection, dirtyMask)
end;

function QuadrantHaecksler:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.HEACKSLER) and self.B3.work[1].a == true  then
			self:setAllumer(not self.allumer);	
		end;

		if self.B3.work[1].a == false and self.allumer then
			self.allumer = false;	
		end;	
	end;
end;

function QuadrantHaecksler:updateTick(dt)
	if self:getIsActive() then
		if self.allumer then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;
			if not self.workSoundEnabled and self:getIsActiveForSound() then
				playSample(self.workSound, 0, self.workSoundVolume, 0);
				setSamplePitch(self.workSound, self.workSoundPitchOffset);
				self.workSoundEnabled = true;
			end;	
		else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
			if self.workSoundEnabled then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;				
        end;
	end;
end;

function QuadrantHaecksler:draw()
	if self.allumer then
		g_currentMission:addHelpButtonText(g_i18n:getText("VBH_OFF"), InputBinding.HEACKSLER);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("VBH_ON"), InputBinding.HEACKSLER);	
	end;	
	
	--[[if self.drawhaecksler then
		g_currentMission:addHelpButtonText(g_i18n:getText("VBH_AUS"), InputBinding.HEACKSLER_ON);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("VBH_EIN"), InputBinding.HEACKSLER_ON);
	end;]]
end;

function QuadrantHaecksler:onDeactivate()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
	
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;		
	end;	
end;

function QuadrantHaecksler:onLeave()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	
	self.allumer = false;
	
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;		
	end;
	
end;

function QuadrantHaecksler:onDetach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
	
	if self.workSound ~= nil then
		stopSample(self.workSound);
	end;
end;

function QuadrantHaecksler:onAttach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
	
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;		
	end;	
end;

function QuadrantHaecksler:setAllumer(allumer, noEventSend)
	SetAllumerEvent.sendEvent(self, allumer, noEventSend)
	self.allumer = allumer;
end;