SetTransportEvent = {};
SetTransportEvent_mt = Class(SetTransportEvent, Event);

InitEventClass(SetTransportEvent, "SetTransportEvent");

function SetTransportEvent:emptyNew()
    local self = Event:new(SetTransportEvent_mt);
    self.className="SetTransportEvent";
    return self;
end;

function SetTransportEvent:new(object, isTransport)
    local self = SetTransportEvent:emptyNew()
    self.object = object;
	self.isTransport = isTransport;
    return self;
end;

function SetTransportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isTransport = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetTransportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isTransport);
end;

function SetTransportEvent:run(connection)
	self.object:setTransport(self.isTransport, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTransportEvent:new(self.object, self.isTransport), nil, connection, self.object);
    end;	
end;

function SetTransportEvent.sendEvent(vehicle, isTransport, noEventSend)
	if isTransport ~= vehicle.isTransport then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetTransportEvent:new(vehicle, isTransport), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetTransportEvent:new(vehicle, isTransport));
			end;
		end;
	end;
end;

