--
-- Conspeed
-- Specialization for Conspeed
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--

Conspeed = {};

function Conspeed.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function Conspeed:load(xmlFile)
	
	self.conspeed = {};
	self.conspeed.speedScaleTime = 5000;
	self.conspeed.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.conspeed#speed"), 11);
	self.conspeed.rollSpeedBackup = self.rollNodes[1].speed;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.backup = rollNode.speed;
		rollNode.speed = 0;
	end;
	
	self.startThreshingBackup = nil;
	
	self.printFoldingError = 0;
	self.printTurnOnError = 0;
end;

function Conspeed:delete()
end;

function Conspeed:readStream(streamId, connection)
end;

function Conspeed:writeStream(streamId, connection)
end;

function Conspeed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Conspeed:keyEvent(unicode, sym, modifier, isDown)
end;

function Conspeed:update(dt)
	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastAreaBiggerZero and self.particleSystemsVisible));
	
	if self:getIsActive() and self.reelStarted then	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.conspeed.speed, 1.5));
	
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.conspeed.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.conspeed.speed, 1.5));
		
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.conspeed.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;	
end;

function Conspeed:updateTick(dt)
	if self:getIsActive() and self.reelStarted then
	    local camera = getCamera();
		if camera ~= 0 then
			local x,y,z = getWorldTranslation(camera);
			local x1,y1,z1 = getWorldTranslation(self.rootNode);
			local distance = Utils.vector3Length(x-x1,y-y1,z-z1);
			local visible = (distance < 300);
			if visible ~= self.particleSystemsVisible then			
				self.particleSystemsVisible = visible;
			end;
		end;		
	end;
end;

function Conspeed:draw()
	if self.printFoldingError > self.time then
		g_currentMission:addWarning(g_i18n:getText("PLEASE_TURNOFF_CHOPPER_FIRST"), 0.018, 0.033);
	end;
	if self.printTurnOnError > self.time then
		g_currentMission:addWarning(g_i18n:getText("PLEASE_UNFOLD_CHOPPER_FIRST"), 0.018, 0.033);
	end;
end;

function Conspeed:onAttach(attacherVehicle)
	self.combine = attacherVehicle;
	if self.combine.threshingStartSound ~= nil then
		self.startThreshingBackup = self.combine.threshingStartSound;
	end;
end;

function Conspeed:onDetach()	
	if self.startThreshingBackup ~= nil then
		self.combine.threshingStartSound = self.startThreshingBackup;
	end;
	
	self.combine = nil;
end; 

function Conspeed:onStartReel()
	if self.foldAnimTime < 1 then
		if self.combine.isAIThreshing then
			self.combine:stopAIThreshing(true);
		else
			self.combine:setIsThreshing(false, true);
		end;
		self.printTurnOnError = self.time + 1800;	
		self.combine.threshingStartSound = nil;
	else
		self.combine.threshingStartSound = self.startThreshingBackup;
	end;
end;

function Conspeed:setFoldDirection(direction, noEventSend)
	if self.reelStarted and direction == -1 then
		self.printFoldingError = self.time + 1800;
		self:setFoldDirection(1, true);
	end;
end;