--
-- FastCouplerAttachment
-- Specialization for FastCouplerAttachment
--
-- @author  Manuel Leithner
-- @date  10/08/09
--

FastCouplerAttachment = {};

function FastCouplerAttachment.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function FastCouplerAttachment:load(xmlFile)
	
	self.onFastCouplerAttach = SpecializationUtil.callSpecializationsFunction("onFastCouplerAttach");
	self.onFastCouplerDetach = SpecializationUtil.callSpecializationsFunction("onFastCouplerDetach");

	self.fastCouplerAttacher = nil;
	self.fastCouplerJoint = nil;
	self.doJointSearch = false;
end;

function FastCouplerAttachment:delete()
end;

function FastCouplerAttachment:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FastCouplerAttachment:keyEvent(unicode, sym, modifier, isDown)
end;

function FastCouplerAttachment:update(dt)

	if self.doJointSearch then
		for k,v in pairs(self.fastCouplerAttacher.attachedImplements) do
			if v.object == self.attacherVehicle then
				local joint = self.fastCouplerAttacher.attacherJoints[v.jointDescIndex];
				self.fastCouplerJoint = joint;			
			end;
		end;
		self.doJointSearch = false;
	end;	
end;

function FastCouplerAttachment:draw()
end;


function FastCouplerAttachment:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self.fastCouplerAttacher = attacherVehicle.attacherVehicle;	
	self:onFastCouplerAttach(self.fastCouplerAttacher);	
end;

function FastCouplerAttachment:onDetach()
	self:onFastCouplerDetach();
end;

function FastCouplerAttachment:onFastCouplerDetach()
	self.fastCouplerAttacher = nil;
	self.fastCouplerJoint = nil;
end;

function FastCouplerAttachment:onFastCouplerAttach(attacherVehicle)
	self.fastCouplerAttacher = attacherVehicle;
	self.doJointSearch = true;
end;




