--
-- BuyableTwinWheelsAttacher
-- Specialization for BuyableTwinWheelsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- @history:	v1.0 and v2.0 by SFM
--				v2.1 changes by fruktor for Fendt 615 (left and right side, but unspecific HUD-text)
--

BuyableTwinWheelsAttacher = {};

function BuyableTwinWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableTwinWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.buyableTwinWheels.twinWheelsLeft = nil;
	self.buyableTwinWheels.twinWheelsRight = nil;
	self.buyableTwinWheels.wheelsInRange = nil;	

	-- Ausblendung
	self.Ausblendung_I = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ausblendung_I#index"));
	self.Ausblendung_II = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ausblendung_II#index"));
end;

function BuyableTwinWheelsAttacher:delete()
	if self.buyableTwinWheels.twinWheels ~= nil then
		self.buyableTwinWheels.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableTwinWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableTwinWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableTwinWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableTwinWheels;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.CLAAS_BUYABLE_TWINWHEELS_ATTACH) then
					if wheels.twinWheelsLeft == nil and string.match(wheels.wheelsInRange.side, "left") then
						wheels.wheelsInRange:assembleWheels(self);
					elseif wheels.twinWheelsRight == nil and string.match(wheels.wheelsInRange.side, "right") then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableTwinWheelsAttacher:draw()
	local wheels = self.buyableTwinWheels;
	if wheels.wheelsInRange ~= nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_text"), InputBinding.CLAAS_BUYABLE_TWINWHEELS_ATTACH);
		
		_=[[if wheels.twinWheelsLeft ~= nil or self.twinWheelRight ~= nil then
			--if wheels.wheelsInRange.twinWheelsUser == self then
			
			--if wheels.twinWheelsLeft ~= nil and wheels.wheelsInRange.twinWheelsUser == self then
			if wheels.wheelsInRange.twinWheelsUser == self then
				
			--elseif wheels.twinWheelsRight ~= nil and wheels.wheelsInRange.twinWheelsUser == self then
				--g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.CLAAS_BUYABLE_TWINWHEELS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.CLAAS_BUYABLE_TWINWHEELS_ATTACH);
			end;
		end;]]
	end;
end;

function BuyableTwinWheelsAttacher:onAssembling(buyableTwinWheels)
	--self.buyableTwinWheels.twinWheels = buyableTwinWheels;
	if string.match("right", buyableTwinWheels.side) then
		self.buyableTwinWheels.twinWheelsRight = buyableTwinWheels;
	else
		self.buyableTwinWheels.twinWheelsLeft = buyableTwinWheels;
		setVisibility(self.Ausblendung_I, false);
		setVisibility(self.Ausblendung_II, true);
	end;
end;

function BuyableTwinWheelsAttacher:onDisassembling()
	--self.buyableTwinWheels.twinWheels = nil;
	if self.buyableTwinWheels.wheelsInRange == self.buyableTwinWheels.twinWheelsRight then
		self.buyableTwinWheels.twinWheelsRight = nil;
	elseif self.buyableTwinWheels.wheelsInRange == self.buyableTwinWheels.twinWheelsLeft then
		self.buyableTwinWheels.twinWheelsLeft = nil;
		setVisibility(self.Ausblendung_I, true);
		setVisibility(self.Ausblendung_II, false);
	end;	
end;
