--
-- fruitAnimationCornHeader
-- Implementation of fruit animation
--
-- @author  Knagsted
-- @date  16/7/10
--
-- Do not edit without my permission
--

fruitAnimationCornHeader = {};

function fruitAnimationCornHeader.prerequisitesPresent(specializations)
    return true;
end;

function fruitAnimationCornHeader:load(xmlFile)
    self.animateRowCrop = SpecializationUtil.callSpecializationsFunction("animateRowCrop");
	
	self.fruitLeft1Count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fruitLeft#count"),0);
    self.fruitLeft1 = {};
	self.fruitLeft1.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fruitLeft#startTranslation"),-2.25);
	self.fruitLeft1.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fruitLeft#endTranslation"),0);
	
    for i=1, self.fruitLeft1Count do
        local objname = string.format("vehicle.fruitLeft.fruit" .. "%d",i);
        self.fruitLeft1[i] = {};
        self.fruitLeft1[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
		self.fruitLeft1[i].fruitType = getXMLString(xmlFile, objname .. "#fruitType");
		local x,y,z = getTranslation(self.fruitLeft1[i].rotNode);
		self.fruitLeft1[i].startPositionX = x;
		self.fruitLeft1[i].startPositionY = y;
		self.fruitLeft1[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.fruitLeft1[i].rotNode);
		self.fruitLeft1[i].startRotationX = xRot;
		self.fruitLeft1[i].startRotationY = yRot;
		self.fruitLeft1[i].startRotationZ = zRot;
		local xScale, yScale, zScale = getScale(self.fruitLeft1[i].rotNode);
		self.fruitLeft1[i].startScaleX = xScale;
		self.fruitLeft1[i].startScaleY = yScale;
		self.fruitLeft1[i].startScaleZ = zScale;
		self.fruitLeft1[i].setVisible = false;
		setVisibility(self.fruitLeft1[i].rotNode, self.fruitLeft1[i].setVisible);
    end;
	
	self.fruitRight1Count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fruitRight#count"),0);
    self.fruitRight1 = {};
	self.fruitRight1.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fruitRight#startTranslation"),-2.25);
	self.fruitRight1.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fruitRight#endTranslation"),0);
	
    for i=1, self.fruitRight1Count do
        local objname = string.format("vehicle.fruitRight.fruit" .. "%d",i);
        self.fruitRight1[i] = {};
        self.fruitRight1[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
		self.fruitRight1[i].fruitType = getXMLString(xmlFile, objname .. "#fruitType");
		local x,y,z = getTranslation(self.fruitRight1[i].rotNode);
		self.fruitRight1[i].startPositionX = x;
		self.fruitRight1[i].startPositionY = y;
		self.fruitRight1[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.fruitRight1[i].rotNode);
		self.fruitRight1[i].startRotationX = xRot;
		self.fruitRight1[i].startRotationY = yRot;
		self.fruitRight1[i].startRotationZ = zRot;
		local xScale, yScale, zScale = getScale(self.fruitRight1[i].rotNode);
		self.fruitRight1[i].startScaleX = xScale;
		self.fruitRight1[i].startScaleY = yScale;
		self.fruitRight1[i].startScaleZ = zScale;
		self.fruitRight1[i].setVisible = false;
		setVisibility(self.fruitRight1[i].rotNode, self.fruitRight1[i].setVisible);
    end;
	
	self.cutterIndexesLeftCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cutterIndexesLeft#count"),0);
    self.cutterIndexesLeft = {};
    for i=1, self.cutterIndexesLeftCount do
        local objname = string.format("vehicle.cutterIndexesLeft.indexer" .. "%d",i);
        self.cutterIndexesLeft[i] = {};
        self.cutterIndexesLeft[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.cutterIndexesLeft[i].widthNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#widthNode"));
        self.cutterIndexesLeft[i].heightNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#heightNode"));
    end;
	
	self.cutterIndexesRightCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cutterIndexesRight#count"),0);
    self.cutterIndexesRight = {};
    for i=1, self.cutterIndexesRightCount do
        local objname = string.format("vehicle.cutterIndexesRight.indexer" .. "%d",i);
        self.cutterIndexesRight[i] = {};
        self.cutterIndexesRight[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.cutterIndexesRight[i].widthNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#widthNode"));
        self.cutterIndexesRight[i].heightNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#heightNode"));
    end;
	
	self.fruitRowCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fruitRow#count"),0);
    self.fruitRow = {};
	self.fruitRow.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fruitRow#startTranslation"),0);
	self.fruitRow.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fruitRow#endTranslation"),1.4);
	
    for i=1, self.fruitRowCount do
        local objname = string.format("vehicle.fruitRow.fruit" .. "%d",i);
        self.fruitRow[i] = {};
        self.fruitRow[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
		self.fruitRow[i].fruitType = getXMLString(xmlFile, objname .. "#fruitType");
		local x,y,z = getTranslation(self.fruitRow[i].rotNode);
		self.fruitRow[i].startPositionX = x;
		self.fruitRow[i].startPositionY = y;
		self.fruitRow[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.fruitRow[i].rotNode);
		self.fruitRow[i].startRotationX = xRot;
		self.fruitRow[i].startRotationY = yRot;
		self.fruitRow[i].startRotationZ = zRot;
		local xScale, yScale, zScale = getScale(self.fruitRow[i].rotNode);
		self.fruitRow[i].startScaleX = xScale;
		self.fruitRow[i].startScaleY = yScale;
		self.fruitRow[i].startScaleZ = zScale;
		self.fruitRow[i].setVisible = false;
		setVisibility(self.fruitRow[i].rotNode, self.fruitRow[i].setVisible);
    end;
	

	self.advancedCutterEnabled = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.advancedCutter#enabled"),false);
	self.currentBlockingTimeLeft = 0;
	self.currentBlockingTimeRight = 0;
	if self.advancedCutterEnabled then
		self.advancedCutterDifficulty = math.floor(10/(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.advancedCutter#difficulty"),1)));
		if self.advancedCutterDifficulty == 0 then
			self.advancedCutterDifficulty = 1;
		end;
		
		self.headerLeftBlockingTime = math.random(1*self.advancedCutterDifficulty, 300*self.advancedCutterDifficulty)*1000;
		self.headerRightBlockingTime = math.random(1*self.advancedCutterDifficulty, 300*self.advancedCutterDifficulty)*1000;
		self.leftBlockingCycles = 0;
		self.rightBlockingCycles = 0;
	end;
	for k,area in pairs(self.cuttingAreas) do
		local x,y,z = getTranslation(area.start);
		self.leftTranslationX = x;
		local x1,y1,z1 = getTranslation(area.width);
		self.rightTranslationX = x1;
	end;
		
	self.stopHarvestingAtTime = 1500;
	
    self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 2500);
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
	self.showFruits = false;
	self.emptyHead = true;
	self.areaCounter = 0;
	self.startXTranslationLeft = 0;
	self.lastStartXTranslationLeft = 0;
	self.startXTranslationRight = 0;
	self.lastStartXTranslationRight = 0;
	self.cycleRoundMax = 10;
	self.currentCycle = 0;
	self.dtAverage = 0;
	self.dtSum = 0;
	self.currentTime = 0
	self.resetFruitTime = 60000;
	self.normalSpeed = 8;
	self.blockingSpeedFactor = 1;
	self.resetRows = false;
	self.cycleCount = 0;
end;

function fruitAnimationCornHeader:delete()
end;

function fruitAnimationCornHeader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fruitAnimationCornHeader:keyEvent(unicode, sym, modifier, isDown)
end;

function fruitAnimationCornHeader:update(dt)

	--if self.fruitLeft1[1].rotNode ~= nil then
		--renderText(0.5, 0.7, 0.02, string.format("1 ok"));
	--else
		--renderText(0.5, 0.7, 0.02, string.format("1 is nil"));
	--end;
	--find the current position of fruit
	--Evaluate if fruit in header should be shown (Might delete this section)
	local disableStrawEmit = true;
	if self.lastArea > 0 then
		self.showFruits = true;
		self.areaCounter = self.areaCounter + 1;
		if self.areaCounter > 20 then
			self.areaCounter = 20;
		end;
		
		if self.strawEnableTime == nil then
			self.strawEnableTime = self.time + self.strawToggleTime;
		else
			self.strawDisableTime = nil;
		end;
		disableStrawEmit = false;
	else
		self.areaCounter = self.areaCounter - 1;
		if self.areaCounter < 0 then
			self.areaCounter = 0;
		end;
	end;
	
	self.emptyHead = true;
	if self.areaCounter > 0 then
		self.emptyHead = false;
	end;
	
	if disableStrawEmit and self.strawDisableTime == nil then
		self.strawDisableTime = self.time + self.strawToggleTime;
	end;
	
	if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
		self.strawEnableTime = nil;
		--self.showFruits = true;
	end;
	
	if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
        self.strawDisableTime = nil;
		self.showFruits = false;
    end;
	
	local leftBlockIndex1 = -1;
	local leftBlockIndex2 = -1;
	if self.blockLeft then
		leftBlockIndex1 = math.random(5,8) * 2;
		leftBlockIndex2 = leftBlockIndex1 + 1;
	end;
	
	local leftArea = 0;
	for i=1, self.cutterIndexesLeftCount do
		local x,y,z = getWorldTranslation(self.cutterIndexesLeft[i].rotNode);
		local x1,y1,z1 = getWorldTranslation(self.cutterIndexesLeft[i].widthNode);
		local x2,y2,z2 = getWorldTranslation(self.cutterIndexesLeft[i].heightNode);  		
		local currentLeftArea = Utils.getFruitArea(self.currentFruitType, x, z, x1, z1, x2, z2);
		leftArea = currentLeftArea;
		
		if leftArea > 0 then
			local x,y,z = getTranslation(self.cutterIndexesLeft[i].rotNode);
			self.currentLeftX = x;
		elseif self.lastArea == 0 then
			self.currentLeftX = 0;
		end;
		
		--Now do fruit row handling
		if self.attacherVehicle ~= nil then
			local x3,y3,z3 = getTranslation(self.cutterIndexesLeft[i].rotNode);
			local x4,y4,z4 = getTranslation(self.cutterIndexesLeft[i].widthNode);
			
			for h=1, self.fruitRowCount do
				if self.fruitRow[h].startPositionX <= x3 and self.fruitRow[h].startPositionX >= x4 then
					--The fruit row unit we are dealing with is within an row index that has the current fruit type
					self:animateRowCrop(self.fruitRow[h], self.fruitRow.startTranslation, self.fruitRow.endTranslation, dt, h, self.fruitRowCount, currentLeftArea, self.blockLeft)
				end;
			end;
		end;
	end;
	
	local rightArea = 0;
	for i=1, self.cutterIndexesRightCount do
		local x,y,z = getWorldTranslation(self.cutterIndexesRight[i].rotNode);
		local x1,y1,z1 = getWorldTranslation(self.cutterIndexesRight[i].widthNode);
		local x2,y2,z2 = getWorldTranslation(self.cutterIndexesRight[i].heightNode);  		
		local currentRightArea = Utils.getFruitArea(self.currentFruitType, x, z, x1, z1, x2, z2);
		rightArea = currentRightArea;
		
		if rightArea > 0 then
			local x,y,z = getTranslation(self.cutterIndexesRight[i].rotNode);
			self.currentRightX = x;
		elseif self.lastArea == 0 then
			self.currentRightX = 0;
		end;
		
		--Now do fruit row handling
		if self.attacherVehicle ~= nil then
			local x3,y3,z3 = getTranslation(self.cutterIndexesRight[i].rotNode);
			local x4,y4,z4 = getTranslation(self.cutterIndexesRight[i].widthNode);
			
			for h=1, self.fruitRowCount do
				if -self.fruitRow[h].startPositionX <= x3 and -self.fruitRow[h].startPositionX >= x4 then
					--The fruit row unit we are dealing with is within an row index that has the current fruit type
					self:animateRowCrop(self.fruitRow[h], self.fruitRow.startTranslation, self.fruitRow.endTranslation, dt, h, self.fruitRowCount, currentRightArea, self.blockRight)
				end;
			end;
		end;
	end;
	
	if self.currentCycle < self.cycleRoundMax then
		self.dtSum = self.dtSum + dt;
		self.currentCycle = self.currentCycle + 1;
		self.lastStartXTranslationLeft = (self.lastStartXTranslationLeft + self.currentLeftX)/2;
		self.lastStartXTranslationRight = (self.lastStartXTranslationRight + self.currentRightX)/2;
	else
		self.currentCycle = 0;
		self.startXTranslationLeft = self.lastStartXTranslationLeft;
		self.startXTranslationRight = self.lastStartXTranslationRight;
		self.dtAverage = self.dtSum/self.cycleRoundMax;
		self.dtSum = dt;
	end;

	--if self.reelStarted then
	if self.attacherVehicle ~= nil then
		if self.currentFruitType ~= nil and self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			self.currentTime = 	self.currentTime + dt;
			for i=1, self.fruitLeft1Count do
				if self.fruitLeft1[i].fruitType == FruitUtil.fruitIndexToDesc[self.currentFruitType].name then
					--local cycleTranslation = self.attacherVehicle.feederSpeedValue * 0.0035/ self.attacherVehicle.threasherActivationTime * self.attacherVehicle.reelTime;
					local cycleTranslation = 100 * 0.00009 * self.dtAverage/ 2 * 1;
					if self.blockLeft then
						--cycleTranslation = 0;
					end;
					
					local x,y,z = getTranslation(self.fruitLeft1[i].rotNode);			
					local newX = x + cycleTranslation;
					
					--adjust visibility				
					if not self.emptyHead then
						if newX >= self.fruitLeft1.endTranslation then
							newX = self.fruitLeft1.startTranslation;
							self.fruitLeft1[i].setVisible = false;
						end
						
						if newX >= self.startXTranslationLeft then
							self.fruitLeft1[i].setVisible = true;
						end;
					else
						if newX >= self.fruitLeft1.endTranslation then
							newX = self.fruitLeft1.startTranslation;
							self.fruitLeft1[i].setVisible = false;
						end
					end;
					-- Visibility done
					
					--Due to changing dt based on varous loads and the way Windows allocated ressourced and other factors 
					--we reset the start position once in a while to make sure that fruit is distributed evenly always
					if self.currentTime > self.resetFruitTime then
						newX = self.fruitLeft1[i].startPositionX
					end;
					
					local newZ = self.fruitLeft1[i].startPositionZ + math.random(-30,30)/1000;
					if self.myRollSpeed ~= nil and self.myRollSpeed == 0 then
						newZ = self.fruitLeft1[i].startPositionZ;
					end;
					
					local xRotation = self.fruitLeft1[i].startRotationX;
					local newY = self.fruitLeft1[i].startPositionY;
					local newXScale = self.fruitLeft1[i].startScaleX;
					local newYScale = self.fruitLeft1[i].startScaleY;
					local newZScale = self.fruitLeft1[i].startScaleZ;
					if newX > self.fruitLeft1.endTranslation - 0.75 and not self.blockLeft then
						xRotation  = -(1.57 + newX * 0.05);
						newY = y + 0.012;
						newZ = (1.2 + newX);
						--newZScale = (newX * 0.8 + 0.2);
					end;
					
					setRotation(self.fruitLeft1[i].rotNode, xRotation,self.fruitLeft1[i].startRotationY,self.fruitLeft1[i].startRotationZ);
					setScale(self.fruitLeft1[i].rotNode, newXScale,newYScale,newZScale);
					
					setVisibility(self.fruitLeft1[i].rotNode, self.fruitLeft1[i].setVisible);
					setTranslation(self.fruitLeft1[i].rotNode, newX, newY, newZ);
				end;
			end;
			for i=1, self.fruitRight1Count do
				if self.fruitRight1[i].fruitType == FruitUtil.fruitIndexToDesc[self.currentFruitType].name then
					local cycleTranslation = 100 * 0.00009 * self.dtAverage/ 2 * 2;
					if self.blockRight then
						--cycleTranslation = 0;
					end;
					
					local x,y,z = getTranslation(self.fruitRight1[i].rotNode);			
					local newX = x + cycleTranslation;
					
					--adjust visibility				
					if not self.emptyHead then
						if newX >= self.fruitRight1.endTranslation then
							newX = self.fruitRight1.startTranslation;
							self.fruitRight1[i].setVisible = false;
						end
						
						if newX >= self.startXTranslationRight then
							self.fruitRight1[i].setVisible = true;
						end;
					else
						if newX >= self.fruitRight1.endTranslation then
							newX = self.fruitRight1.startTranslation;
							self.fruitRight1[i].setVisible = false;
						end
					end;
					-- Visibility done
					
					--Due to changing dt based on varous loads and the way Windows allocated ressourced and other factors 
					--we reset the start position once in a while to make sure that fruit is distributed evenly always
					if self.currentTime > self.resetFruitTime then
						newX = self.fruitRight1[i].startPositionX
					end;
					
					local newZ = self.fruitRight1[i].startPositionZ + math.random(-30,30)/1000;
					if self.myRollSpeed ~= nil and self.myRollSpeed == 0 then
						newZ = self.fruitRight1[i].startPositionZ;
					end;
					
					local xRotation = self.fruitRight1[i].startRotationX;
					local newY = self.fruitRight1[i].startPositionY;
					local newXScale = self.fruitRight1[i].startScaleX;
					local newYScale = self.fruitRight1[i].startScaleY;
					local newZScale = self.fruitRight1[i].startScaleZ;
					if newX > self.fruitRight1.endTranslation - 0.75 and not self.blockRight then
						xRotation  = 1.57 + newX * 0.05;
						newY = y + 0.012;
						newZ = -(1.2 + newX);
						--newZScale = (newX * 0.8 + 0.2);
					end;
					
					setRotation(self.fruitRight1[i].rotNode, xRotation,self.fruitRight1[i].startRotationY,self.fruitRight1[i].startRotationZ);
					setScale(self.fruitRight1[i].rotNode, newXScale,newYScale,newZScale);
					
					setVisibility(self.fruitRight1[i].rotNode, self.fruitRight1[i].setVisible);
					setTranslation(self.fruitRight1[i].rotNode, newX, newY, newZ);
				end;
			end;
			if self.currentTime > self.resetFruitTime then
				self.currentTime = 0;
			end;
		end;
	end;
	
	if self.advancedCutterEnabled and self.attacherVehicle ~= nil and not self.attacherVehicle.isAIThreshing and not self.attacherVehicle.isAutopilotActivated then
		--Calculate the speed factor
		local currentSpeed = 0;
		if self.attacherVehicle ~= nil then
			currentSpeed = math.floor(self.attacherVehicle.lastSpeed * 3600);
			if currentSpeed > 0 then
				self.blockingSpeedFactor = currentSpeed/self.normalSpeed
			else
				self.blockingSpeedFactor = 0;
			end;
		end;
		
		--Now adjust dt according to the speed factor		
		local adjustedDt = 0;
		if self.blockingSpeedFactor > 0 then
			adjustedDt = dt * self.blockingSpeedFactor
		end;
		
		if self.lastArea > 0 then
			self.currentBlockingTimeLeft = 	self.currentBlockingTimeLeft + adjustedDt;
			self.currentBlockingTimeRight = self.currentBlockingTimeRight + adjustedDt;
		end;
		
		if self.currentBlockingTimeLeft > self.headerLeftBlockingTime then
			--Block left header part
			if self.movingDirection > 0 then
				self.headerLeftBlockingTime = math.random(1*self.advancedCutterDifficulty, 300*self.advancedCutterDifficulty)*1000;
				self.currentBlockingTimeLeft = 0;
				self.blockLeft = false;
				self.leftBlockingCycles = 0;
				for k,area in pairs(self.cuttingAreas) do
					local x,y,z = getTranslation(area.start);
					setTranslation(area.start, self.leftTranslationX, y,z);
					local x2,y2,z2 = getTranslation(area.height);
					setTranslation(area.height, self.leftTranslationX, y2,z2);
				end;
			else
				self.blockLeft = true;
				self.leftBlockingCycles = self.leftBlockingCycles + dt;
				
				if self.leftBlockingCycles >= self.stopHarvestingAtTime then
					for k,area in pairs(self.cuttingAreas) do
						local x,y,z = getTranslation(area.start);
						setTranslation(area.start, -1, y,z);
						local x2,y2,z2 = getTranslation(area.height);
						setTranslation(area.height, -1, y2,z2);
					end;
				end;
			end;
		end;
		
		if self.currentBlockingTimeRight > self.headerRightBlockingTime then
			--Block right header part
			if self.movingDirection > 0 then
				self.headerRightBlockingTime = math.random(1*self.advancedCutterDifficulty, 300*self.advancedCutterDifficulty)*1000;
				self.currentBlockingTimeRight = 0;
				self.blockRight = false;
				self.rightBlockingCycles = 0;
				for k,area in pairs(self.cuttingAreas) do
					local x2,y2,z2 = getTranslation(area.width);
					setTranslation(area.width, self.rightTranslationX, y2,z2);
				end;
			else
				self.blockRight = true;
				self.rightBlockingCycles = self.rightBlockingCycles + dt;
				
				if self.rightBlockingCycles >= self.stopHarvestingAtTime then
					for k,area in pairs(self.cuttingAreas) do
						local x2,y2,z2 = getTranslation(area.width);
						setTranslation(area.width, 1, y2,z2);
					end;
				end;
			end;
		end;
	end;
	--if self.showFruits then
		--renderText(0.5, 0.5, 0.02, string.format(self.headerLeftBlockingTime));
		--renderText(0.5, 0.4, 0.02, string.format(self.currentBlockingTimeLeft));
	--end;
	--Evaluation done
end;

function fruitAnimationCornHeader:draw()
end;

function fruitAnimationCornHeader:animateRowCrop(node, startTranslation, endTranslation, dt, i, cropCount, area, blockRow)
	if self.currentFruitType ~= nil and FruitUtil.fruitIndexToDesc[self.currentFruitType] ~= nil and node.fruitType == FruitUtil.fruitIndexToDesc[self.currentFruitType].name then
		local cycleTranslation = 20 * 0.00015 * dt / 2 * 2;
		if blockRow then
			cycleTranslation = 0;
		end;
		
		local x,y,z = getTranslation(node.rotNode);			
		local newZ = z + cycleTranslation;
		
		--Due to changing dt based on varous loads and the way Windows allocated ressourced and other factors 
		--we reset the start position once in a while to make sure that fruit is distributed evenly always
		if i == 1 then
			if self.cycleCount >= 100 then
				if newZ >= endTranslation then
					--We have done one full revolution so reset the chain
					self.resetRows = true;
					self.cycleCount = 0;
				end;
			else
				self.cycleCount = self.cycleCount + 1;
			end;
		end;
		
		if self.resetRows then
			--renderText(0.5, 0.5, 0.02, string.format("resetting"));
			--if area == 0 and newZ <= endTranslation then
			--node.setVisible = false;
			--end;
			newZ = node.startPositionZ;
			--We are done reseting the chain when we reach the last tooth
			if i == cropCount then
				self.resetRows = false;
			end;
		end;
			
		--adjust visibility				
		if not self.emptyHead and area > 0 then
			if newZ >= endTranslation then
				newZ = startTranslation;
				node.setVisible = false;
			else
				node.setVisible = true;
			end
		else
			if newZ >= endTranslation then
				newZ = startTranslation;
				node.setVisible = false;
			end
		end;
		
		-- Visibility done
		
		local newX = node.startPositionX + math.random(-10,10)/1000;
		if (self.myRollSpeed ~= nil and self.myRollSpeed == 0) then
			newX = node.startPositionX;
		end;
		
		local zRotation = math.random(-40,40)/1000;
		if (self.myRollSpeed ~= nil and self.myRollSpeed == 0) then
			zRotation = node.startRotationZ;
		end;
		
		local xRotation = node.startRotationX;
		local newY = node.startPositionY;
		local newXScale = node.startScaleX;
		local newYScale = node.startScaleY;
		local newZScale = node.startScaleZ;
		if newZ > endTranslation - 0.75 and not blockRow then
			xRotation  = newZ * -0.6;
			newY = y + 0.006;
		end;
		
		setRotation(node.rotNode, xRotation,node.startRotationY,zRotation);
		setScale(node.rotNode, newXScale,newYScale,newZScale);
		
		setVisibility(node.rotNode, node.setVisible);
		setTranslation(node.rotNode, newX, newY, newZ);
	end;
end;

