SetDoorLetraRotationEvent = {};
SetDoorLetraRotationEvent_mt = Class(SetDoorLetraRotationEvent, Event);
  
InitEventClass(SetDoorLetraRotationEvent, "SetDoorLetraRotationEvent");
  
function SetDoorLetraRotationEvent:emptyNew()
      local self = Event:new(SetDoorLetraRotationEvent_mt);
      self.className="SetDoorLetraRotationEvent";
      return self;
 end;

function SetDoorLetraRotationEvent:new(object, rotationMax16)
      local self = SetDoorLetraRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax16 = rotationMax16;
      return self;
end;
 
function SetDoorLetraRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax16 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorLetraRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax16);
end;
 
function SetDoorLetraRotationEvent:run(connection)
      self.object:setRotationMax16(self.rotationMax16, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorLetraRotationEvent:new(self.object, self.rotationMax16), nil, connection, self.object);
      end;
end;