SetDoorAjtoRotationEvent = {};
SetDoorAjtoRotationEvent_mt = Class(SetDoorAjtoRotationEvent, Event);
  
InitEventClass(SetDoorAjtoRotationEvent, "SetDoorAjtoRotationEvent");
  
function SetDoorAjtoRotationEvent:emptyNew()
      local self = Event:new(SetDoorAjtoRotationEvent_mt);
      self.className="SetDoorAjtoRotationEvent";
      return self;
 end;

function SetDoorAjtoRotationEvent:new(object, rotationMax15)
      local self = SetDoorAjtoRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax15 = rotationMax15;
      return self;
end;
 
function SetDoorAjtoRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax15 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorAjtoRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax15);
end;
 
function SetDoorAjtoRotationEvent:run(connection)
      self.object:setRotationMax15(self.rotationMax15, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorAjtoRotationEvent:new(self.object, self.rotationMax15), nil, connection, self.object);
      end;
end;