--
-- Henly20 (Ls_uk Modteam)
-- 23.08.2010
--
-- > www.LS-UK.info

Animated = {};

function Animated.prerequisitesPresent(specializations)

    return true;
end;

function Animated:load(xmlFile)
     self.setRotationMax15 = SpecializationUtil.callSpecializationsFunction("setRotationMax15");
     self.setRotationMax16 = SpecializationUtil.callSpecializationsFunction("setRotationMax16");
     self.setRotationMax14 = SpecializationUtil.callSpecializationsFunction("setRotationMax14");
	 
	
	local rotationPartNode15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart15#index"));
    if rotationPartNode15 ~= nil then
        self.rotationPart15 = {};
        self.rotationPart15.node = rotationPartNode15;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart15#minRot"));
        self.rotationPart15.minRot = {};
        self.rotationPart15.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart15.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart15.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart15#maxRot"));
        self.rotationPart15.maxRot = {};
        self.rotationPart15.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart15.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart15.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart15.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart15#rotTime"), 2)*1000;
        self.rotationPart15.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart15#touchRotLimit"), 10));
    end;
	local rotationPartNode16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart16#index"));
    if rotationPartNode16 ~= nil then
        self.rotationPart16 = {};
        self.rotationPart16.node = rotationPartNode16;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart16#minRot"));
        self.rotationPart16.minRot = {};
        self.rotationPart16.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart16.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart16.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart16#maxRot"));
        self.rotationPart16.maxRot = {};
        self.rotationPart16.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart16.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart16.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart16.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart16#rotTime"), 2)*1000;
        self.rotationPart16.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart16#touchRotLimit"), 10));
    end;
	local rotationPartNode14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart14#index"));
    if rotationPartNode14 ~= nil then
        self.rotationPart14 = {};
        self.rotationPart14.node = rotationPartNode14;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart14#minRot"));
        self.rotationPart14.minRot = {};
        self.rotationPart14.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart14.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart14.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart14#maxRot"));
        self.rotationPart14.maxRot = {};
        self.rotationPart14.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart14.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart14.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart14.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart14#rotTime"), 2)*1000;
        self.rotationPart14.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart14#touchRotLimit"), 10));
    end;

		self.rotationMax15 = false;
		self.rotationMax16 = false;
		self.rotationMax14 = false;
end;

function Animated:readStream(streamId, connection)
     self.rotateMax = streamReadBool(streamId);
     if self.rotationPart15 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart15.node, x, y, z);
      end;
     if self.rotationPart16 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart16.node, x, y, z);
      end;
     if self.rotationPart14 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart14.node, x, y, z);
      end;
end;
  
function Animated:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateMax);
		if self.rotationPart15 ~= nil then
          local x, y, z = getRotation(self.rotationPart15.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart16 ~= nil then
          local x, y, z = getRotation(self.rotationPart16.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart14 ~= nil then
          local x, y, z = getRotation(self.rotationPart14.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function Animated:delete()

end;

function Animated:keyEvent(unicode, sym, modifier, isDown)


end;

function Animated:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.DOORAJTO) then
				self:setRotationMax15(not self.rotationMax15);
          end;
          if InputBinding.hasEvent(InputBinding.DOORLETRA) then
				self:setRotationMax16(not self.rotationMax16);
          end;
          if InputBinding.hasEvent(InputBinding.TARTALY) then
				self:setRotationMax14(not self.rotationMax14);
          end;
		  
     end;
end;

function Animated:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationPart15 ~= nil then
				local x, y, z = getRotation(self.rotationPart15.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart15.maxRot, self.rotationPart15.minRot, 3, self.rotationPart15.rotTime, dt, not self.rotationMax15);
				setRotation(self.rotationPart15.node, unpack(newRot));
			end;
			if self.rotationPart16 ~= nil then
				local x, y, z = getRotation(self.rotationPart16.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart16.maxRot, self.rotationPart16.minRot, 3, self.rotationPart16.rotTime, dt, not self.rotationMax16);
				setRotation(self.rotationPart16.node, unpack(newRot));
			end;
			if self.rotationPart14 ~= nil then
				local x, y, z = getRotation(self.rotationPart14.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart14.maxRot, self.rotationPart14.minRot, 3, self.rotationPart14.rotTime, dt, not self.rotationMax14);
				setRotation(self.rotationPart14.node, unpack(newRot));
			end;
		
	end;		
end;

function Animated:draw()

  
end;


function Animated:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Animated:setRotationMax15(rotationMax15, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetDoorAjtoRotationEvent:new(self, rotationMax15), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorAjtoRotationEvent:new(self, rotationMax15));
          end;
      end;
      self.rotationMax15 = rotationMax15;
end;

function Animated:setRotationMax16(rotationMax16, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorLetraRotationEvent:new(self, rotationMax16), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorLetraRotationEvent:new(self, rotationMax16));
          end;
      end;
      self.rotationMax16 = rotationMax16;
end;

function Animated:setRotationMax14(rotationMax14, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetTartalyRotationEvent:new(self, rotationMax14), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetTartalyRotationEvent:new(self, rotationMax14));
          end;
      end;
      self.rotationMax14 = rotationMax14;
end;
