discotc = {};

function discotc.prerequisitesPresent(specializations)   
return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function discotc:load(xmlFile)
            print("'lua loaded '" );
self.particleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystems.particleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
self.particleSystems1 = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystems1.particleSystems1(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystems1, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;
	
	local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
    if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
    end;
	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;
	local rotationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
    end;
	local rotationPartNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
    if rotationPartNode6 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationPartNode6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
        self.rotationPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#touchRotLimit"), 10));
    end;
	local rotationPartNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart7#index"));
    if rotationPartNode7 ~= nil then
        self.rotationPart7 = {};
        self.rotationPart7.node = rotationPartNode7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#minRot"));
        self.rotationPart7.minRot = {};
        self.rotationPart7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#maxRot"));
        self.rotationPart7.maxRot = {};
        self.rotationPart7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#rotTime"), 2)*1000;
        self.rotationPart7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#touchRotLimit"), 10));
    end;
	local rotationPartNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationPartNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationPartNode8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
        self.rotationPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#touchRotLimit"), 10));
    end;
	local rotationPartNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart9#index"));
    if rotationPartNode9 ~= nil then
        self.rotationPart9 = {};
        self.rotationPart9.node = rotationPartNode9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart9#minRot"));
        self.rotationPart9.minRot = {};
        self.rotationPart9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart9#maxRot"));
        self.rotationPart9.maxRot = {};
        self.rotationPart9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart9#rotTime"), 2)*1000;
        self.rotationPart9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart9#touchRotLimit"), 10));
    end;
		self.drumNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index"));
	self.drumNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index2"));
	self.drumNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index3"));
	self.drumNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index4"));
	self.drumNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index5"));
	self.drumNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index6"));
	self.drumNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index7"));
	self.drumNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index8"));
	
  self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
		    local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
 
	
 
	local translationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);
	 self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;
   local translationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;
	local translationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart4#index"));
    if translationPartNode4 ~= nil then
        self.translationPart4 = {};
        self.translationPart4.node = translationPartNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart4#minTrans"));
        self.translationPart4.minTrans = {};
        self.translationPart4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart4#maxTrans"));
        self.translationPart4.maxTrans = {};
        self.translationPart4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart4#transTime"), 2)*1000;
        self.translationPart4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart4#touchTransLimit"), 10);
    end;
	local translationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart5#index"));
    if translationPartNode5 ~= nil then
        self.translationPart5 = {};
        self.translationPart5.node = translationPartNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart5#minTrans"));
        self.translationPart5.minTrans = {};
        self.translationPart5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart5#maxTrans"));
        self.translationPart5.maxTrans = {};
        self.translationPart5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart5#transTime"), 2)*1000;
        self.translationPart5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart5#touchTransLimit"), 10);
    end;
	local translationPartNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart6#index"));
    if translationPartNode6 ~= nil then
        self.translationPart6 = {};
        self.translationPart6.node = translationPartNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart6#minTrans"));
        self.translationPart6.minTrans = {};
        self.translationPart6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart6#maxTrans"));
        self.translationPart6.maxTrans = {};
        self.translationPart6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart6.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart6#transTime"), 2)*1000;
        self.translationPart6.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart6#touchTransLimit"), 10);
    end;
 	local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;
	
	   local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas ~= 1 or numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;

    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;
	self.controlpath = Utils.getFilename("disco3050trc.png", self.baseDirectory);
   
    self.huddisco3050tcPoxX = 0.01;
    self.huddisco3050tcPoxY = 1-0.204;
    self.huddisco3050tcWidth = 0.260;
    self.huddisco3050tcHeight = 0.260;
    self.huddisco3050tcPoxX = 0.65;
    self.huddisco3050tcPoxY = 0.60
    self.huddisco3050tcOverlay = Overlay:new("huddisco3050tc", self.controlpath, self.huddisco3050tcPoxX, self.huddisco3050tcPoxY, self.huddisco3050tcWidth, self.huddisco3050tcHeight);
     self.bcActive = false;
 self.lastSpeed = 0;
	
end;

function discotc:delete()
		Utils.setEmittingState(self.particleSystems1,false)

  Utils.setEmittingState(self.particleSystems, false)
if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
end;


function discotc:mouseEvent(posX, posY, isDown, isUp, button)
end;

function discotc:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_j   then
		
		self.rotationMax3 = not self.rotationMax3;
		self.rotationMax4 = not self.rotationMax4;
		self.rotationMax5 = not self.rotationMax5;
			self.rotationMax6 = not self.rotationMax6;
		self.rotationMax7 = not self.rotationMax7;
			self.translationMax2 = not self.translationMax2 ;
		self.translationMax5 = not self.translationMax5 ;
		
	end;

if isDown and sym == Input.KEY_v   then
		self.rotParts = not self.rotParts;	
		self.translationMax3 = not self.translationMax3;
		self.translationMax4 = not self.translationMax4 ;
		if self.go   then
		self.gosuperfila = not self.gosuperfila;
		self.rotationMax8 = not self.rotationMax8;
		self.rotationMax9 = not self.rotationMax9;
		self.translationMax6 = not self.translationMax6 ;
		end
	end;
  
  if isDown and sym == Input.KEY_b   then
		self.isTurnedOn = not self.isTurnedOn;
	end;
	if isDown and sym == Input.KEY_m  then
		self.go = not self.go;
	
	end;
	  if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;
end;


function discotc:update(dt)
if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {Utils.degToRad(2),0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;

	
	if self.attacherVehicle then
	
		
	if self.isTurnedOn 		then
	if self.drumNode1 ~= nil then
				rotate(self.drumNode1, self.drumRotationScale * 5 * 1, 0, 0);
			end;	
		if self.drumNode2 ~= nil then
				rotate(self.drumNode2, self.drumRotationScale * 35 * 0, 15, 0);
			end;	
		if self.drumNode3 ~= nil then
				rotate(self.drumNode3, self.drumRotationScale * 35 * 0, 15, 0);
			end;
	if self.drumNode4 ~= nil then
				rotate(self.drumNode4, self.drumRotationScale * 35 * 0, 15, 0);
			end;	
	if self.drumNode5 ~= nil then
				rotate(self.drumNode5, self.drumRotationScale * 35 * 0, 15, 0);
			end;	
	if self.drumNode6 ~= nil then
				rotate(self.drumNode6, self.drumRotationScale * 35 * 0, 15, 0);
			end;
	if self.drumNode7 ~= nil then
				rotate(self.drumNode7, self.drumRotationScale * 35 * 0, 15, 0);
			end;
	if self.drumNode8 ~= nil then
				rotate(self.drumNode8, self.drumRotationScale * 35 * 0, 15, 0);
			end;				
		if not self.mowerSoundRunning then
                print("start");
                playSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = true;
			end;	
	else
	if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
			end;
	end;	
	
	if self.isTurnedOn  and  not self.rotParts then
	
			
		
			if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
				Utils.updateMeadowArea( x, z, x1, z1, x2, z2, 0);
			end;
		
    end;
	if self.isTurnedOn  and  not self.rotParts then
        local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    local foldAnimTime = self.foldAnimTime;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[1];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            if not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_GRASS;
                            end;
				
				if not self.rotParts then

                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;

                            if area > 0 then
                                fruitTypeFix = true;
                            end;

                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[1];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
										Utils.setEmittingState(self.particleSystems, true)
                                    end;
								end;
							end;
						end;
					end;
                end;
			end;
		if self.isTurnedOn  and  not self.rotParts  and self.go then
        local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    local foldAnimTime = self.foldAnimTime;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[2];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            if not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_GRASS;
                            end;

				if not self.rotParts then

                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;

                            if area > 0 then
                                fruitTypeFix = true;
                            end;

                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[2];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
										Utils.setEmittingState(self.particleSystems1, true)
                                    end;
								end;
							end;
						end;
					end;
                end;
			end;
      end;   
 
		if self.rotParts or not self.isTurnedOn or self.go then
		Utils.setEmittingState(self.particleSystems, false)
	end; 
	if self.rotParts or not self.isTurnedOn or not self.go then
			Utils.setEmittingState(self.particleSystems1,false)
end;
	
				
	
		if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
				end;
		

	if self.rotationPart3 ~= nil then
        local x, y, z = getRotation(self.rotationPart3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3);
        setRotation(self.rotationPart3.node, unpack(newRot));
    end;
	if self.rotationPart4 ~= nil then
        local x, y, z = getRotation(self.rotationPart4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4);
        setRotation(self.rotationPart4.node, unpack(newRot));
    end;
	if self.rotationPart5 ~= nil then
        local x, y, z = getRotation(self.rotationPart5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax5);
        setRotation(self.rotationPart5.node, unpack(newRot));
    end;
	if self.rotationPart6 ~= nil then
        local x, y, z = getRotation(self.rotationPart6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.rotationMax6);
        setRotation(self.rotationPart6.node, unpack(newRot));
    end;
	if self.rotationPart7 ~= nil then
        local x, y, z = getRotation(self.rotationPart7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart7.maxRot, self.rotationPart7.minRot, 3, self.rotationPart7.rotTime, dt, not self.rotationMax7);
        setRotation(self.rotationPart7.node, unpack(newRot));
    end;
	if self.rotationPart8 ~= nil then
        local x, y, z = getRotation(self.rotationPart8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.rotationMax8);
        setRotation(self.rotationPart8.node, unpack(newRot));
    end;
	if self.rotationPart9 ~= nil then
        local x, y, z = getRotation(self.rotationPart9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart9.maxRot, self.rotationPart9.minRot, 3, self.rotationPart9.rotTime, dt, not self.rotationMax9);
        setRotation(self.rotationPart9.node, unpack(newRot));
    end;
				if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
		end;	
				if self.translationMax4 ~= nil then
		local x, y, z = getTranslation(self.translationPart4.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart4.maxTrans, self.translationPart4.minTrans, 3, self.translationPart4.transTime, dt, not self.translationMax4);
        setTranslation(self.translationPart4.node, unpack(newTrans));
		end;					
			if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
		end;				
		
		if self.translationMax5 ~= nil then
		local x, y, z = getTranslation(self.translationPart5.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart5.maxTrans, self.translationPart5.minTrans, 3, self.translationPart5.transTime, dt, not self.translationMax5);
        setTranslation(self.translationPart5.node, unpack(newTrans));
		end;
		if self.translationMax6 ~= nil then
		local x, y, z = getTranslation(self.translationPart6.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart6.maxTrans, self.translationPart6.minTrans, 3, self.translationPart6.transTime, dt, not self.translationMax6);
        setTranslation(self.translationPart6.node, unpack(newTrans));
		end;
	if self.rotationPart1 ~= nil then
        local x, y, z = getRotation(self.rotationPart1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
        setRotation(self.rotationPart1.node, unpack(newRot));
    end;		
	-- if self.attacherVehicle then
	local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);	
	-- end;			
end;
function discotc:draw()

	 if self.huddisco3050tcOverlay ~= nil then
  if self.bcActive then
    self.huddisco3050tcOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("play 0: menu Off");
		else
			g_currentMission:addExtraPrintText("play 0: menu On");
		end;

end;
function discotc:onAttach()	
	self.rotationMax1 = true;
	self.fixAttacher = true; 
	
	self.rotParts = true;
	self.translationMax3= true;
	self.translationMax4= true;
	self.rotationMax8 = true;
	self.translationMax6= true;
	self.rotationMax9 = true;
end;

function discotc:onDetach()
  stopSample(self.mowerSound);
   self.mowerSoundEnabled = false;
  self.isTurnedOn = false;
	self.rotationMax1 = false;
	self.rotParts = false;
	self.translationMax3= false;
	self.translationMax4= false;
	self.rotationMax8 = true;
	self.translationMax6= false;
	self.rotationMax9 = true;
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
end;





