--
-- Rundumleuchte
-- Specialization for beacon-lights
-- Spezialisierung fr Rundumleuchten
-- @author  Sven777b
-- 
-- Modifikationen erst nach Rcksprache
--

RUL = {};

function RUL.prerequisitesPresent(specializations)
    return true;
end;

function RUL:load(xmlFile)
		print("specialization rundumleuchten by Sven777b");
		local i = 0;
		self.rundumleuchten = {};
    self.rundumleuchtenAn = false;
		while true do
			local rul = {};
			local objname = string.format("vehicle.rundumleuchten.rundumleuchte(%d)",i);
      local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      if rotnode == nil then 
      	break;
      end;
      rul = {};
      rul.rotNode = Utils.indexToObject(self.components, rotnode);
      rul.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(rul.rotNode == nil or rul.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
      else
	      rul.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      rul.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (rul.source == nil) then
	      	rul.emit = false;
	      else
      		rul.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul.emit then
      			setVisibility(rul.source, false);
      		end;
      	end;
      	table.insert(self.rundumleuchten, rul);
      end;
      i=i+1;
    end;
    self.rundumleuchtenAnz = table.getn(self.rundumleuchten);
end;

function RUL:delete()
end;

function RUL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RUL:keyEvent(unicode, sym, modifier, isDown)
end;

function RUL:update(dt)
	if self.rundumleuchtenAnz > 0 and self:getIsActive() then
    if InputBinding.hasEvent(InputBinding.ClaasCougar1400_rul) then
    	self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    if self.rundumleuchtenAn then
      for i=1, self.rundumleuchtenAnz do
        rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
      end;
    end;
  end;
end;

function RUL:draw()

end;

