--
-- ClaasCougar1400
-- Specialization for ClaasCougar1400
--
-- @author Felix "Outlaw" S.
-- @date  21/10/09 v1.0
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

ClaasCougar1400 = {};

function ClaasCougar1400.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ClaasCougar1400:load(xmlFile)

	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.changeSteer = SpecializationUtil.callSpecializationsFunction("changeSteer");
	self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");
	
	self.particleSystemfront = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystemfront.particleSystemfront(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemfront, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.particleSystemfront,false)
		self.particleSystemfrontdisableTime = 0;
		i = i +1;		
    end;
	
	self.particleSystemfrontrechts = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystemfrontrechts.particleSystemfrontrechts(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemfrontrechts, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.particleSystemfrontrechts,false)
		self.particleSystemfrontrechtsdisableTime = 0;
		i = i +1;		
    end;
	
	self.particleSystemfrontlinks = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystemfrontlinks.particleSystemfrontlinks(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemfrontlinks, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.particleSystemfrontlinks,false)
		self.particleSystemfrontlinksdisableTime = 0;
		i = i +1;		
    end;
	
	self.particleSystemrechts = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystemrechts.particleSystemrechts(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemrechts, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.particleSystemrechts,false)
		self.particleSystemrechtsdisableTime = 0;
		i = i +1;		
    end;
	
	self.particleSystemlinks = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.particleSystemlinks.particleSystemlinks(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemlinks, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.particleSystemlinks,false)
		self.particleSystemlinksdisableTime = 0;
		i = i +1;		
    end;
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
		
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].groundthreshold = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#groundthreshold"), 0.2);
        self.cuttingAreas[i].groundindex = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#groundindex"));
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.start#file");
    if workSound ~= nil and workSound ~= "" then
       workSound = Utils.getFilename(workSound, self.baseDirectory);
       self.workSound = createSample("start");
       self.workSoundEnabled = false;
       loadSample(self.workSound, workSound, false);
       self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.start#pitchOffset"), 1);
       self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.start#volume"), 1);
    end;
	
	local loopSound = getXMLString(xmlFile, "vehicle.loopSound#file");
    if loopSound ~= nil and loopSound ~= "" then
       loopSound = Utils.getFilename(loopSound, self.baseDirectory);
       self.loopSound = createSample("loopSound");
       self.loopSoundEnabled = false;
       loadSample(self.loopSound, loopSound, false);
       self.loopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loopSound#pitchOffset"), 1);
       self.loopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loopSound#volume"), 1);
    end;
	
	local StopSound = getXMLString(xmlFile, "vehicle.StopSound#file");
    if StopSound ~= nil and StopSound ~= "" then
       StopSound = Utils.getFilename(StopSound, self.baseDirectory);
       self.StopSound = createSample("StopSound");
       self.StopSoundEnabled = true;
       loadSample(self.StopSound, StopSound, false);
       self.StopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.StopSound#pitchOffset"), 1);
       self.StopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.StopSound#volume"), 1);
    end;
	
	self.firstDo = {};
	self.arm = {};
	self.runs = 30;

    self.accDirection = -1;
	self.speedLevel = 3;
	self.changeWheel = 0; 
	self.trsp = true; 
	self.Speed.frontlinks = 10.0; 
	self.Speed.frontrechts = 10.0; 
	self.Speed.armlinks = 10.0; 
	self.Speed.armrechts = 10.0;
	self.Speed.trsp = 10.0; 
	self.Speed.front = 10.0; 
	self.Speed.frontfront = 10.0; 
	self.accDirection = 1;
	self.Go.front = true; 
	self.Done.front = true; 
	self.Go.frontlinks = true;
	self.Done.frontlinks = true; 
	self.Go.frontrechts = true;
	self.Done.frontrechts = true; 
	self.Go.frontfront = true;
	self.Done.frontfront = true; 
	self.Go.trsp = true; 
	self.Done.trsp = true; 
	self.Go.armlinks = true;
	self.Done.armlinks = true; 
	self.Go.armrechts = true;
	self.Done.armrechts = true; 
end;

function ClaasCougar1400:update(dt)		
	self.runs = 30;
	if self:getIsActive() then

		if InputBinding.hasEvent(InputBinding.ClaasCougar1400_trsp) and self:getIsActiveForInput() and not self.turnOn then	
			self.Speed.frontlinks = 1.0; 
			self.Speed.frontrechts = 1.0;
			self.Speed.armlinks = 0.5; 
			self.Speed.armrechts = 0.5;
			self.Speed.trsp = 0.5; 	
			self.Speed.front = 0.5; 
			self.Speed.frontfront = 0.5; 
			self.trsp = not self.trsp; 
			if not self.trsp then
				self.accDirection = -1;
				self.Go.front = false; 
				self.Done.front = true; 
				self.Go.frontlinks = 1500.0;
				self.Done.frontlinks = true; 
				self.Go.frontrechts = 1500.0;
				self.Done.frontrechts = true; 
				self.Go.frontfront = true;
				self.Done.frontfront = true; 
				self.Go.trsp = false; 
				self.Done.trsp = true; 
				self.Go.armlinks = 1500.0;
				self.Done.armlinks = true; 
				self.Go.armrechts = 1500.0;
				self.Done.armrechts = true; 	
			elseif self.trsp then
				self.accDirection = 1;
				self.Go.front = true; 
				self.Done.front = true; 
				self.Go.frontlinks = true;
				self.Done.frontlinks = true; 
				self.Go.frontrechts = true;
				self.Done.frontrechts = true; 
				self.Go.frontfront = true;
				self.Done.frontfront = true; 
				self.Go.trsp = true; 
				self.Done.trsp = true; 
				self.Go.armlinks = true;
				self.Done.armlinks = true; 
				self.Go.armrechts = true;
				self.Done.armrechts = true; 
			end; 
		end; 	
					
		if InputBinding.hasEvent(InputBinding.ClaasCougar1400_changeWheel) and self:getIsActiveForInput() then
			self.changeWheel = self.changeWheel +1 ; 
		end; 
		
		if not self.trsp and not self.Done.trsp then
			if InputBinding.hasEvent(InputBinding.ClaasCougar1400_on) and self:getIsActiveForInput() then
				self.turnOn = not self.turnOn; 
			end;
			
			if self.runMower then
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_frontfront) and self:getIsActiveForInput() then
					self.Speed.frontfront = 3.0; 
					self.Go.frontfront = not self.Go.frontfront;
					self.Done.frontfront = true; 
				end; 
				
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_frontrechts) and self:getIsActiveForInput() then
					self.Speed.frontrechts = 1.0; 
					if not self.Go.frontrechts then
						self.Go.frontrechts = 1500.0;
						self.Done.frontrechts = true; 
					else
						self.Go.frontrechts = false;
						self.Done.frontrechts = true; 
					end;
				end; 
				
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_armlinks) and self:getIsActiveForInput() then
					self.Speed.armlinks = 1.0; 
					if not self.Go.armlinks then
						self.Go.armlinks = 1500.0;
						self.Done.armlinks = true; 
					else
						self.Go.armlinks = false;
						self.Done.armlinks = true; 
					end;
				end; 
				
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_armrechts) and self:getIsActiveForInput() then
					self.Speed.armrechts = 1.0; 
					if not self.Go.armrechts then
						self.Go.armrechts = 1500.0;
						self.Done.armrechts = true; 
					else
						self.Go.armrechts = false;
						self.Done.armrechts = true; 
					end;
				end; 
				
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_frontlinks) and self:getIsActiveForInput() then
					self.Speed.frontlinks = 1.0; 
					if not self.Go.frontlinks then
						self.Go.frontlinks = 1500.0;
						self.Done.frontlinks = true; 
					else
						self.Go.frontlinks = false;
						self.Done.frontlinks = true; 
					end;
				end; 
				
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_lower) and self:getIsActiveForInput() then
					self.Speed.armlinks = 1.0; 
					self.Speed.armrechts = 1.0;
					self.Speed.frontrechts = 1.0; 
					self.Speed.frontlinks = 1.0; 
					self.Speed.frontfront = 3.0; 
					self.Go.armrechts = 1500.0;
					self.Done.armrechts = true; 
					self.Go.armlinks = 1500.0;
					self.Done.armlinks = true; 
					self.Go.frontlinks = 1500.0;
					self.Done.frontlinks = true; 
					self.Go.frontrechts = 1500.0;
					self.Done.frontrechts = true; 
					self.Go.frontfront = true;
					self.Done.frontfront = true; 	
				end; 
				if InputBinding.hasEvent(InputBinding.ClaasCougar1400_raise) and self:getIsActiveForInput() then
					self.Speed.frontrechts = 1.0; 
					self.Speed.frontlinks = 1.0; 
					self.Speed.frontfront = 3.0; 
					self.Speed.armlinks = 1.0; 
					self.Speed.armrechts = 1.0;
					self.Go.frontlinks = false;
					self.Done.frontlinks = true; 
					self.Go.frontrechts = false;
					self.Done.frontrechts = true; 
					self.Go.frontfront = false;
					self.Done.frontfront = true; 
					self.Go.armlinks = false;
					self.Done.armlinks = true; 
					self.Go.armrechts = false;
					self.Done.armrechts = true; 
				end;
			end; 
		end; 
				
				
		if self.time > self.particleSystemfrontdisableTime then
           Utils.setEmittingState(self.particleSystemfront, false);
        end;	
		if self.time > self.particleSystemfrontlinksdisableTime then
           Utils.setEmittingState(self.particleSystemfrontlinks, false);
        end;
		if self.time > self.particleSystemfrontrechtsdisableTime then
           Utils.setEmittingState(self.particleSystemfrontrechts, false);
        end;
		if self.time > self.particleSystemlinksdisableTime then
			Utils.setEmittingState(self.particleSystemlinks, false);
        end;
		if self.time > self.particleSystemrechtsdisableTime then
           Utils.setEmittingState(self.particleSystemrechts, false);
        end;		
		
		if self.turnOn and not self.trsp and not self.Done.trsp then
			self.StopSoundEnabled = false;	
			if not self.workSoundEnabled then
			    playSample(self.workSound, 1, self.workSoundVolume, 0);
				setSamplePitch(self.workSound, self.workSoundPitchOffset);
				self.workSoundEnabled = true;
				local SoundOffset = getSampleDuration(self.workSound); 
				self.playSoundTime = self.time+SoundOffset;			
			end;			
			if self.playSoundTime <= self.time and not self.loopSoundEnabled then
				playSample(self.loopSound, 0, self.loopSoundVolume, 0);
				setSamplePitch(self.loopSound, self.loopSoundPitchOffset);
				self.loopSoundEnabled = true;
				self.runMower = true; 
				stopSample(self.workSound);		
			end;					
			if not self.backupRmp then
				self.backupRmp = self.motor.minRpm;
			end; 			
			if self.motor.minRpm >= -400 then
				self.motor.minRpm = self.motor.minRpm - 10; 
			end; 	
		elseif not self.turnOn then
			if not self.trsp and not self.Done.trsp then
				self.Speed.armlinks = 1.0; 
				self.Speed.armrechts = 1.0;
				self.Speed.frontrechts = 1.0; 
				self.Speed.frontlinks = 1.0; 
				self.Speed.frontfront = 3.0; 
				self.Go.armrechts = 1500.0;
				self.Done.armrechts = true; 
				self.Go.armlinks = 1500.0;
				self.Done.armlinks = true; 
				self.Go.frontlinks = 1500.0;
				self.Done.frontlinks = true; 
				self.Go.frontrechts = 1500.0;
				self.Done.frontrechts = true; 
				self.Go.frontfront = true;
				self.Done.frontfront = true; 
			end; 
			self.workSoundEnabled = false;
			self.runMower = false; 
			self:lowerRmp(); 
			if self.loopSoundEnabled then
				stopSample(self.loopSound);
				self.loopSoundEnabled = false;
			end;
			if not self.StopSoundEnabled then
			    playSample(self.StopSound, 1, self.StopSoundVolume, 0);
				setSamplePitch(self.StopSound, self.StopSoundPitchOffset);
				self.StopSoundEnabled = true;
			end;

		end;
	
		if self.changeWheel == 0  then
			self:changeSteer(34, -34, 34, -34, 30, -30, 30, -30)
		elseif self.changeWheel == 1 then
			self:changeSteer(34, -34, 34, -34, 0, 0, 0, 0)
		elseif self.changeWheel == 2 then
			self:changeSteer(0, 0, 0, 0, 30, -30, 30, -30)
		elseif self.changeWheel == 3 then
			self.changeWheel = 0; 
		end; 
			
		if self.isMotorStarted and self.isEntered then	
			if self.motor.speedLevel ~= 0 then
				self.speedLevel = self.motor.speedLevel;
			end;
		end;  	
		
		local acceleration = 0;
		if g_currentMission.allowSteerableMoving and not self.playMotorSound then
			acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			if InputBinding.isAxisZero(acceleration) then
				acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			end;
			if math.abs(acceleration) > 0.8 then
				self.motor:setSpeedLevel(0, true)
			end;
			if self.motor.speedLevel ~= 0 then
				acceleration = 1.0;
			end;
		end;
			
		if self.steeringEnabled then		
			if self.firstTimeRun then
				WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, (acceleration * self.accDirection), false, self.requiredDriveMode)
			end;	
		end;	

		if not self.trsp and not self.Done.trsp and self.runMower then 
			local area = 0;
			-- fahrgassen
			for k, cuttingArea in pairs(self.cuttingAreas) do
				local x,y,z = getWorldTranslation(cuttingArea.groundindex);
	            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				if (k == 1 or k == 2 or k == 3 or k == 4) and cuttingArea.groundindex ~= nil and terrainHeight+cuttingArea.groundthreshold >= y then
					local xw,yw,zw = getWorldTranslation(cuttingArea.start);
					local x1w,y1w,z1w = getWorldTranslation(cuttingArea.width);
					local x2w,y2w,z2w = getWorldTranslation(cuttingArea.height);
					area = Utils.updateMeadowArea(xw, zw, x1w, z1w, x2w, z2w);
					Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, xw, zw, x1w, z1w, x2w, z2w, 0);
                    local pixelToQm = 2048 / 8192 * 2048 / 8192; -- 8192px are mapped to 2048m
                    local qm = area*pixelToQm;
                    local ha = qm/10000;			
				end;		
			end; 
						
			local area = 0;
			-- normal mhen
			for k, cuttingArea in pairs(self.cuttingAreas) do
			    local x,y,z = getWorldTranslation(cuttingArea.groundindex);
	            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
					
				if k ~= 1 and k ~= 2 and k ~= 3 and k ~= 4  and cuttingArea.groundindex ~= nil and terrainHeight+cuttingArea.groundthreshold >= y then
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
                    local pixelToQm = 2048 / 8192 * 2048 / 8192; -- 8192px are mapped to 2048m
                    local qm = area*pixelToQm;
                    local ha = qm/10000;						
					if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
						if area > 0 then
							if k == 5 then
								self.particleSystemfrontdisableTime = self.time + 40;
								Utils.setEmittingState(self.particleSystemfront, true)
							elseif k == 7 then
								self.particleSystemfrontrechtsdisableTime = self.time + 40;
								Utils.setEmittingState(self.particleSystemfrontrechts, true)
							elseif k == 8 then
								self.particleSystemfrontlinksdisableTime = self.time + 40;
								Utils.setEmittingState(self.particleSystemfrontlinks, true)	
							elseif k == 6 then
								self.particleSystemlinksdisableTime = self.time + 40;
								Utils.setEmittingState(self.particleSystemlinks, true)	
							elseif k == 9 then
								self.particleSystemrechtsdisableTime = self.time + 40;
								Utils.setEmittingState(self.particleSystemrechts, true)		
							end; 
						end; 
					end;
					if self.movingDirection then
						if area > 0 then
							local old, total = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2);							
							local value = 1+math.floor(old / total + 0.7);
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, value, true);						
						end;
					end;							
				end;	
			end; 
		end;
	end; 	
			
	self:setJointRotLimit(self.componentJoints[1],9, 0, 1000, not self.Go.armrechts, 2,dt);
	self:setJointRotLimit(self.componentJoints[2],9, 0, 1000, not self.Go.armrechts, 2,dt);
	self:setJointRotLimit(self.componentJoints[3],9, 0, 1000, not self.Go.armlinks, 2,dt);
	self:setJointRotLimit(self.componentJoints[4],9, 0, 1000, not self.Go.armlinks, 2,dt);
	self:setJointRotLimit(self.componentJoints[5],9, 0, 1000, not self.Go.frontfront, 0,dt);
	self:setJointRotLimit(self.componentJoints[6],9, 0, 1000, not self.Go.frontlinks, 2,dt);
	self:setJointRotLimit(self.componentJoints[7],9, 0, 1000, not self.Go.frontlinks, 2,dt);
	self:setJointRotLimit(self.componentJoints[8],9, 0, 1000, not self.Go.frontrechts, 2,dt);
	self:setJointRotLimit(self.componentJoints[9],9, 0, 1000, not self.Go.frontrechts, 0,dt);
	self:setJointRotLimit(self.componentJoints[10],9, 0, 1000, not self.Go.frontfront, 0,dt);
	self:setJointRotLimit(self.componentJoints[11],9, 0, 1000, true, 2,dt);
	
				
	local joint = self.componentJoints[1];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[2];		
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[3];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[4];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);		
	local joint = self.componentJoints[5];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[6];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[7];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[8];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[9];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[10];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[11];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	
	if self.Go.frontfront ~= nil and self.Done.frontfront ~= false then
		self:anim("frontfront", false); 
	end; 
	
	if self.Go.frontlinks ~= nil and self.Done.frontlinks ~= false then
		self:anim("frontlinks", false); 
	end; 
	
	if self.Go.frontrechts ~= nil and self.Done.frontrechts ~= false then
		self:anim("frontrechts", false); 
	end;
	
	if self.Go.front ~= nil and self.Done.front ~= false then
		self:anim("front", false); 
	end;
	
	self:anim("work", false); 
	
	if self.Go.armlinks ~= nil and self.Done.armlinks ~= false then
		self:anim("armlinks", false); 
	end;
	
	if self.Go.armrechts ~= nil and self.Done.armrechts ~= false then
		self:anim("armrechts", false); 
	end;

	if self.Go.trsp ~= nil and self.Done.trsp ~= false then
		self:anim("trsp", false); 
	end;
	
	if self.runs > 0 then
		self:setHydraulicDirection();
		self.runs = self.runs - 1;
	end;
	
end;

function ClaasCougar1400:draw()

	
	if self.rundumleuchtenAn then
		g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_15"), InputBinding.ClaasCougar1400_rul);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_14"), InputBinding.ClaasCougar1400_rul);
	end; 
	
	g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_11"), InputBinding.ClaasCougar1400_changeWheel);
	
	if self.changeWheel == 0  then
		renderText(0.03, 0.1, 0.025, " Current Steering Mode: 4-Wheel ");
	end;
	if self.changeWheel == 1  then
		renderText(0.03, 0.1, 0.025, " Current Steering Mode: Rear-Wheel Only ");
	end;
	if self.changeWheel == 2  then
		renderText(0.03, 0.1, 0.025, " Current Steering Mode: Front-Wheel Only ");
	end;
		
	if self.Go.front and not self.turnOn then
		g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_1"), InputBinding.ClaasCougar1400_trsp);

	elseif not self.turnOn  then
		g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_2"), InputBinding.ClaasCougar1400_trsp);
	end; 	

	if not self.trsp and not self.Done.trsp then	
		if self.turnOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_13"), InputBinding.ClaasCougar1400_on);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_12"), InputBinding.ClaasCougar1400_on);

		end; 
		if self.runMower then
		if self.Go.armrechts then
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_5").. " " ..g_i18n:getText("ClaasCougar1400_3"), InputBinding.ClaasCougar1400_armrechts);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_5").. " " ..g_i18n:getText("ClaasCougar1400_4"), InputBinding.ClaasCougar1400_armrechts);
		end; 
		if self.Go.armlinks then
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_6").. " " ..g_i18n:getText("ClaasCougar1400_3"), InputBinding.ClaasCougar1400_armlinks);

		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_6").. " " ..g_i18n:getText("ClaasCougar1400_4"), InputBinding.ClaasCougar1400_armlinks);

		end; 
		if self.Go.frontlinks then
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_8").. " " ..g_i18n:getText("ClaasCougar1400_3"), InputBinding.ClaasCougar1400_frontlinks);


		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_8").. " " ..g_i18n:getText("ClaasCougar1400_4"), InputBinding.ClaasCougar1400_frontlinks);

		end; 
		if self.Go.frontrechts then
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_7").. " " ..g_i18n:getText("ClaasCougar1400_3"), InputBinding.ClaasCougar1400_frontrechts);

		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_7").. " " ..g_i18n:getText("ClaasCougar1400_4"), InputBinding.ClaasCougar1400_frontrechts);

		end; 
		if self.Go.frontfront then
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_9").. " " ..g_i18n:getText("ClaasCougar1400_3"), InputBinding.ClaasCougar1400_frontfront);

		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_9").. " " ..g_i18n:getText("ClaasCougar1400_4"), InputBinding.ClaasCougar1400_frontfront);

		end;
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_10").. " " ..g_i18n:getText("ClaasCougar1400_3"), InputBinding.ClaasCougar1400_raise);
			g_currentMission:addHelpButtonText(g_i18n:getText("ClaasCougar1400_10").. " " ..g_i18n:getText("ClaasCougar1400_4"), InputBinding.ClaasCougar1400_lower);
 
		end; 
	end; 		
end;

function ClaasCougar1400:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		self.trsp = Utils.getNoNil(getXMLBool(xmlFile, key.."#trsp"),true);
		self.changeWheel = Utils.getNoNil(getXMLFloat(xmlFile, key.."#steer"),0);
		self.Speed.frontlinks = 10.0; 
		self.Speed.frontrechts = 10.0; 
		self.Speed.armlinks = 10.0; 
		self.Speed.armrechts = 10.0;
		self.Speed.trsp = 10.0; 
		self.Speed.front = 10.0; 
		self.Speed.frontfront = 10.0; 
		if not self.trsp then
			self.Go.front = false; 
			self.Done.front = true; 
			self.Go.frontlinks = 1500.0;
			self.Done.frontlinks = true; 
			self.Go.frontrechts = 1500.0;
			self.Done.frontrechts = true; 
			self.Go.frontfront = true;
			self.Done.frontfront = true; 
			self.Go.trsp = false; 
			self.Done.trsp = true; 
			self.Go.armlinks = 1500.0;
			self.Done.armlinks = true; 
			self.Go.armrechts = 1500.0;
			self.Done.armrechts = true; 
			self.accDirection = -1;
		end; 
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ClaasCougar1400:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'trsp="'..tostring(self.trsp)..'" steer="'..tonumber(self.changeWheel)..'"';
	return attributes, nil;
end;

function ClaasCougar1400:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 1);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	end;
end;

function ClaasCougar1400:changeSteer(wheel11,wheel12, wheel21, wheel22, wheel31, wheel32, wheel41, wheel42)
	if not self.trsp then
		self.wheels[1].rotSpeed = Utils.degToRad(70); 
		self.wheels[2].rotSpeed = Utils.degToRad(70);
		self.wheels[3].rotSpeed = Utils.degToRad(-70); 
		self.wheels[4].rotSpeed = Utils.degToRad(-70); 
	else
		self.wheels[1].rotSpeed = Utils.degToRad(-70); 
		self.wheels[2].rotSpeed = Utils.degToRad(-70);
		self.wheels[3].rotSpeed = Utils.degToRad(70); 
		self.wheels[4].rotSpeed = Utils.degToRad(70); 
	end; 
	self.wheels[1].rotMax = Utils.degToRad(wheel11); 
	self.wheels[2].rotMax = Utils.degToRad(wheel21); 
	self.wheels[1].rotMin = Utils.degToRad(wheel12); 
	self.wheels[2].rotMin = Utils.degToRad(wheel22);	
	self.wheels[3].rotMax = Utils.degToRad(wheel31); 
	self.wheels[4].rotMax = Utils.degToRad(wheel41); 
	self.wheels[3].rotMin = Utils.degToRad(wheel32); 
	self.wheels[4].rotMin = Utils.degToRad(wheel42); 			
end; 
							
function ClaasCougar1400:setJointRotLimit(nodei, up, down, speed, value, axle, dt)
	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end; 

function ClaasCougar1400:lowerRmp()
	if self.backupRmp then
		if self.motor.minRpm <= self.backupRmp then
			self.motor.minRpm = self.motor.minRpm + 10; 
		else
			self.motor.minRpm = self.backupRmp; 
			self.backupRmp = nil; 			
		end; 	
	end; 
end;

function ClaasCougar1400:onLeave()
	self.turnOn = false;
    Utils.setEmittingState(self.particleSystemfront, false);
    Utils.setEmittingState(self.particleSystemfrontlinks, false);
    Utils.setEmittingState(self.particleSystemfrontrechts, false);
    Utils.setEmittingState(self.particleSystemlinks, false);
	Utils.setEmittingState(self.particleSystemrechts, false);
	self:lowerRmp(); 
	if self.loopSoundEnabled then
		stopSample(self.loopSound);
		self.loopSoundEnabled = false;
	end;
end;

function ClaasCougar1400:onEnter()
end;

function ClaasCougar1400:delete()
    if self.StopSound ~= nil then
        delete(self.StopSound);
    end;	    
	if self.loopSound ~= nil then
        delete(self.loopSound);
    end;	    
	if self.workSound ~= nil then
        delete(self.workSound);
    end;	
	self.turnOn = false;
    Utils.setEmittingState(self.particleSystemfront, false);
    Utils.setEmittingState(self.particleSystemfrontlinks, false);
    Utils.setEmittingState(self.particleSystemfrontrechts, false);
    Utils.setEmittingState(self.particleSystemlinks, false);
	Utils.setEmittingState(self.particleSystemrechts, false);	
end;



function ClaasCougar1400:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ClaasCougar1400:keyEvent(unicode, sym, modifier, isDown)
end;