Radio = {};

function Radio.prerequisitesPresent(specializations)
    return true;
end;

function Radio:load(xmlFile)
	
    self.radioSounds = {};
    local i = 0;
    while true do
        local radioString = string.format("vehicle.radio.sound(%d)", i);
        local sound = {};
        local fileS = getXMLString(xmlFile, radioString .. "#file");
        if fileS == nil then
            break;
		end;
		if fileS ~= nil then
			local file = Utils.getFilename(fileS, self.baseDirectory); 
			sound.Sample = createSample("fileS"..i);
			loadSample(sound.Sample, file, false);
			sound.Offset = Utils.getNoNil(getXMLFloat(xmlFile, radioString.."#pitchOffset"), 1);
			sound.Volume = Utils.getNoNil(getXMLFloat(xmlFile, radioString.."#volumen"), 1);	
			sound.isStarted = false;
			sound.ende = 0;
			table.insert(self.radioSounds, sound);
        end;
		i = 1+i;
	end;
	if table.getn(self.radioSounds) > 0 then
		self.currentSong = 1;
	end;
	self.RadioOn = false;
	
end;

function Radio:delete()
	
	for k,v in pairs(self.radioSounds) do
		if v.Sample ~= nil then
			delete(v.Sample);
		end;		
	end;
end;

function Radio:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Radio:keyEvent(unicode, sym, modifier, isDown)

end;

function Radio:update(dt)

	if self:getIsActiveForInput() then		
		if InputBinding.hasEvent(InputBinding.Radio38vc) and table.getn(self.radioSounds) > 0 then
			self.RadioOn = not self.RadioOn;
		end;
		if self.RadioOn then
			if InputBinding.hasEvent(InputBinding.NextSong38vc) then
				stopSample(self.radioSounds[self.currentSong].Sample); self.radioSounds[self.currentSong].isStarted = false;
				self.currentSong = self.currentSong+1;
			elseif InputBinding.hasEvent(InputBinding.PrevSong38vc) then
				stopSample(self.radioSounds[self.currentSong].Sample); self.radioSounds[self.currentSong].isStarted = false;
				self.currentSong = self.currentSong-1;
				if self.currentSong < 1 then
					self.currentSong = table.getn(self.radioSounds);
				end;
			end;
		end;
	else
		self.RadioOn = false;
		for k,v in pairs(self.radioSounds) do
			if v.isStarted then	
				if v.Sample ~= nil then
					stopSample(v.Sample);
					v.isStarted = false;
				end;
			end;
		end;	
	end;

	if self:getIsActiveForSound() then
		if self.currentSong > table.getn(self.radioSounds) then
			self.currentSong = 1;
		end;
		local v = self.radioSounds[self.currentSong];
		if not v.isStarted and self.RadioOn then
			v.isStarted = true;
			local offset = 0;
			if v.Sample ~= nil then
				setSamplePitch(v.Sample, v.Offset);
				playSample(v.Sample, 1, v.Volume, 0);
				offset = getSampleDuration(v.Sample);
			end;
			v.ende = self.time+offset;			
		end;
		if self.time > v.ende then
			if v.isStarted then	
				if v.Sample ~= nil then
					stopSample(v.Sample);
					v.isStarted = false;
				end;
			end;
			self.currentSong = self.currentSong+1;
		end;
		if not self.RadioOn then
			if v.isStarted then	
				if v.Sample ~= nil then
					stopSample(v.Sample);
					v.isStarted = false;
				end;
			end;		
		end;
	end;
end;

function Radio:draw()
end;

function Radio:onLeave()
	if self.RadioOn then
		if self.radioSounds[self.currentSong].isStarted then	
			if self.radioSounds[self.currentSong].Sample ~= nil then
				stopSample(self.radioSounds[self.currentSong].Sample);
				self.radioSounds[self.currentSong].isStarted = false;
			end;
		end;		
		self.RadioOn = false;
	end;
end;