-- Original script: d47 strawmod
-- modification: Bassaddict






ubt = {};

function ubt.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function ubt:load(xmlFile)
	self.setBalePosition = SpecializationUtil.callSpecializationsFunction("setBalePosition");
	
	self.numAttachersBig = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers1#count"), 0);
	self.numAttachersRound = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers2#count"), 0);
	self.numAttachersNormal = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers3#count"), 0);
	
	self.AttacherBig = {};
	self.AttacherRound = {};
	self.AttacherNormal = {};
	
	self.attacherLevelBig = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Attachers1#index"));
	self.attacherLevelRound = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Attachers2#index"));
	self.attacherLevelNormal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Attachers3#index"));
	
	self.unloadLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadLeft#index"));
	self.unloadRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadRight#index"));
	self.unloadBack = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadBack#index"));
	self.trailerIsEmpty = true;
	self.typeOnTrailer = 1;
	self.baleType = {{"big",1},{"round",2},{"normal",3}};
	self.ulMode = 1;
	self.ulRef = {{"links",false,self.unloadLeft},{"hinten",false,self.unloadBack},{"rechts",false,self.unloadRight}};	
	for i=1, self.numAttachersBig do
		self.AttacherBig[i] = {};
		local partnamei = string.format("vehicle.Attachers1.objectAttacher".."%d",i);
		self.AttacherBig[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
		setRigidBodyType(self.AttacherBig[i].coll,"none");
		self.AttacherBig[i].attachedObject = nil;
		self.AttacherBig[i].objectInRange = nil;
	end;
	for i=1, self.numAttachersRound do
		self.AttacherRound[i] = {};
		local partnamei = string.format("vehicle.Attachers2.objectAttacher".."%d",i);
		self.AttacherRound[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
		setRigidBodyType(self.AttacherRound[i].coll,"none");
		self.AttacherRound[i].attachedObject = nil;
		self.AttacherRound[i].objectInRange = nil;
	end;
	for i=1, self.numAttachersNormal do
		self.AttacherNormal[i] = {};
		local partnamei = string.format("vehicle.Attachers3.objectAttacher".."%d",i);
		self.AttacherNormal[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
		setRigidBodyType(self.AttacherNormal[i].coll,"none");
		self.AttacherNormal[i].attachedObject = nil;
		self.AttacherNormal[i].objectInRange = nil;
	end;
	
	self.fillLevel = 0;
	if self.typeOnTrailer == 1 then
		self.fillLevelMax = self.numAttachersBig;
	elseif self.typeOnTrailer == 2 then
		self.fillLevelMax = self.numAttachersRound;
	elseif self.typeOnTrailer ==3 then
		self.fillLevelMax = self.numAttachersNormal;
	end;
	
	self.positionBale = false;
end;

function ubt:getSaveAttributesAndNodes(nodeIdent)
	if (not self.trailerIsEmpty) then
		if self.typeOnTrailer == 1 then
			for i=1, self.numAttachersBig do
				ObjectDetachUbt(self,i);
			end;
			self.trailerIsEmpty = true;
		elseif self.typeOnTrailer == 2 then
			for i=1, self.numAttachersRound do
				ObjectDetachUbt(self,i);
			end;
			self.trailerIsEmpty = true;
		elseif self.typeOnTrailer == 3 then
			for i=1, self.numAttachersNormal do
				ObjectDetachUbt(self,i);
			end;
			self.trailerIsEmpty = true;
		end;
	end;
	return nil, nil;
end;


function ubt:delete()
	if (not self.trailerIsEmpty) then
		if self.typeOnTrailer == 1 then
			for i=1, self.numAttachersBig do
				ObjectDetachUbt(self,i);
			end;
			self.trailerIsEmpty = true;
		elseif self.typeOnTrailer == 2 then
			for i=1, self.numAttachersRound do
				ObjectDetachUbt(self,i);
			end;
			self.trailerIsEmpty = true;
		elseif self.typeOnTrailer == 3 then
			for i=1, self.numAttachersNormal do
				ObjectDetachUbt(self,i);
			end;
			self.trailerIsEmpty = true;
		end;
	end;
end;

function ubt:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ubt:keyEvent(unicode, sym, modifier, isDown)
end;

function ubt:update(dt)

	if self.fillLevel == 0 then
		self.trailerIsEmpty = true;
	else
		self.trailerIsEmpty = false;
	end;

	if self:getIsActiveForInput() then
	
		if InputBinding.hasEvent(InputBinding.ubtATTACH) then
			-- detect bales in range
			if self.typeOnTrailer == 1 then -- big bales
				for i=1, self.numAttachersBig do
					nearest, index = ObjectInRangeUbt(self,i);
					self.AttacherBig[i].objectInRange = nearest;
					-- lock bale
					ObjectAttachUbt(self,i);
				end;
			elseif self.typeOnTrailer == 2 then -- roundbales
				for i=1, self.numAttachersRound do
					nearest, index = ObjectInRangeUbt(self,i);
					self.AttacherRound[i].objectInRange = nearest;
					-- lock bale
					ObjectAttachUbt(self,i);
				end;
			elseif self.typeOnTrailer == 3 then -- normal
				for i=1, self.numAttachersNormal do
					nearest, index = ObjectInRangeUbt(self,i);
					self.AttacherNormal[i].objectInRange = nearest;
					-- lock bale
					ObjectAttachUbt(self,i);
				end;
			end;
			
		end;
		
		if InputBinding.hasEvent(InputBinding.ubtDETACH) then
			-- unload
			if self.typeOnTrailer == 1 then -- big bales
				for i=1, self.numAttachersBig do
					ObjectDetachUbt(self,i);
				end;
				self.trailerIsEmpty = true;
			elseif self.typeOnTrailer == 2 then -- roundbales
				for i=1, self.numAttachersRound do
					ObjectDetachUbt(self,i);
				end;
				self.trailerIsEmpty = true;
			elseif self.typeOnTrailer == 3 then -- normal
				for i=1, self.numAttachersNormal do
					ObjectDetachUbt(self,i);
				end;
				self.trailerIsEmpty = true;
			end;
		end;

		if InputBinding.hasEvent(InputBinding.ubtTOGGLEUNLOAD) then
			if self.ulMode == 3 then
				self.ulMode = 0;
			end;
			self.ulMode = self.ulMode + 1;
		end;
		
		if InputBinding.hasEvent(InputBinding.ubtTOGGLEBALETYPE) then
			if self.trailerIsEmpty then
				if self.typeOnTrailer == 3 then
					self.typeOnTrailer = 0;
				end;
				self.typeOnTrailer = self.typeOnTrailer + 1;
				
				if self.typeOnTrailer == 1 then
					self.fillLevelMax = self.numAttachersBig;
				elseif self.typeOnTrailer == 2 then
					self.fillLevelMax = self.numAttachersRound;
				elseif self.typeOnTrailer ==3 then
					self.fillLevelMax = self.numAttachersNormal;
				end;
			end;
		end;
		
	end;
	
end;

function ubt:draw()
	if (not self.trailerIsEmpty) then
		g_currentMission:addExtraPrintText(string.format("Taste o: Ballen entladen"));
		g_currentMission:addExtraPrintText(string.format("Taste z: Entladen nach (%s)", self.ulRef[self.ulMode][1]));
		g_currentMission:addExtraPrintText(string.format("Fuellstand: (".."%d".." / ".."%d".."), Ballentyp: ".."%s",self.fillLevel,self.fillLevelMax,self.baleType[self.typeOnTrailer][1]));
	else
		g_currentMission:addExtraPrintText(string.format("Taste x: Ballentyp (%s)", self.baleType[self.typeOnTrailer][1]));
	end;
	if (not (self.fillLevel == self.fillLevelMax)) then
		g_currentMission:addExtraPrintText(string.format("Taste b: Ballen aufladen"));
	end;
end;

function ObjectInRangeUbt(self,k)
	local nearestObject;
	local itemNode;
	local index;
	local nearestDistance = 15;
	if self.typeOnTrailer == 1 then -- big bales
		local objectCopy = self.AttacherBig[k].object;
		local px, py, pz = getWorldTranslation(objectCopy);
		for index, item in pairs(g_currentMission.itemsToSave) do
			itemNode = item.item.nodeId;
			if getParent(item.item.nodeId) == getRootNode() then
				if (getUserAttribute(itemNode, "isStrawbale") or getUserAttribute(itemNode, "isHaybale")) and not (item.item.i3dFilename == "data/maps/models/objects/strawbale/haybaleBaler.i3d" or item.item.i3dFilename == "data/maps/models/objects/strawbale/strawbaleBaler.i3d") then
					local vx, vy, vz = getWorldTranslation(itemNode);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
					if distance < nearestDistance then
						index = index;
						nearestObject = itemNode;
						nearestDistance = distance;
					end;
				end;
			end
		end
	elseif self.typeOnTrailer == 2 then -- roundbales
		local objectCopy = self.AttacherRound[k].object;
		local px, py, pz = getWorldTranslation(objectCopy);
		for index, item in pairs(g_currentMission.itemsToSave) do
			itemNode = item.item.nodeId;
			if getParent(item.item.nodeId) == getRootNode() then
				if getUserAttribute(itemNode, "isRoundbale") then
					local vx, vy, vz = getWorldTranslation(itemNode);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
					if distance < nearestDistance then
						index = index;
						nearestObject = itemNode;
						nearestDistance = distance;
					end;
				end;
			end;
		end;
	elseif self.typeOnTrailer == 3 then -- normal
		local objectCopy = self.AttacherNormal[k].object;
		local px, py, pz = getWorldTranslation(objectCopy);
		for index, item in pairs(g_currentMission.itemsToSave) do
			itemNode = item.item.nodeId;
			if getParent(item.item.nodeId) == getRootNode() then
				if item.item.i3dFilename == "data/maps/models/objects/strawbale/haybaleBaler.i3d" or item.item.i3dFilename == "data/maps/models/objects/strawbale/strawbaleBaler.i3d" then
					local vx, vy, vz = getWorldTranslation(itemNode);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
					if distance < nearestDistance then
						index = index;
						nearestObject = itemNode;
						nearestDistance = distance;
					end;
				end;
			end;
		end;
	end;
	return nearestObject, index;
end;

function ObjectAttachUbt(self,k)
	if self.typeOnTrailer == 1 then -- big bales
		if self.AttacherBig[k].objectInRange ~= nil then
			if self.AttacherBig[k].attachedObject == nil then
				setRigidBodyType(self.AttacherBig[k].objectInRange,"none");
				local x,y,z = getWorldRotation(self.AttacherBig[k].objectInRange);		
				setTranslation(self.AttacherBig[k].objectInRange, 0,0,0);
				setRotation(self.AttacherBig[k].objectInRange, 0,0,0);
				link(self.AttacherBig[k].object,self.AttacherBig[k].objectInRange);
				self.AttacherBig[k].attachedObject = self.AttacherBig[k].objectInRange;
				self.AttacherBig[k].objectInRange = nil;
				self.positionBale = true;
				self.fillLevel = self.fillLevel + 1;
			end;
		end;
	elseif self.typeOnTrailer == 2 then --roundbales
		if self.AttacherRound[k].objectInRange ~= nil then
			if self.AttacherRound[k].attachedObject == nil then
				setRigidBodyType(self.AttacherRound[k].objectInRange,"none");
				local x,y,z = getWorldRotation(self.AttacherRound[k].objectInRange);		
				setTranslation(self.AttacherRound[k].objectInRange, 0,0,0);
				setRotation(self.AttacherRound[k].objectInRange, 0,0,0);
				link(self.AttacherRound[k].object,self.AttacherRound[k].objectInRange);
				self.AttacherRound[k].attachedObject = self.AttacherRound[k].objectInRange;
				self.AttacherRound[k].objectInRange = nil;
				self.positionBale = true;
				self.fillLevel = self.fillLevel + 1;
			end;
		end;
	elseif self.typeOnTrailer == 3 then --normal
		if self.AttacherNormal[k].objectInRange ~= nil then
			if self.AttacherNormal[k].attachedObject == nil then
				setRigidBodyType(self.AttacherNormal[k].objectInRange,"none");
				local x,y,z = getWorldRotation(self.AttacherNormal[k].objectInRange);		
				setTranslation(self.AttacherNormal[k].objectInRange, 0,0,0);
				setRotation(self.AttacherNormal[k].objectInRange, 0,0,0);
				link(self.AttacherNormal[k].object,self.AttacherNormal[k].objectInRange);
				self.AttacherNormal[k].attachedObject = self.AttacherNormal[k].objectInRange;
				self.AttacherNormal[k].objectInRange = nil;
				self.positionBale = true;
				self.fillLevel = self.fillLevel + 1;
			end;
		end;
	end;
end;

function ObjectDetachUbt(self,k)
	if self.typeOnTrailer == 1 then -- big bales
		if self.AttacherBig[k].attachedObject ~= nil then			
			if not self.ulRef[self.ulMode][2] then
				local x,y,z = getWorldTranslation(self.AttacherBig[k].attachedObject);
				local rx,ry,rz = getWorldRotation(self.AttacherBig[k].attachedObject);
				local nx,ny,nz = getWorldTranslation(self.attacherLevelBig);
				local tx,ty,tz = getWorldTranslation(self.ulRef[self.ulMode][3]);
				local x = x + (tx - nx);
				local y = y + (ty - ny);
				local z = z + (tz - nz);
				local tH = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				local relHeight = ny - tH;
				local root = getRootNode();
				setRigidBodyType(self.AttacherBig[k].attachedObject,"Dynamic");
				setTranslation(self.AttacherBig[k].attachedObject,x,(y - relHeight),z);
				setRotation(self.AttacherBig[k].attachedObject,rx,ry,rz);
				link(root,self.AttacherBig[k].attachedObject);
				self.AttacherBig[k].attachedObject = nil;
				self.fillLevel = self.fillLevel - 1;
			else
				---[[ --Custom unloading chunk.  If you break the game with this and can't fix it, remove a dash from this line to deactivate it.
				--print(self.ulRef[self.ulMode][3]);
				-- End of custom unloading chunk. Just leave this line alone.]]
			end;
		end;
	elseif self.typeOnTrailer == 2 then --roundbales
		if self.AttacherRound[k].attachedObject ~= nil then			
			if not self.ulRef[self.ulMode][2] then
				local x,y,z = getWorldTranslation(self.AttacherRound[k].attachedObject);
				local rx,ry,rz = getWorldRotation(self.AttacherRound[k].attachedObject);
				local nx,ny,nz = getWorldTranslation(self.attacherLevelRound);
				local tx,ty,tz = getWorldTranslation(self.ulRef[self.ulMode][3]);
				local x = x + (tx - nx);
				local y = y + (ty - ny);
				local z = z + (tz - nz);
				local tH = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				local relHeight = ny - tH;
				local root = getRootNode();
				setRigidBodyType(self.AttacherRound[k].attachedObject,"Dynamic");
				setTranslation(self.AttacherRound[k].attachedObject,x,(y - relHeight),z);
				setRotation(self.AttacherRound[k].attachedObject,rx,ry,rz);
				link(root,self.AttacherRound[k].attachedObject);
				self.AttacherRound[k].attachedObject = nil;
				self.fillLevel = self.fillLevel - 1;
			else
				---[[ --Custom unloading chunk.  If you break the game with this and can't fix it, remove a dash from this line to deactivate it.
				--print(self.ulRef[self.ulMode][3]);
				-- End of custom unloading chunk. Just leave this line alone.]]
			end;
		end;
	elseif self.typeOnTrailer == 3 then --normal
		if self.AttacherNormal[k].attachedObject ~= nil then			
			if not self.ulRef[self.ulMode][2] then
				local x,y,z = getWorldTranslation(self.AttacherNormal[k].attachedObject);
				local rx,ry,rz = getWorldRotation(self.AttacherNormal[k].attachedObject);
				local nx,ny,nz = getWorldTranslation(self.attacherLevelNormal);
				local tx,ty,tz = getWorldTranslation(self.ulRef[self.ulMode][3]);
				local x = x + (tx - nx);
				local y = y + (ty - ny);
				local z = z + (tz - nz);
				local tH = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				local relHeight = ny - tH;
				local root = getRootNode();
				setRigidBodyType(self.AttacherNormal[k].attachedObject,"Dynamic");
				setTranslation(self.AttacherNormal[k].attachedObject,x,(y - relHeight),z);
				setRotation(self.AttacherNormal[k].attachedObject,rx,ry,rz);
				link(root,self.AttacherNormal[k].attachedObject);
				self.AttacherNormal[k].attachedObject = nil;
				self.fillLevel = self.fillLevel - 1;
			else
				---[[ --Custom unloading chunk.  If you break the game with this and can't fix it, remove a dash from this line to deactivate it.
				--print(self.ulRef[self.ulMode][3]);
				-- End of custom unloading chunk. Just leave this line alone.]]
			end;
		end;
	end;
end;

function ubt:readStream(streamId, connection)
    self:setBalePosition(streamReadBool(streamId), true);  
end;

function ubt:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.positionBale);   
end;

function ubt:setBalePosition(newPosition, noEventSend)
    PositionEvent.sendEvent(self, newPosition, noEventSend);
    self.positionBale = newPosition;
end;

PositionEvent = {};
PositionEvent_mt = Class(PositionEvent, Event);

InitEventClass(PositionEvent, "PositionEvent");

function PositionEvent:emptyNew()
    local self = Event:new(PositionEvent_mt );
    self.className="PositionEvent";
    return self;
end;

function PositionEvent:new(vehicle, position) 
    self.vehicle = vehicle;
    self.position = position;
    return self;
end;

function PositionEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.position = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function PositionEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteBool(streamId, self.position );   
end;

function PositionEvent:run(connection)  
    self.vehicle:setBalePosition(self.position, true); 
	if not connection:getIsServer() then  
		g_server:broadcastEvent(PositionEvent:new(self.vehicle, self.position), nil, connection, self.object);
	end;
end;

function PositionEvent.sendEvent(vehicle, position, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(PositionEvent:new(vehicle, position), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(PositionEvent:new(vehicle, position));
		end;
	end;
end;
