xerion3huEvent = {};
xerion3huEvent_mt = Class(xerion3huEvent, Event);

InitEventClass(xerion3huEvent, "xerion3huEvent");

xerion3huEventType = {
	rundumleuchte = 1,
	worklights_v = 2,
	worklights_h = 3,
	drivingDir = 4,
	maxRpm = 5,
	rev_level = 6
	-- translatePos=5,
	-- rotatePos=6
	-- worklights = 2,	
	-- maxRpm = 4,
	-- drivingDir = 5,
	-- steerMode = 6
}

function xerion3huEvent:emptyNew()
    local self = Event:new(xerion3huEvent_mt);
    self.className="xerion3huEvent";
    return self;
end;

function xerion3huEvent:new(object, eventType, data)
    local self = xerion3huEvent:emptyNew()
    self.object = object;
	self.eventType = eventType;
	self.data = data;
    return self;
end;

function xerion3huEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	
	self.eventType = streamReadUInt8(streamId);

	if self.eventType == xerion3huEventType.rundumleuchte then
		self.data = streamReadBool(streamId);
		self.object:setRundumleuchte(self.data, true);
	 elseif self.eventType == xerion3huEventType.worklights_v then
		 self.data = streamReadBool(streamId);
		 self.object:setWorklightsActive_v(self.data, true);
	 elseif self.eventType == xerion3huEventType.worklights_h then
		 self.data = streamReadBool(streamId);
		 self.object:setWorklightsActive_h(self.data, true);
	elseif self.eventType == xerion3huEventType.drivingDir then
		self.data = streamReadInt8(streamId);
		self.object.drivingDir = self.data;
	elseif self.eventType == xerion3huEventType.maxRpm then
		self.data = streamReadInt32(streamId);
		self.object.motor.maxRpm[self.motor.speedLevel] = self.data;
	elseif self.eventType == xerion3huEventType.rev_level then
		self.data = streamReadBool(streamId);
		self.object.rev_level = self.data;
	-- elseif self.eventType == xerion3huEventType.rotatePos then
		-- self.data = streamReadString(streamId);
		-- self.object.rotatePos = self.data;
	-- elseif self.eventType == xerion3huEventType.threshedTotal then
		-- self.data = streamReadFloat32(streamId);
		-- self.object.TreshedTotalNumber = self.data;
	end;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(xerion3huEvent:new(self.object, self.eventType, self.data), nil, connection, self.object);
    end;
end;

function xerion3huEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUInt8(streamId, self.eventType);
	 if self.eventType == xerion3huEventType.drivingDir then
		streamWriteInt8(streamId, self.data);
	 elseif self.eventType == xerion3huEventType.maxRpm then
		streamWriteInt32(streamId, self.data);
	 -- elseif self.eventType >= xerion3huEventType.drivingDir then
		 -- streamWriteInt8(streamId, self.data);
	 else
		streamWriteBool(streamId, self.data);
	 end;
end;

function xerion3huEvent.sendEvent(vehicle, eventType, data)
	if g_server ~= nil then
		g_server:broadcastEvent(xerion3huEvent:new(vehicle, eventType, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(xerion3huEvent:new(vehicle, eventType, data));
	end;
end;

