--
-- xerion3hu
-- Class for Claas xerion3hu
--
-- @author  JACK (ICQ brauchst du nicht )
-- @date  21/04/09

xerion3hu = {};

function xerion3hu.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function xerion3hu:load(xmlFile)


	self.setRundumleuchte = SpecializationUtil.callSpecializationsFunction("setRundumleuchte");
    self.setWorklightsActive_v = SpecializationUtil.callSpecializationsFunction("setWorklightsActive_v");
	self.setWorklightsActive_h = SpecializationUtil.callSpecializationsFunction("setWorklightsActive_h");


    local CabIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cab#index"));
    if CabIndex ~= nil then
	    self.Cab = {};
	    self.Cab.index = CabIndex;
	    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cab#forwardTrans"));
		
	    self.Cab.forwardTrans = {};
	    self.Cab.forwardTrans[1] = Utils.getNoNil(x, 0);
	    self.Cab.forwardTrans[2] = Utils.getNoNil(y, 0);
	    self.Cab.forwardTrans[3] = Utils.getNoNil(z, 0);
	
	    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cab#reverseTrans"));
	    self.Cab.reverseTrans = {};
	    self.Cab.reverseTrans[1] = Utils.getNoNil(x, 0);
	    self.Cab.reverseTrans[2] = Utils.getNoNil(y, 0);
	    self.Cab.reverseTrans[3] = Utils.getNoNil(z, 0);
	
	    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile," vehicle.cab#forwardRot"));
	    self.Cab.forwardRot = {};
	    self.Cab.forwardRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	    self.Cab.forwardRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	    self.Cab.forwardRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cab#reverseRot"));
	    self.Cab.reverseRot = {};
	    self.Cab.reverseRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	    self.Cab.reverseRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	    self.Cab.reverseRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
	
	    self.Cab.timeScale = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cab#timeScale"), 2)*1000;
	  end;

    self.numLightsCab = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cablights#count"), 0);
    self.cablights = {};
    for i=1, self.numLightsCab do
        local lightnamei = string.format("vehicle.cablights.light" .. "%d", i);
        self.cablights[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, lightnamei .. "#index"));
    end;
    
	
	self.joblight_v = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joblight_v#index"));
	self.joblight_b = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joblight_b#index"));

    self.exhaustParticleLow = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleLow, "vehicle.exhaustParticleLow", self.rootNode, false, nil, self.baseDirectory);
    self.exhaustParticleHigh = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleHigh, "vehicle.exhaustParticleHigh", self.rootNode, false, nil, self.baseDirectory);
	
	-- self.trailerAttacherJoints = {};
      -- local obj = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", 0);
      -- self.TAJindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, obj.. "#index"));
      -- self.TAJdomv = Utils.getNoNil(getXMLBool(xmlFile, obj.. "#moveable"),false);
      -- self.TAJlow = Utils.getNoNil(getXMLBool(xmlFile, obj.. "#low"),false);
	-- if self.TAJdomv then
      -- self.TAJminY = Utils.getNoNil(getXMLFloat(xmlFile, obj.. "#minY"),0);
      -- self.TAJmaxY = Utils.getNoNil(getXMLFloat(xmlFile, obj.. "#maxY"),0);
	-- end;


	
	
	
	
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
           break;
        end;
        self.keys[inputName] = Input[inputKey];
--        print("Keys: " .. inputName .. " = " .. inputKey .. " = " .. Input[inputKey] .. " : " .. self.keys[inputName]);
        i = i+1;
    end;

    -- self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);
    -- self.motorBrakeForce = self.motor.brakeForce;

    -- self.speedRotScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#scale"), 80);
    -- self.speedRotScaleOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#offset"), 0.7);

    -- self.Joint = self.TAJindex;
    -- self.trailerAttacherJointIndex = 0;
    -- self.attachedTrailer = nil;

   -- self.brakeOn = false;
   -- self.revLimit = 100;
   -- self.maxRpm3 = self.motor.maxRpm[3];
   -- self.activeTAJ = 0;
    
	-- RPM Limiter load
	local motorMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
	local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
	local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
	motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
	motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
	motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
	local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
	self.motorMaxRpmLimit = motorMaxRpm;
	
	
	self.fGearRatios = self.motor.forwardGearRatios;
    self.bGearRatio = self.motor.backwardGearRatio;
	self.rev_level= false;
    self.drivingDir = 1;
    self.rotatePos = "forward";
    self.translatePos = "forward";
    self.doRotate = false;
    self.doTranslate = false;
    self.stopMoving = false;
    self.xerionRun = false;

    self.joblightActive_V = false;
	self.joblightActive_B = false;

    self.showhelp = false;
    self.hudInfo = Utils.getFilename("hud_help_base.png", self.baseDirectory);
    self.hudInfoPoxX = 0.012;
    self.hudInfoPoxY = 0.18;
    self.hudInfoWidth = 0.425;
    self.hudInfoHeight = 0.1625;
    self.hudInfoOverlay = Overlay:new("hudInfoOverlay", self.hudInfo, self.hudInfoPoxX, self.hudInfoPoxY, self.hudInfoWidth, self.hudInfoHeight);

	self.isActor = false;
	
end;

function xerion3hu:readStream(streamId, connection)

	self:setRundumleuchte(streamReadBool(streamId), true);
	self:setWorklightsActive_v(streamReadBool(streamId), true);
	self:setWorklightsActive_h(streamReadBool(streamId), true);
	self.drivingDir = streamReadInt8(streamId);	
	self.motor.maxRpm[self.motor.speedLevel] = streamReadInt32(streamId);
	self.rev_level = streamReadBool(streamId);	
end;

function xerion3hu:writeStream(streamId, connection)

	
	streamWriteBool(streamId, self.joblightActive_V);
	streamWriteBool(streamId, self.joblightActive_B);
	streamWriteInt8(streamId, self.drivingDir);
	streamWriteInt32(streamId, self.motor.maxRpm[self.motor.speedLevel]);
	streamWriteBool(streamId, self.rev_level);
end;

function xerion3hu:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.cabrotate then
      self.drivingDir = self.drivingDir * -1;
      g_currentMission.allowSteerableMoving = false;
	  
	  xerion3huEvent.sendEvent(self, xerion3huEventType.drivingDir, self.drivingDir);

	self.cabon = not self.cabon;
      	if self.drivingDir == -1 then
			self.ESLimiter.percentage[1]=100;
		end;
    end;
    
    if isDown and sym == self.keys.joblight_v then
	  self:setWorklightsActive_v(not self.joblightActive_V);
    end;
	
    if isDown and sym == self.keys.joblight_b then
	 self:setWorklightsActive_h(not self.joblightActive_B);
    end;
	
    if isDown and sym == self.keys.hilfe then
      if self.hudInfoOverlay ~= nil then
      	self.showhelp = not self.showhelp;
      end;
    end;


    if sym == self.keys.moveAK_up then
      self.moveAK_up = isDown;
      end;

    if sym == self.keys.moveAK_dn then
      self.moveAK_dn = isDown;
      end;
	  
	if InputBinding.isPressed(InputBinding.fahrstufe_rev_cab) then
			self.rev_level = not self.rev_level;
			xerion3huEvent.sendEvent(self, xerion3huEventType.rev_level, self.rev_level);
	end;
end;

function xerion3hu:update(dt)
--maxAccelerationSpeed
	-- self.lastSpeed = self.lastSpeed*self.drivingDir;

	-- self.maxAccelerationSpeed= 0.1*self.drivingDir;
	-- self.motor.lastMotorRpm = self.motor.lastMotorRpm *self.drivingDir;

	if self:getIsActive() then  

		if self:getIsActiveForInput() then
			self.beschleu = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			if InputBinding.isAxisZero(self.beschleu) then
				self.beschleu = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			end;
			self.beschleu= self.beschleu * -1;
			if self.beschleu ~= 0 then
				self.rev_level = false;
			end;
		end;


		if self.beschleu ~= nil and self.drivingDir == -1 then
		
			-- if self.beschleu > 0 then
		    -- self.motor.brakeForce=0;
			-- end;
			self.wheels[1].driveMode = 0; 
			self.wheels[2].driveMode = 0;
			self.wheels[3].driveMode = 0; 
			self.wheels[4].driveMode = 0; 
			
			-- self.motor.backwardGearRatio = 7;
			-- self.motor.forwardGearRatios = {6, 6, 6};

			WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, (self.beschleu * -1), false, 0);
		end;
		if self.rev_level and self.drivingDir == -1 then
			self.wheels[1].driveMode = 0; 
			self.wheels[2].driveMode = 0;
			self.wheels[3].driveMode = 0; 
			self.wheels[4].driveMode = 0; 
			WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, -1, false, 0);
		end; 

		if self.drivingDir == 1 then
			-- self.motor.backwardGearRatio = self.bGearRatio;
			-- self.motor.forwardGearRatios = self.fGearRatios;
			self.wheels[1].driveMode = 2; 
			self.wheels[2].driveMode = 2;
			self.wheels[3].driveMode = 2; 
			self.wheels[4].driveMode = 2; 
		end;
	end;
	
	
				  if self.joblight_v ~= nil then

					  setVisibility(self.joblight_v, self.joblightActive_V);
				  end;
				  if self.joblight_b ~= nil then

					  setVisibility(self.joblight_b, self.joblightActive_B);
				  end;
    self.firstTimeRun = false;
    local eps = 0.002;
    if self.Cab ~= nil then
				if self.isEntered then

				
				  if self.numLightsCab > 0 then
					  for i=1, self.numLightsCab do
						  setVisibility(self.cablights[i], self.lightsActive);
					  end;
				  end;

-- bernehmen
		
				  -- local acceleration = 0;
				  -- if g_currentMission.allowSteerableMoving and not self.playMotorSound then
					  -- acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
					  -- acceleration = 0.5;
					  -- if math.abs(acceleration) > 0.8 then
						  -- self.motor:setSpeedLevel(0, true)
					  -- end;
					  -- if self.motor.speedLevel ~= 0 then
						  -- acceleration = 1.0;
					  -- end;
				  -- end;
			  
					-- if self.steering ~= nil then
				-- print("steering:",self.steeringSpeed);
						-- setRotation(self.steering, 0, self.steeringSpeed, 0);
					-- end;			  
			    
				  if self.fuelFillLevel == 0 then
					  acceleration = 0;
				  end;
				end;

 -- if self.cabon then
-- self.lastSpeed = self.lastSpeed*0.2;

                -- local rotScale = math.max(1.0/(self.lastSpeed*self.speedRotScale+self.speedRotScaleOffset), 1);
                -- local inputAxisX = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_SIDE);
                -- if inputAxisX < 0 then
                    -- self.rotatedTime = math.min(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.maxRotTime);
                -- elseif Input.isKeyPressed(Input.KEY_d) then
                -- elseif inputAxisX > 0 then
                    -- self.rotatedTime = math.max(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.minRotTime);
                -- end;
            
 -- end;



-- renderText(0.01, 0.06, 0.02, string.format("%f", self.rotatedTime));

		      if(self.drivingDir == -1 and self.translatePos == "forward") then
		        self.doTranslate = true;
		      end;
		      if(self.drivingDir == -1 and self.translatePos == "reverse") then
		        self.doRotate = true;
		      end;
		      if(self.drivingDir == 1 and self.rotatePos == "reverse") then
		        self.doRotate = false;
		      end; 
		      if(self.drivingDir == 1 and self.rotatePos == "forward") then
		        self.doTranslate = false;
		      end;
		      
		      if self.rotatePos == "running" or self.translatePos == "running" then
		         g_currentMission.allowSteerableMoving = false;
		         self.stopMoving = true;
		      else
		         if self.stopMoving and not g_currentMission.allowSteerableMoving then
		            g_currentMission.allowSteerableMoving = true;
		            self.stopMoving = false;
		         end;
		      end;
		      self.rotatePos = "running";
		      local x, y, z = getRotation(self.Cab.index);
		      local rot = {x,y,z};

		      if(math.abs(x - self.Cab.reverseRot[1]) < eps and math.abs(y - self.Cab.reverseRot[2]) < eps and math.abs(z - self.Cab.reverseRot[3]) < eps ) then
		        self.rotatePos = "reverse";

		      end;
		      if(math.abs(x - self.Cab.forwardRot[1]) < eps and math.abs(y - self.Cab.forwardRot[2]) < eps and math.abs(z - self.Cab.forwardRot[3]) < eps ) then
		        self.rotatePos = "forward";

		      end;
		      local newRot = Utils.getMovedLimitedValues(rot, self.Cab.forwardRot, self.Cab.reverseRot, 3, self.Cab.timeScale, dt, self.doRotate);
		      setRotation(self.Cab.index, unpack(newRot));
		
		      self.translatePos = "running";

		      local x, y, z = getTranslation(self.Cab.index);
		      local trans = {x,y,z};
		      if(math.abs(x - self.Cab.reverseTrans[1]) < eps and math.abs(y - self.Cab.reverseTrans[2]) < eps and math.abs(z - self.Cab.reverseTrans[3]) < eps ) then
		        self.translatePos = "reverse";

		      end;
		      if(math.abs(x - self.Cab.forwardTrans[1]) < eps and math.abs(y - self.Cab.forwardTrans[2]) < eps and math.abs(z - self.Cab.forwardTrans[3]) < eps ) then
		        self.translatePos = "forward";

		      end;
		      local newTrans = Utils.getMovedLimitedValues(trans, self.Cab.forwardTrans, self.Cab.reverseTrans, 3, self.Cab.timeScale, dt, self.doTranslate);
		      setTranslation(self.Cab.index, unpack(newTrans));

-- ende bernehmen

				
    end;
	
	
	-- if self:getIsActiveForInput() and self.isEntered then
        -- if self.motor.speedLevel ~= 0 then
            -- if InputBinding.isPressed(InputBinding.ACCELERATE) then
                -- if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
                    -- self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
                -- end;
            -- elseif InputBinding.isPressed(InputBinding.DECELERATE) then
                -- if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
                    -- self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
                -- end;
        	-- end;
        -- else
            -- if InputBinding.isPressed(InputBinding.ACCELERATE) then
                -- if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
                    -- self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
                -- end;
            -- elseif InputBinding.isPressed(InputBinding.DECELERATE) then
                -- if self.motor.maxRpm[3] >= 10 then
                    -- self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
                -- end;
        	-- end;
        -- end;
	-- end;
	
	
	
	    self.xerionRun = true;
	

	
	
end;

function xerion3hu:draw()


	--setTextBold(true);
	--renderText(self.hudInfoPoxX, self.hudInfoPoxY+0.10, 0.021, string.format("%s%d%%" , "Motorleistung:", self.revLimit));
	--g_currentMission:addExtraPrintText(			..string.format("%s%d%%" , "Motorleistung:", self.revLimit));
	--g_currentMission:addExtraPrintText("valami");

    if not self.showhelp then
    	g_currentMission:addExtraPrintText("Key "..string.upper(string.char(self.keys.hilfe))..":                     	 Claas Menu");
    else
    	self.hudInfoOverlay:render();
    	local helptext={};
    	
        helptext[1] = " ";
	helptext[2] = " ";
    	helptext[3] = " "..key_convert(self.keys.cabrotate)..": Rotate Cab";
    	helptext[4] = " Key J: Front Worklights";
	helptext[5] = " Key K: Rear Worklights";
    	helptext[6] = " PageUP/PageDown: ESLimiter Increase/Decrease ";	   	
	helptext[7] = " Key 7/8: Raise/Lower Trailer Attach";
	helptext[8] = " "..key_convert(self.keys.hilfe)..": Menu Exit";

    	for i=1, table.getn(helptext) do
    		renderText((self.hudInfoPoxX+0.05),((self.hudInfoPoxY+self.hudInfoHeight) - (0.02*i)),0.02,helptext[i]);
    	end;
		
    	


    	for i=1, table.getn(helptext) do
    		renderText((self.hudInfoPoxX+0.05),((self.hudInfoPoxY+self.hudInfoHeight) - (0.02*i)),0.02,helptext[i]);
    	end;
		

    end;
		g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fahrstufe_rev_cab)..":   " .. g_i18n:getText("fahr_rev_cab_controls"), self.typeDesc));
		
	
	-- if self.motor.speedLevel ~= 0 then
        -- g_currentMission:addExtraPrintText("KEY 8(+)/7(-):   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
    -- else
        -- g_currentMission:addExtraPrintText("KEY 8(+)/7(-):   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	-- end;
	
	--Kompass
	local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
	local length = Utils.vector2Length(x,z);
	local dX = x/length;
	local dZ = z/length;
	local Richtung = math.deg(math.atan2(dX,dZ));
	if Richtung < 0  then 
		Richtung = 360 - (Richtung * -1);
    end;
	renderText(0.60,0.95,0.03,string.format("Compass: %3.0f ",360 - math.floor(Richtung + 0.5) ));

end;

function xerion3hu:mouseEvent(posX, posY, isDown, isUp, button)
end;

function xerion3hu:onEnter()

	self.isActor = self.isEntered;
end;

function xerion3hu:delete()
Utils.deleteParticleSystem(self.exhaustParticleLow);
Utils.deleteParticleSystem(self.exhaustParticleHigh);
end;

function xerion3hu:onLeave() 
    
	self:setWorklightsActive_v(false);
    self:setWorklightsActive_h(false);
	
	if self.isActor then

		self.isActor = false;
	end;

    Utils.setEmittingState(self.exhaustParticleLow, false);
    Utils.setEmittingState(self.exhaustParticleHigh, false);
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;


function xerion3hu:setWorklightsActive_v(state, noSendEvent)
	self.joblightActive_V = state;
	
	setVisibility(self.joblight_v, self.joblightActive_V);
	
	if noSendEvent ~= true then
		xerion3huEvent.sendEvent(self, xerion3huEventType.worklights_v, self.joblightActive_V);
	end;
end;

function xerion3hu:setWorklightsActive_h(state, noSendEvent)
	self.joblightActive_B = state;
	
	setVisibility(self.joblight_b, self.joblightActive_B);
	
	if noSendEvent ~= true then
		xerion3huEvent.sendEvent(self, xerion3huEventType.worklights_h, self.joblightActive_B);
	end;
end;
