iranyvaltoEvent = {};
iranyvaltoEvent_mt = Class(iranyvaltoEvent, Event);

InitEventClass(iranyvaltoEvent, "iranyvaltoEvent");

iranyvaltoEventType = {
	richtung_v = 1,
	richtung_0 = 2,
	richtung_r = 3,
	input = 4,
	movingDirection= 5
	-- translatePos=5,
	-- rotatePos=6
	-- worklights = 2,	
	-- maxRpm = 4,
	-- drivingDir = 5,
	-- steerMode = 6
}

function iranyvaltoEvent:emptyNew()
    local self = Event:new(iranyvaltoEvent_mt);
    self.className="iranyvaltoEvent";
    return self;
end;

function iranyvaltoEvent:new(object, eventType, data)
    local self = iranyvaltoEvent:emptyNew()
    self.object = object;
	self.eventType = eventType;
	self.data = data;
    return self;
end;

function iranyvaltoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	
	self.eventType = streamReadUInt8(streamId);

	if self.eventType == iranyvaltoEventType.richtung_v then
		self.data = streamReadBool(streamId);
		self.object.gang1 = self.data;
	 elseif self.eventType == iranyvaltoEventType.richtung_0 then
		 self.data = streamReadBool(streamId);
		self.object.gang0 = self.data;
	 elseif self.eventType == iranyvaltoEventType.richtung_r then
		 self.data = streamReadBool(streamId);
		self.object.reverse = self.data;
	elseif self.eventType == iranyvaltoEventType.input then
		self.data = streamReadFloat32(streamId);
		self.object.input = self.data;
	elseif self.eventType == iranyvaltoEventType.movingDirection then
		self.data = streamReadInt8(streamId);
		self.object.movingDirection = self.data;
	end;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(iranyvaltoEvent:new(self.object, self.eventType, self.data), nil, connection, self.object);
    end;
end;

function iranyvaltoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUInt8(streamId, self.eventType);
	 if self.eventType == iranyvaltoEventType.input then
		streamWriteFloat32(streamId, self.data);
	 elseif self.eventType == iranyvaltoEventType.movingDirection then
		streamWriteInt8(streamId, self.data);
	 else
		streamWriteBool(streamId, self.data);
	 end;
end;

function iranyvaltoEvent.sendEvent(vehicle, eventType, data)
	if g_server ~= nil then
		g_server:broadcastEvent(iranyvaltoEvent:new(vehicle, eventType, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(iranyvaltoEvent:new(vehicle, eventType, data));
	end;
end;

