--iranyvalto v1.0
--hz888


iranyvalto = {};

function iranyvalto.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function iranyvalto:load(xmlFile)

    self.upcontrolpath = Utils.getFilename("fel.png", self.baseDirectory);
    self.uparrowPoxX = 0.71;
    self.uparrowPoxY = 0.006;
    self.uparrowWidth = 0.034;
    self.uparrowHeight = 0.164;
    self.uparrowOverlay = Overlay:new("uparrowControl", self.upcontrolpath, self.uparrowPoxX, self.uparrowPoxY, self.uparrowWidth, self.uparrowHeight);

    self.downcontrolpath = Utils.getFilename("le.png", self.baseDirectory);
    self.downarrowPoxX = 0.71;
    self.downarrowPoxY = 0.006;
    self.downarrowWidth = 0.034;
    self.downarrowHeight = 0.164;
    self.downarrowOverlay = Overlay:new("downarrowControl", self.downcontrolpath, self.downarrowPoxX, self.downarrowPoxY, self.downarrowWidth, self.downarrowHeight);

    self.stopcontrolpath = Utils.getFilename("stop.png", self.baseDirectory);
    self.stoparrowPoxX = 0.71;
    self.stoparrowPoxY = 0.006;
    self.stoparrowWidth = 0.034;
    self.stoparrowHeight = 0.164;
    self.stoparrowOverlay = Overlay:new("stoparrowControl", self.stopcontrolpath, self.stoparrowPoxX, self.stoparrowPoxY, self.stoparrowWidth, self.stoparrowHeight);

    self.brakeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakeLight#index"));
    if self.brakeLight ~= nil then
	setVisibility(self.brakeLight, false);
    end;
    self.brakeLightActive = false;
    self.backLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backLight#index"));
    if self.backLight ~= nil then
	setVisibility(self.backLight, false);
    end;
    self.backLightActive = false;
    self.motorMaxRpmLimit = self.motor.maxRpm;
    self.motormaxi = math.max(self.motor.maxRpm[1], self.motor.maxRpm[2], self.motor.maxRpm[3], self.motor.maxRpm[4]);
    self.motormax = {self.motor.maxRpm[1], self.motor.maxRpm[2], self.motor.maxRpm[3], self.motor.maxRpm[4]};
    self.motormaxr = {self.motor.maxRpm[1]*2, self.motor.maxRpm[2]*1.5, self.motor.maxRpm[3], self.motor.maxRpm[4]};
    self.fGearRatios = self.motor.forwardGearRatios;
    self.bGearRatio = self.motor.backwardGearRatio;
    self.bForce = self.motor.brakeForce;
    self.level = 0;
    self.ok = true;
    self.reverse = false;
    self.gang0 = true;
    self.gang1 = false;
	self.isActor = false;
end;

function iranyvalto:delete()

    if self.uparrowOverlay~= nil then
        self.uparrowOverlay:delete();
    end;
    if self.downarrowOverlay~= nil then
        self.downarrowOverlay:delete();
    end;
    if self.stoparrowOverlay ~= nil then
        self.stoparrowOverlay:delete();
    end;

end;

function iranyvalto:mouseEvent(posX, posY, isDown, isUp, button)

	if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_LEFT) and (not self.isAITractorActivated or not self.isAIThreshing) and self.isEntered then
		if self.reverse then
			self.gang0 = true;
			self.reverse = false;
		elseif self.gang0 then
			self.gang1 = true;
			self.gang0 = false;
		end;
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_v, self.gang1);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_0, self.gang0);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_r, self.reverse);

	end;

	if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) and (not self.isAITractorActivated or not self.isAIThreshing) and self.isEntered then
		if self.gang1 then
			self.gang0 = true;
			self.gang1 = false;
		elseif self.gang0 then
			self.reverse = true;
			self.gang0 = false;
		end;
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_v, self.gang1);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_0, self.gang0);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_r, self.reverse);

	end;

end;

function iranyvalto:keyEvent(unicode, sym, modifier, isDown)
end;
function iranyvalto:readStream(streamId, connection)

	self.reverse = streamReadBool(streamId);
	self.gang0 = streamReadBool(streamId);	
	self.gang1 = streamReadBool(streamId);		
	self.input = streamReadFloat32(streamId);	
	self.movingDirection = streamReadInt8(streamId);	
end;

function iranyvalto:writeStream(streamId, connection)

	streamWriteBool(streamId, self.reverse);
	streamWriteBool(streamId, self.gang0);
	streamWriteBool(streamId, self.gang1);
	streamWriteFloat32(streamId, self.input);
	streamWriteInt8(streamId, self.movingDirection);
end;
function iranyvalto:update(dt)
	
	if self:getIsActiveForInput() then
		self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		if InputBinding.isAxisZero(self.input) then
			self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
		end;
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.input, self.input);
	end;


    if self.isAITractorActivated then
		self.motor.backwardGearRatio = self.bGearRatio;
		self.motor.forwardGearRatios = self.fGearRatios;
		if self.turnStage == 3 or self.turnStage == 4 then
			if self.turnStage == 3 then
				self.motor.brakeForce = self.bForce;
			elseif self.turnStage == 4 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
			else
				self.motor.brakeForce = 0;
			end;		
		else
			self.motor.brakeForce = 0;
		end;	
		self.maxAccelerationSpeed = self.motor.maxRpm[1]/50000;
		self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
			-- setVisibility(self.backLight, false);
			-- setVisibility(self.brakeLight, false);
		self.reverse = false;
		self.gang0 = true;
		self.gang1 = false;
    elseif self.isAIThreshing then
		self.motor.backwardGearRatio = self.bGearRatio;
		self.motor.forwardGearRatios = self.fGearRatios;
		if self.turnStage == 2 or self.turnStage == 3 then
			if self.turnStage == 2 then
				self.motor.brakeForce = self.bForce;
			elseif self.turnStage == 3 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;
			else
				self.motor.brakeForce = 0;
			end;
		else
			self.motor.brakeForce = 0;
		end;
		self.maxAccelerationSpeed = self.motor.maxRpm[1]/50000;
		self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
			-- setVisibility(self.backLight, false);
			-- setVisibility(self.brakeLight, false);
		self.reverse = false;
		self.gang0 = true;
		self.gang1 = false;
    else
    	if self.isMotorStarted and self:getIsActiveForInput() then
		if self.reverse and self.ok then
			if self.motor.speedLevel ~= 0 then
		        self.motor.maxRpm[self.motor.speedLevel] = self.motormaxr[self.motor.speedLevel];
				self.maxAccelerationSpeed = -self.motor.maxRpm[self.motor.speedLevel]/50000;
				self.motor.backwardGearRatio = self.bGearRatio;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.backwardGearRatio = 0;
			else
				self.maxAccelerationSpeed = -self.motormaxi/50000;
				self.motor.backwardGearRatio = self.bGearRatio;
			end;
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;
			if self.motor.speedLevel ~= 0 and self.movingDirection > 0 then
				self.motor.brakeForce = self.bForce;	
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce;
				self.movingDirection = 1;
				self.brakeLightActive = true;
			elseif -self.input > 0.001 and self.movingDirection > 0 then
				self.motor.brakeForce = -self.input*self.bForce;
				self.movingDirection = 1;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.forwardGearRatios = {0, 0, 0};
		elseif self.gang0 then
			if self.motor.speedLevel ~= 0 then
				self.level = self.motor.speedLevel;
				self.motor.speedLevel = 0;
				self.motor.brakeForce = self.bForce*2;
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce;
				self.movingDirection = 0;
				self.brakeLightActive = true;
			elseif -self.input > 0.001 then
				self.movingDirection = 0;
			elseif self.level ~= 0 then
				if -self.input > 0.001 or -self.input < -0.001 then
					self.level = 0;
				end;
				self.motor.brakeForce = self.bForce*2;
			else
				self.brakeLightActive = false;
				self.motor.brakeForce = self.bForce/10;
			end;
			self.maxAccelerationSpeed = 0;
			self.motor.backwardGearRatio = 0;
			self.motor.forwardGearRatios = {0, 0, 0};
		elseif self.gang1 then
			if self.level ~= 0 then
				self.motor.speedLevel = self.level;
				self.level = 0;
			end;

			if self.motor.speedLevel ~= 0 then
				if self.motor.speedLevel == 4 then
					self.ok = false;
				end;
		        self.motor.maxRpm[self.motor.speedLevel] = self.motormax[self.motor.speedLevel];
				self.maxAccelerationSpeed = self.motor.maxRpm[self.motor.speedLevel]/5000;
				self.motor.forwardGearRatios = self.fGearRatios;
			elseif -self.input < -0.001 then
				self.maxAccelerationSpeed = 0;
				self.motor.forwardGearRatios = {0, 0, 0};
			else
				self.maxAccelerationSpeed = self.motormaxi/5000;
				self.motor.forwardGearRatios = self.fGearRatios;
			end;
				
			if self.motor.speedLevel ~= 0 and self.movingDirection < 0 then
				self.motor.brakeForce = self.bForce;			
			elseif -self.input < -0.001 then
				self.motor.brakeForce = -self.input*-self.bForce*2;
				self.brakeLightActive = true;
			elseif -self.input > 0.001 and self.movingDirection < 0 then
				self.motor.brakeForce = -self.input*self.bForce;
			else
				self.motor.brakeForce = self.bForce/10;
				self.brakeLightActive = false;
			end;
			self.motor.backwardGearRatio = 0;
		end;

		if not self.ok then
			if self.movingDirection <= 0 then
				self.ok = true;
			end;
		end;
		
		-- if self.reverse then
			-- self.backLightActive = true;
		-- else
			-- self.backLightActive = false;
		-- end;

        	-- if self.brakeLight ~= nil then
            		-- if self.brakeLightActive then
            			-- setVisibility(self.brakeLight, self.brakeLightActive);
	    		-- else
            			-- setVisibility(self.brakeLight, self.brakeLightActive);
	    		-- end;
        	-- end;
        	-- if self.backLight ~= nil then
            		-- if self.backLightActive then
            			-- setVisibility(self.backLight, self.backLightActive);
	    		-- else
            			-- setVisibility(self.backLight, self.backLightActive);
	    		-- end;
        	-- end;
	end;		
    end;

    -- if self.motor.speedLevel ~= 0 or self.isAITractorActivated or self.isAIThreshing then
	-- if Input.isKeyPressed(Input.KEY_8) and self.motor.maxRpm[self.motor.speedLevel] < self.motormaxi then
		-- if self.reverse then
			-- self.motormaxr[self.motor.speedLevel] = self.motormaxr[self.motor.speedLevel] + 10;
		-- else
			-- self.motormax[self.motor.speedLevel] = self.motormax[self.motor.speedLevel] + 10;
		-- end;
	-- elseif Input.isKeyPressed(Input.KEY_7) and self.motor.maxRpm[self.motor.speedLevel] > self.motor.minRpm then
		-- if self.reverse then
			-- self.motormaxr[self.motor.speedLevel] = self.motormaxr[self.motor.speedLevel] - 10;
		-- else
			-- self.motormax[self.motor.speedLevel] = self.motormax[self.motor.speedLevel] - 10;
		-- end;
	-- end;
			
    -- end;

end;



function iranyvalto:draw()

    -- if self.isMotorStarted and self.motor.speedLevel ~= 0 then	
    	-- g_currentMission:addExtraPrintText("KEY 8(+)/7(-):   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
    -- end;

    if self.isAITractorActivated then
    	if self.turnStage == 3 then
		if self.downarrowOverlay ~= nil then
    			self.downarrowOverlay:render();
		end;
    	else
		if self.uparrowOverlay ~= nil then
    			self.uparrowOverlay:render();
		end;
    	end;
    elseif self.isAIThreshing then
    	if self.turnStage == 2 then
		if self.downarrowOverlay ~= nil then
    			self.downarrowOverlay:render();
		end;
    	else
		if self.uparrowOverlay ~= nil then
    			self.uparrowOverlay:render();
		end;
    	end;
    else
    	if self.reverse then
		if self.downarrowOverlay ~= nil then
    			self.downarrowOverlay:render();
		end;
    	elseif self.gang0 then
		if self.stoparrowOverlay ~= nil then
    			self.stoparrowOverlay:render();
		end;
    	elseif self.gang1 then
		if self.uparrowOverlay ~= nil then
    			self.uparrowOverlay:render();
		end;
    	end;

    end;

end;

function iranyvalto:onLeave()

    self.brakeLightActive = false;
    if self.brakeLight ~= nil then
    	setVisibility(self.brakeLight, self.brakeLightActive);
    end;
    self.backLightActive = false;
    if self.backLight ~= nil then
    	setVisibility(self.backLight, self.backLightActive);
    end;
	
	if self.isActor then
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_v, self.gang1);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_0, self.gang0);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.richtung_r, self.reverse);
		iranyvaltoEvent.sendEvent(self, iranyvaltoEventType.movingDirection, self.movingDirection);
		self.isActor = false;
	end;
	print("movingDirection:",self.movingDirection);
	print("gang1:",self.gang1);
	print("gang0:",self.gang0);
	print("reverse:",self.reverse);
				
end;

function iranyvalto:onEnter()
	-- store if the player is inside the vehicle - this is an important information in multiplayer games,
	-- because onEnter and onLeave are called on ALL clients, not just the one actually using the vehicle.
	self.isActor = self.isEntered;
end;