--
-- Arbeislicht_2
-- Specialization for Arbeislicht_2.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

Arbeislicht_2 = {};

function Arbeislicht_2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Arbeislicht_2:load(xmlFile)
	local numArbeislicht_2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Arbeislicht_2#count"), 0);
    self.Arbeislicht_2 = {};
    for i=1, numArbeislicht_2 do
        local worklightnamei = string.format("vehicle.Arbeislicht_2.workLight%d", i);
        self.Arbeislicht_2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.Arbeislicht_2[i], false);
    end;
	self.Arbeislicht_2Active = false;
end;

function Arbeislicht_2:delete()
	for k, worklight in pairs(self.Arbeislicht_2) do
		setVisibility(worklight, false);
	end;
	self.Arbeislicht_2Active = false;
end;

function Arbeislicht_2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Arbeislicht_2:keyEvent(unicode, sym, modifier, isDown)
end;

function Arbeislicht_2:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.ARBEISLICHT_2) then
			self.Arbeislicht_2Active = not self.Arbeislicht_2Active;
		end;
	
		for k, worklight in pairs(self.Arbeislicht_2) do
			setVisibility(worklight, self.Arbeislicht_2Active);
		end;
	end;
end;

function Arbeislicht_2:onLeave()
	for k, worklight in pairs(self.Arbeislicht_2) do
		setVisibility(worklight, false);
	end;
	self.Arbeislicht_2Active = false;
end;

function Arbeislicht_2:draw()
end;

