KuhnLSB1270 = {};

function KuhnLSB1270.prerequisitesPresent(specializations)
    return true;
end;

function KuhnLSB1270:load(xmlFile)

	self.moveBalesOut = KuhnLSB1270.moveBalesOut;
	self.setJointLimit = SpecializationUtil.callSpecializationsFunction("setJointLimit");
	self.setTransportMode = SpecializationUtil.callSpecializationsFunction("setTransportMode");
	self.allowPickingUp = KuhnLSB1270.allowPickingUp;
	self.setBaleTime = Baler.setBaleTime;
	
	self.pickupRotLimit = {0};

	local path = Utils.getFilename("Balecounter_hud.dds", self.baseDirectory);
    self.balecounterHud = Overlay:new("counterOverlay", path, 0.8143, 0.8315, 0.176, 0.06638);
	
	self.baleCount = 0;
	self.lastBaleCount = 0;
	self.moveBalesOutside = false;
	self.transportMode = true;
	self.printWait = false;
	self.allowPick = false;

end;

function KuhnLSB1270:delete()
	if self.balecounterHud ~= nil then
		self.balecounterHud:delete();
	end;
end;

function KuhnLSB1270:readStream(streamId, connection)
	self.baleCount = streamReadInt32(streamId);
end;

function KuhnLSB1270:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.baleCount);
end;

function KuhnLSB1270:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KuhnLSB1270:keyEvent(unicode, sym, modifier, isDown)
end;

function KuhnLSB1270:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'baleCount="'.. tostring(self.baleCount) ..'"';
	return attributes, nil;
end;

function KuhnLSB1270:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.baleCount = Utils.getNoNil(getXMLInt(xmlFile, key.."#baleCount"), 0);
		if self.animationParts[2].isLoading and self.animationParts[2].inputTime > self.animationParts[2].offSet then
			self:setTransportMode(false);
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function KuhnLSB1270:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.KUHN_LSB_1270_PICKUP) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.KUHN_LSB_1270_BALE) then
			self:setTransportMode(not self.transportMode);
		end;
		if InputBinding.hasEvent(InputBinding.KUHN_LSB_1270_RESET) then
			self.baleCount = 0;
		end;
	end;
	
	if not self.animationParts[2].clipEndTime then
		self.isTurnedOn = false;
	end;
	
	if self.setAnimationTime ~= nil then
		if self.isTurnedOn then
			self:setAnimationTime(3, 1);
		else
			self:setAnimationTime(3, 0);
		end;
	end;
end;

function KuhnLSB1270:setTransportMode(transportMode)
	TransportEvent.sendEvent(self, transportMode, noEventSend);
	self.transportMode = transportMode;
	if self.transportMode then
		self.isTurnedOn = false;
		self:setAnimationTime(1, self.animationParts[1].offSet);
	end;
end;

function KuhnLSB1270:updateTick(dt)

	if table.getn(self.bales) > self.lastBaleCount then
		self.baleCount = self.baleCount + 1;
		self.lastBaleCount = self.lastBaleCount + 1;
		self.balerKnotCleaningTime = (self.time-50);
	elseif table.getn(self.bales) < self.lastBaleCount then
		self.lastBaleCount = self.lastBaleCount - 1;
	end;
	
	if self.transportMode then
		if self.moveBalesOutside then
			self.printWait = false;
			self:setAnimationTime(2, self.animationParts[2].offSet);
		else
			self:moveBalesOut(dt, self);
			self.printWait = true;
		end;
	else
		self.printWait = false;
		self:setAnimationTime(2, self.animationParts[2].animDuration);
		self.moveBalesOutside = false;
	end;
	
	local newRot = Utils.getMovedLimitedValues(self.pickupRotLimit, {8}, {0}, 1, 2000, dt, not self.animationParts[1].clipEndTime);
	local jointDesc = self.componentJoints[2];
	setJointRotationLimit(jointDesc.jointIndex, 0, true, Utils.degToRad(-newRot[1]), Utils.degToRad(newRot[1]));
	self.pickupRotLimit = newRot;
	
	if self.isTurnedOn then
		if self.movingDirection == -1 then
			self.backTimer = self.backTimer+dt;
			if self.backTimer > 50 then
				self.allowPick = false;
			end;
		else
			self.allowPick = true;
			self.backTimer = 0;
		end;
	end;
end;

function KuhnLSB1270:allowPickingUp()
	local allow = false;
	if self.animationParts[1].currentPosition > 300 then
		allow = true;
	end;
	if not self.allowPick then
		allow = false;
	end;
	return allow;
end;

function KuhnLSB1270:moveBalesOut(dt, self)
	local done = true;
	local balesToDrive = 0;
	local drive = true;
	for k, bale in pairs(self.bales) do
		if bale.time > 0.4384 then
			local sendTime = math.min(1, bale.time+dt/10000);
			self.setBaleTime(self, k, sendTime, true);
			done = false;
			balesToDrive = balesToDrive+1;
		end;
	end;
	if balesToDrive == 0 and not self.moveBalesOutside then
		drive = false;
	end;
	if self.attacherVehicle ~= nil then
		local kmh = self.attacherVehicle.lastSpeed*self.attacherVehicle.speedDisplayScale*3600;
		if drive then
			if kmh < 3 then
				self.attacherVehicle.motor:setSpeedLevel(1, true);
			else
				self.attacherVehicle.motor:setSpeedLevel(0, false);
			end;
		elseif not drive and table.getn(self.bales) > 0 then
			self.attacherVehicle.motor:setSpeedLevel(0, false);
		end;
	end;
	self.moveBalesOutside = done;
	return;
end;
	
function KuhnLSB1270:draw()
	if self.animationParts[1].clipStartTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("KuhnLSB1270_1"), InputBinding.KUHN_LSB_1270_PICKUP);
	elseif self.animationParts[1].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("KuhnLSB1270_2"), InputBinding.KUHN_LSB_1270_PICKUP);
	end;
	if self.animationParts[2].clipStartTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("KuhnLSB1270_3"), InputBinding.KUHN_LSB_1270_BALE);
		g_currentMission:addExtraPrintText(g_i18n:getText("KuhnLSB1270_5"));
	elseif self.animationParts[2].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("KuhnLSB1270_4"), InputBinding.KUHN_LSB_1270_BALE);
		g_currentMission:addHelpButtonText(g_i18n:getText("KuhnLSB1270_6"), InputBinding.KUHN_LSB_1270_RESET);
		self.balecounterHud:render();
		setTextAlignment(RenderText.ALIGN_RIGHT);
		setTextBold(true);	
		setTextColor(1, 1, 1, 1);
		renderText(0.9653, 0.849, 0.032, tostring(self.baleCount));
	end;
	if self.printWait then
		g_currentMission:addWarning(g_i18n:getText("BaleWarning"), 0.040, 0.035);
	end;
	if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
		local fillType = self.currentFillType;
		if fillType == Fillable.FILLTYPE_GRASS then
			fillType = Fillable.FILLTYPE_DRYGRASS;
		end;
        local overlay = g_currentMission.fruitOverlays[FruitUtil.fillTypeToFruitType[fillType]];
        if overlay ~= nil then
            g_currentMission.fruitOverlays[FruitUtil.fillTypeToFruitType[fillType]]:render();
        end;
    end;
end;

function KuhnLSB1270:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
end;

function KuhnLSB1270:onDetach()
end;