
-- Veenhuis
--Grundscript traillingTruck @author Outlaw
--scriptumbau @Boembchen
--@date 18/01/09

veenhuis = {};

function veenhuis.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function veenhuis:load(xmlFile)
	
    
 local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;

    local rotationPartNodelade = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartlade#index"));
    if rotationPartNodelade ~= nil then
        self.rotationPartlade = {};
        self.rotationPartlade.node = rotationPartNodelade;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartlade.minRot = {};
        self.rotationPartlade.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartlade.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartlade.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartlade#maxRot"));
        self.rotationPartlade.maxRot = {};
        self.rotationPartlade.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartlade.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartlade.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartlade.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartlade#rotTime"), 2)*1000;
        self.rotationPartlade.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartlade#touchRotLimit"), 10));
    end;
    
	
    
    self.rotatelade = false;
    self.rotateRight = false;


   self.isTurnedOn = false;
    
    
    
end;

function veenhuis:delete()
    
end;


function veenhuis:mouseEvent(posX, posY, isDown, isUp, button)
    
end;



function veenhuis:keyEvent(unicode, sym, modifier, isDown)
    
    
      if isDown and sym == Input.KEY_KP_7 then
        self.rotateRight = not self.rotateRight;
      end;

       if isDown and sym == Input.KEY_KP_9 then
        self.rotatelade = not self.rotatelade;
      end;
      
	 
end;

function veenhuis:update(dt)
	Trailer.update(self, dt);
	
	 
	
		
	  if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotateRight);

		setRotation(self.rotationPartRight.node, unpack(newRot));
    end;
	
	if self.rotationPartlade ~= nil then
        local x, y, z = getRotation(self.rotationPartlade.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartlade.maxRot, self.rotationPartlade.minRot, 3, self.rotationPartlade.rotTime, dt, not self.rotatelade);

		setRotation(self.rotationPartlade.node, unpack(newRot));
    end;
	
	
end;


function veenhuis:draw()
	
end;


function veenhuis:onDetach()

end;

