--
-- Maupu
--
-- @Bayn ( www.tsforum3.com ) Thanks to Apocalypse,Face and Templaer for their advices! 
-- @date  25/06/09


Maupu = {};



function Maupu.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Maupu:load(xmlFile)

    self.toggleUnloadingState = SpecializationUtil.callSpecializationsFunction("toggleUnloadingState");
   
    self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;

    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);

    self.pipeParticleSystem = {};
    self.pipeParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeParticleSystem#index"));
    Utils.loadParticleSystem(xmlFile, self.pipeParticleSystem, "vehicle.pipeParticleSystem", self.pipeParticleSystemindex, false, nil, self.baseDirectory);

	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
  	self.charId = {};
	self.clipIndex = {};
	self.Go = {}; 
	self.Done = {};
	self.CheckDone = {};
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
    self.animParts = {}
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		

	end; 



	

-----------------------------------------------------------------------------------
------------------- Dclaration des rotation XXX --------------------------------
-----------------------------------------------------------------------------------
	
	local rotationNodePartCaisson = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCaisson#index"));
    if rotationNodePartCaisson ~= nil then
        self.rotationPartCaisson = {};
        self.rotationPartCaisson.node = rotationNodePartCaisson;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCaisson#minRot"));
        self.rotationPartCaisson.minRot = {};
        self.rotationPartCaisson.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCaisson.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCaisson.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCaisson#maxRot"));
        self.rotationPartCaisson.maxRot = {};
        self.rotationPartCaisson.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCaisson.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCaisson.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCaisson.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCaisson#rotTime"), 2)*1000;
        self.rotationPartCaisson.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCaisson#touchRotLimit"), 10));
    end;  

	local rotationNodePartPorte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPorte#index"));
    if rotationNodePartPorte ~= nil then
        self.rotationPartPorte = {};
        self.rotationPartPorte.node = rotationNodePartPorte;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPorte#minRot"));
        self.rotationPartPorte.minRot = {};
        self.rotationPartPorte.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPorte.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPorte.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPorte#maxRot"));
        self.rotationPartPorte.maxRot = {};
        self.rotationPartPorte.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPorte.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPorte.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPorte.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPorte#rotTime"), 2)*1000;
        self.rotationPartPorte.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPorte#touchRotLimit"), 10));
    end;   
	
	local rotationPartCyl1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCyl1#index"));
    if rotationPartCyl1Node ~= nil then
        self.rotationPartCyl1 = {};
        self.rotationPartCyl1.node = rotationPartCyl1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl1#minRot"));
        self.rotationPartCyl1.minRot = {};
        self.rotationPartCyl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl1#maxRot"));
        self.rotationPartCyl1.maxRot = {};
        self.rotationPartCyl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCyl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl1#rotTime"), 2)*1000;
        self.rotationPartCyl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl1#touchRotLimit"), 10));
    end;	
	
	local rotationPartCyl2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCyl2#index"));
    if rotationPartCyl2Node ~= nil then
        self.rotationPartCyl2 = {};
        self.rotationPartCyl2.node = rotationPartCyl2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl2#minRot"));
        self.rotationPartCyl2.minRot = {};
        self.rotationPartCyl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl2#maxRot"));
        self.rotationPartCyl2.maxRot = {};
        self.rotationPartCyl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCyl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl2#rotTime"), 2)*1000;
        self.rotationPartCyl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl2#touchRotLimit"), 10));
    end;	
	
	local rotationPartCyl3Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCyl3#index"));
    if rotationPartCyl3Node ~= nil then
        self.rotationPartCyl3 = {};
        self.rotationPartCyl3.node = rotationPartCyl3Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl3#minRot"));
        self.rotationPartCyl3.minRot = {};
        self.rotationPartCyl3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCyl3#maxRot"));
        self.rotationPartCyl3.maxRot = {};
        self.rotationPartCyl3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCyl3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCyl3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCyl3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl3#rotTime"), 2)*1000;
        self.rotationPartCyl3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCyl3#touchRotLimit"), 10));
    end;

	local rotationPartSupportNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSupport#index"));
    if rotationPartSupportNode ~= nil then
        self.rotationPartSupport = {};
        self.rotationPartSupport.node = rotationPartSupportNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSupport#minRot"));
        self.rotationPartSupport.minRot = {};
        self.rotationPartSupport.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSupport.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSupport.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSupport#maxRot"));
        self.rotationPartSupport.maxRot = {};
        self.rotationPartSupport.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSupport.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSupport.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSupport.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSupport#rotTime"), 2)*1000;
        self.rotationPartSupport.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSupport#touchRotLimit"), 10));
    end;
	
	
-----------------------------------------------------------------------------------
------------------- Dclaration des Translations  --------------------------------
-----------------------------------------------------------------------------------



	local translationNodeCyl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCyl2#index"));
    if translationNodeCyl2 ~= nil then
        self.translationCyl2 = {};
        self.translationCyl2.node = translationNodeCyl2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl2#minTrans"));
        self.translationCyl2.minTrans = {};
        self.translationCyl2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl2#maxTrans"));
        self.translationCyl2.maxTrans = {};
        self.translationCyl2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCyl2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl2#transTime"), 2)*1000;
        self.translationCyl2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl2#touchTransLimit"), 10);
    end; 	
	
	local translationNodeCyl3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCyl3#index"));
    if translationNodeCyl3 ~= nil then
        self.translationCyl3 = {};
        self.translationCyl3.node = translationNodeCyl3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl3#minTrans"));
        self.translationCyl3.minTrans = {};
        self.translationCyl3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl3#maxTrans"));
        self.translationCyl3.maxTrans = {};
        self.translationCyl3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCyl3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl3#transTime"), 2)*1000;
        self.translationCyl3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl3#touchTransLimit"), 10);
    end; 

	local translationNodeCyl4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCyl4#index"));
    if translationNodeCyl4 ~= nil then
        self.translationCyl4 = {};
        self.translationCyl4.node = translationNodeCyl4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl4#minTrans"));
        self.translationCyl4.minTrans = {};
        self.translationCyl4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl4#maxTrans"));
        self.translationCyl4.maxTrans = {};
        self.translationCyl4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCyl4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl4#transTime"), 2)*1000;
        self.translationCyl4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl4#touchTransLimit"), 10);
    end; 
	
	local translationNodeCyl5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCyl5#index"));
    if translationNodeCyl5 ~= nil then
        self.translationCyl5 = {};
        self.translationCyl5.node = translationNodeCyl5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl5#minTrans"));
        self.translationCyl5.minTrans = {};
        self.translationCyl5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl5#maxTrans"));
        self.translationCyl5.maxTrans = {};
        self.translationCyl5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCyl5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl5#transTime"), 2)*1000;
        self.translationCyl5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl5#touchTransLimit"), 10);
    end; 

	local translationNodeCyl6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCyl6#index"));
    if translationNodeCyl6 ~= nil then
        self.translationCyl6 = {};
        self.translationCyl6.node = translationNodeCyl6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl6#minTrans"));
        self.translationCyl6.minTrans = {};
        self.translationCyl6.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl6.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl6.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl6#maxTrans"));
        self.translationCyl6.maxTrans = {};
        self.translationCyl6.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl6.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl6.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCyl6.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl6#transTime"), 2)*1000;
        self.translationCyl6.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl6#touchTransLimit"), 10);
    end; 

	local translationNodeCyl7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCyl7#index"));
    if translationNodeCyl7 ~= nil then
        self.translationCyl7 = {};
        self.translationCyl7.node = translationNodeCyl7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl7#minTrans"));
        self.translationCyl7.minTrans = {};
        self.translationCyl7.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl7.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl7.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCyl7#maxTrans"));
        self.translationCyl7.maxTrans = {};
        self.translationCyl7.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCyl7.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCyl7.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCyl7.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl7#transTime"), 2)*1000;
        self.translationCyl7.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCyl7#touchTransLimit"), 10);
    end; 

	local translationNodeSupport = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationSupport#index"));
    if translationNodeSupport ~= nil then
        self.translationSupport = {};
        self.translationSupport.node = translationNodeSupport;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationSupport#minTrans"));
        self.translationSupport.minTrans = {};
        self.translationSupport.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationSupport.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationSupport.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationSupport#maxTrans"));
        self.translationSupport.maxTrans = {};
        self.translationSupport.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationSupport.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationSupport.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationSupport.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationSupport#transTime"), 2)*1000;
        self.translationSupport.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationSupport#touchTransLimit"), 10);
    end; 

	------------------------------------------
------ Dfinition des touches ------------
------------------------------------------


	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	
	



	self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
	
	self.grainUnloading = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainUnloading"), 10);
	
	self.allowDoorOpen = true;
	self.lower = false;
	 
	self.isExpanded = false;
	self.pipeParticleActivated = false;
	self.isActive = true;

	
	self.sowingMachineFound = 0;
	
end;

function Maupu:delete()

end;

function Maupu:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Maupu:keyEvent(unicode, sym, modifier, isDown)
    if self.isActive then
		if isDown and sym == self.keys.trappe then
			self.Go.trappe = not self.Go.trappe; 
			self.Done.trappe = true; 

		end;
		
		if sym == self.keys.caissonUP then 
			self.rotationPartCaissonMax = isDown;
			self.rotationPartCyl1Max = isDown;
			self.translationMaxCyl2 = isDown;
			self.translationMaxCyl3 = isDown;
			self.translationMaxCyl4 = isDown;
			self.translationMaxCyl5 = isDown;
			self.translationMaxCyl6 = isDown;
		end;

		if sym == self.keys.caissonDOWN then
			self.rotationPartCaissonMin = isDown;
			self.rotationPartCyl1Min = isDown;
			self.translationMinCyl2 = isDown;
			self.translationMinCyl3 = isDown;
			self.translationMinCyl4 = isDown;
			self.translationMinCyl5 = isDown;
			self.translationMinCyl6 = isDown;
		end;
		
		if sym == self.keys.porteUP and self.allowDoorOpen then 
			self.rotationPartPorteMax = isDown;
			self.rotationPartCyl2Max = isDown;
			self.translationMaxCyl7 = isDown;
		end;

		if sym == self.keys.porteDOWN then 
			self.rotationPartPorteMin = isDown;
			self.rotationPartCyl2Min = isDown;
			self.translationMinCyl7 = isDown;
		end;
	end; 
end;

function Maupu:update(dt)
		
	
-----------------------------------------------------------------------------------
------------------- Fonctionnement de la rotation ---------------------------------
-----------------------------------------------------------------------------------
		
    local doRotate = self.rotationPartCaissonMax or self.rotationPartCaissonMin 
	if self.rotationPartCaisson ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartCaisson.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartCaisson.maxRot, self.rotationPartCaisson.minRot, 3, self.rotationPartCaisson.rotTime, dt, not self.rotationPartCaissonMax);
        setRotation(self.rotationPartCaisson.node, unpack(newRot));
    end;    

	local doRotate = self.rotationPartPorteMax or self.rotationPartPorteMin 
	if self.rotationPartPorte ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartPorte.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPorte.maxRot, self.rotationPartPorte.minRot, 3, self.rotationPartPorte.rotTime, dt, not self.rotationPartPorteMax);
        setRotation(self.rotationPartPorte.node, unpack(newRot));
    end;  

	local doRotate = self.rotationPartCyl1Max or self.rotationPartCyl1Min 
	if self.rotationPartCyl1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartCyl1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartCyl1.maxRot, self.rotationPartCyl1.minRot, 3, self.rotationPartCyl1.rotTime, dt, not self.rotationPartCyl1Max);
        setRotation(self.rotationPartCyl1.node, unpack(newRot));
    end;	
	
	local doRotate = self.rotationPartCyl2Max or self.rotationPartCyl2Min 
	if self.rotationPartCyl2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartCyl2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartCyl2.maxRot, self.rotationPartCyl2.minRot, 3, self.rotationPartCyl2.rotTime, dt, not self.rotationPartCyl2Max);
        setRotation(self.rotationPartCyl2.node, unpack(newRot));
    end;

	local doRotate = self.rotationPartCyl3Max or self.rotationPartCyl3Min 
	if self.rotationPartCyl3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartCyl3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartCyl3.maxRot, self.rotationPartCyl3.minRot, 3, self.rotationPartCyl3.rotTime, dt, not self.rotationPartCyl3Max);
        setRotation(self.rotationPartCyl3.node, unpack(newRot));
    end;	
	
	local doRotate = self.rotationPartSupportMax or self.rotationPartSupportMin 
	if self.rotationPartSupport ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPartSupport.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSupport.maxRot, self.rotationPartSupport.minRot, 3, self.rotationPartSupport.rotTime, dt, not self.rotationPartSupportMax);
        setRotation(self.rotationPartSupport.node, unpack(newRot));
    end;


	
-----------------------------------------------------------------------------------
------------------- Fonctionnement de la translation ------------------------------
-----------------------------------------------------------------------------------		
	local doTranslate = self.translationMaxCyl2 or self.translationMinCyl2 
	if self.translationCyl2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationCyl2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationCyl2.maxTrans, self.translationCyl2.minTrans, 3, self.translationCyl2.transTime, dt, not self.translationMaxCyl2); 
		setTranslation(self.translationCyl2.node, unpack(newTrans)); 
	end;	

	local doTranslate = self.translationMaxCyl3 or self.translationMinCyl3 
	if self.translationCyl3 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationCyl3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationCyl3.maxTrans, self.translationCyl3.minTrans, 3, self.translationCyl3.transTime, dt, not self.translationMaxCyl3); 
		setTranslation(self.translationCyl3.node, unpack(newTrans)); 
	end;

	local doTranslate = self.translationMaxCyl4 or self.translationMinCyl4 
	if self.translationCyl4 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationCyl4.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationCyl4.maxTrans, self.translationCyl4.minTrans, 3, self.translationCyl4.transTime, dt, not self.translationMaxCyl4); 
		setTranslation(self.translationCyl4.node, unpack(newTrans)); 
	end;	

	local doTranslate = self.translationMaxCyl5 or self.translationMinCyl5 
	if self.translationCyl5 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationCyl5.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationCyl5.maxTrans, self.translationCyl5.minTrans, 3, self.translationCyl5.transTime, dt, not self.translationMaxCyl5); 
		setTranslation(self.translationCyl5.node, unpack(newTrans)); 
	end;

	local doTranslate = self.translationMaxCyl6 or self.translationMinCyl6 
	if self.translationCyl6 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationCyl6.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationCyl6.maxTrans, self.translationCyl6.minTrans, 3, self.translationCyl6.transTime, dt, not self.translationMaxCyl6); 
		setTranslation(self.translationCyl6.node, unpack(newTrans)); 
	end;	
	
	local doTranslate = self.translationMaxCyl7 or self.translationMinCyl7 
	if self.translationCyl7 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationCyl7.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationCyl7.maxTrans, self.translationCyl7.minTrans, 3, self.translationCyl7.transTime, dt, not self.translationMaxCyl7); 
		setTranslation(self.translationCyl7.node, unpack(newTrans)); 
	end;

	local doTranslate = self.translationMaxSupport or self.translationMinSupport 
	if self.translationSupport ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationSupport.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationSupport.maxTrans, self.translationSupport.minTrans, 3, self.translationSupport.transTime, dt, not self.translationMaxSupport); 
		setTranslation(self.translationSupport.node, unpack(newTrans)); 
	end;
	

	if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		self.isActive = false;
	elseif self.tipState == Trailer.TIPSTATE_CLOSING or g_currentMission.trailerInTipRange ~= nil then
		self.isActive = false;
	else
		self.isActive = true;
	end;
	
	if self.fillLevel > 0 or g_currentMission.trailerInTipRange ~= nil then
	    self.allowDoorOpen = false;
		self.rotationPartPorteMin = true;
		self.rotationPartCyl2Min = true;
		self.translationMinCyl7  = true;
	end;
		
	if g_currentMission.trailerInTipRange ~= nil then
		self.rotationPartCaissonMin = true;
		self.rotationPartCyl1Min = true;
		self.translationMinCyl2 = true;
		self.translationMinCyl3 = true;
		self.translationMinCyl4 = true;
		self.translationMinCyl5 = true;
		self.translationMinCyl6 = true;
		self.Done.trappe = true;
		self.Go.trappe = false;
		self.lower = true;
	end;
	
	if self.lower and g_currentMission.trailerInTipRange == nil then
	    if self.fillLevel == 0 then
			self.allowDoorOpen = true;
			self.rotationPartPorteMin = false;
			self.rotationPartCyl2Min = false;
			self.translationMinCyl7 = false;
        end;
		
		self.rotationPartCaissonMin = false;
		self.rotationPartCyl1Min = false;
		self.translationMinCyl2 = false;
		self.translationMinCyl3 = false;
		self.translationMinCyl4 = false;
		self.translationMinCyl5 = false;
		self.translationMinCyl6 = false;
		self.lower = false;
	end;
	
	if self.Go.trappe ~= nil and self.Done.trappe then
		self:anim("trappe", false); 
	end; 
	
	self.pipeParticleActivated = false;
	self.trailerFound = 0;
	self.sowingMachineFound = 0;
    if self.fillLevel > 0 and self.attacherVehicle ~= nil then
	
        self.pipeParticleActivated = true;
		self.Go.trappe = true; 
		self.Done.trappe = true; 
        self.trailerFound = 0;
        local x,y,z = getWorldTranslation(self.trailerPosition);
        raycastAll(x, y, z, 4, -6, -6, "findTrailerRaycastCallback", 10, self);
       
		
        local trailer = g_currentMission.objectToTrailer[self.trailerFound];
		local sowingMachine = nil;
		
		if self.sowingMachineFound ~= 0 then	
			local implements = g_currentMission.attachables;
			for i=0, table.getn(implements) do
				if implements[i] ~= nil then
					if implements[i].rootNode == self.sowingMachineFound then
						sowingMachine = implements[i];
					end;
				end;			
			end;
		end;		
		
        if (self.trailerFound == 0 or not trailer:allowFillType(self.currentFillType)) and (self.sowingMachineFound == 0 or not sowingMachine:allowFillType(sowingMachine.FILLTYPE_WHEAT)) then
            self.pipeParticleActivated = false;
			self.Go.trappe = false;
        else

	            local deltaLevel = self.grainUnloading;
				if sowingMachine ~= nil then
					deltaLevel = math.min(deltaLevel, sowingMachine.capacity - sowingMachine.fillLevel);
				elseif trailer ~= nil then
					deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
				else
					deltaLevel = 0;
				end;

	            self.fillLevel = self.fillLevel-deltaLevel;
	            if self.fillLevel <= 0.0 then
	                deltaLevel = deltaLevel+self.fillLevel;
	                self.fillLevel = 0.0;
	                pipeParticleActivated = false;
	            end;
	            if deltaLevel == 0 then
	                self.pipeParticleActivated = false;
	            end;
	            self:setFillLevel(self.fillLevel, self.currentFillType);
				if sowingMachine ~= nil then
					sowingMachine:setFillLevel(sowingMachine.fillLevel+deltaLevel, sowingMachine.FILLTYPE_WHEAT);
				elseif trailer ~= nil then
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
				end;

        end;
	
    end;

		if self.pipeParticleActivated then

		Utils.setEmittingState(self.pipeParticleSystem, true);
		else
		Utils.setEmittingState(self.pipeParticleSystem, false);
		end;

end;

function Maupu:draw()
	if self.attacherVehicle ~= nil then
			g_currentMission:addExtraPrintText(g_i18n:getText("caisson"))
			g_currentMission:addExtraPrintText(g_i18n:getText("porte"))
			g_currentMission:addExtraPrintText(g_i18n:getText("trappe"))
	end;
end;

function Maupu:onDetach()
		self.rotationPartSupportMin = true;
		self.rotationPartSupportMax = false;
	if self.rotationPartSupportMin then
		self.translationMaxSupport = true;
		self.translationMinSupport = false;
	end;
end;

function Maupu:onAttach()
		self.rotationPartSupportMin = false;
		self.rotationPartSupportMax = true;
	if self.rotationPartSupportMax then
		self.translationMinSupport = true;
		self.translationMaxSupport = false;
	end;
end;

function Maupu:setFillLevel(fillLevel, fillType)
	Trailer.setFillLevel(self, fillLevel, fillType);
end;

function Maupu:findTrailerRaycastCallback(transformId, x, y, z, distance)
    self.trailerFound = 0;
	self.sowingMachineFound = 0;
    if getUserAttribute(transformId, "vehicleType") == 2 then
        self.trailerFound = transformId;
    end;
	
	if getUserAttribute(transformId, "sowingMachine") then
		self.sowingMachineFound = transformId;
	end;
	
    return false;
end;


function Maupu:anim(varName, loopCheck)

	
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 


function Maupu:toggleTipState()
end;

