
rotatingParts = {};

function rotatingParts.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function rotatingParts:load(xmlFile)
    self.rotatingParts = {};
    local rotatingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotatingParts#count"), 0);	
	for i=1, rotatingPartsCount do
		local namei = string.format("vehicle.rotatingParts.rotatingPart%d", i);
		local rotatingPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		
		self.rotatingParts[i] = {};
		self.rotatingParts[i].node = rotatingPart;
		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.rotatingParts[i].minRot = {};
        self.rotatingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.rotatingParts[i].maxRot = {};
        self.rotatingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotatingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
	end;
	
	self.isLeftDoorOpen = false;
	self.isRightDoorOpen = false;
	self.isRearWindowOpen = false;
	self.isFrontWindowOpen = false;
end;

function rotatingParts:delete()
end;

function rotatingParts:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rotatingParts:keyEvent(unicode, sym, modifier, isDown)
end;

function rotatingParts:update(dt)	
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.LEFTDOOR) then
			self.isLeftDoorOpen = not self.isLeftDoorOpen;
		end;
		
		if InputBinding.hasEvent(InputBinding.RIGHTDOOR) then	
			self.isRightDoorOpen = not self.isRightDoorOpen;
		end;
		
		if InputBinding.hasEvent(InputBinding.REARWINDOW) then	
			self.isRearWindowOpen = not self.isRearWindowOpen;
		end;
		
		if InputBinding.hasEvent(InputBinding.FRONTWINDOW) then	
			self.isFrontWindowOpen = not self.isFrontWindowOpen;
		end;
		
		
		-- Rotate Left Door
		if self.rotatingParts[1] ~= nil then
			local x, y, z = getRotation(self.rotatingParts[1].node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[1].maxRot, self.rotatingParts[1].minRot, 3, self.rotatingParts[1].rotTime, dt, not self.isLeftDoorOpen);
			setRotation(self.rotatingParts[1].node, unpack(newRot));
		end;   

		-- Rotate Right Door
		if self.rotatingParts[2] ~= nil then
			local x, y, z = getRotation(self.rotatingParts[2].node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[2].maxRot, self.rotatingParts[2].minRot, 3, self.rotatingParts[2].rotTime, dt, not self.isRightDoorOpen);
			setRotation(self.rotatingParts[2].node, unpack(newRot));
		end;
		
		-- Rotate Rear Window
		if self.rotatingParts[3] ~= nil then
			local x, y, z = getRotation(self.rotatingParts[3].node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[3].maxRot, self.rotatingParts[3].minRot, 3, self.rotatingParts[3].rotTime, dt, not self.isRearWindowOpen);
			setRotation(self.rotatingParts[3].node, unpack(newRot));
		end;
		
		-- Rotate Front Window
		if self.rotatingParts[4] ~= nil then
			local x, y, z = getRotation(self.rotatingParts[4].node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[4].maxRot, self.rotatingParts[4].minRot, 3, self.rotatingParts[4].rotTime, dt, not self.isFrontWindowOpen);
			setRotation(self.rotatingParts[4].node, unpack(newRot));
		end;
	end;
end;

function rotatingParts:draw()
end;
