--
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ClaasShowHelp = {};

function ClaasShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ClaasShowHelp:load(xmlFile)
	self.ClaasShowHelp = false;
end;

function ClaasShowHelp:delete()
end;

function ClaasShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ClaasShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ClaasShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.ClaasShowHelp = not self.ClaasShowHelp;
		end;
	end;
end;



function ClaasShowHelp:updateTick(dt)
end;


function ClaasShowHelp:draw()
	if not self.ClaasShowHelp then
		renderText(0.80, 0.25, 0.02, " Numpad 0: Axion 850 Info");
	 else
		renderText(0.80, 0.25, 0.02, "Numpad 0: Axion 850 Info");
		renderText(0.72, 0.68, 0.025, "- CLAAS AXION 850 -");			
		renderText(0.72, 0.65, 0.02, "Key Home: Beacon Lights ");
		renderText(0.72, 0.63, 0.02, "Key KP 1: Left Blinker ");
		renderText(0.72, 0.61, 0.02, "Key KP 2: Warn Blinker");
		renderText(0.72, 0.59, 0.02, "Key KP 3: Right Blinker");
		renderText(0.72, 0.57, 0.02, "Key F:    Drive Lights");
		renderText(0.72, 0.55, 0.02, "Key KP 5: Working lights front");
		renderText(0.72, 0.53, 0.02, "Key KP 6: Working lights rear");			
		renderText(0.72, 0.51, 0.02, "Key KP 7: Left Door");
		renderText(0.72, 0.49, 0.02, "Key KP 8: Back Window");
		renderText(0.72, 0.47, 0.02, "Key KP 9: Right Door");
		renderText(0.72, 0.43, 0.02, "Key 8: Extra Tires");
		renderText(0.72, 0.41, 0.02, "Key Page_Up: ESL Limiter");
		renderText(0.72, 0.39, 0.02, "Key Page_Down: ESL Limiter");
		renderText(0.72, 0.31, 0.02, "Key 0: Horn");
        renderText(0.72, 0.28, 0.025, "- CLAAS AXION 850 -");
	end;
end;

function ClaasShowHelp:onLeave()
	self.ClaasShowHelp = false;
end;




