--
-- LightFunctions.lua
-- Specialization for Lights, Breaklights, Turnlights.
--
-- @author Ellinor Strm
-- @date 28/11/2010
--
-- This work is licensed under a
-- Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
-- http://creativecommons.org/licenses/by-nc-sa/3.0/
-- 
LightFunctionsEvent = {};
LightFunctionsEvent_mt = Class(LightFunctionsEvent, Event);

InitEventClass(LightFunctionsEvent, "LightFunctionsEvent");

LightFunctionsEventType = {
	breaking = 1,
	reversing = 2,
	turnsignal = 3
}

function LightFunctionsEvent:emptyNew()
    local self = Event:new(LightFunctionsEvent_mt);
    self.className="LightFunctionsEvent";
    return self;
end;

function LightFunctionsEvent:new(object, eventType, data)
   	local self = LightFunctionsEvent:emptyNew()
  
      	self.object = object;
	self.eventType = eventType;
	self.data = data;

    	return self;
end;

function LightFunctionsEvent:readStream(streamId, connection)
    	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	
	self.eventType = streamReadUInt8(streamId);
	if self.eventType == LightFunctionsEventType.breaking then
		self.data = streamReadBool(streamId);
		self.object.breaking = self.data;
	elseif self.eventType == LightFunctionsEventType.reversing then
		self.data = streamReadBool(streamId);
		self.object.reversing = self.data;
	elseif self.eventType == LightFunctionsEventType.turnsignal then
		self.data = streamReadInt8(streamId);
		self.object.turnSel = self.data;
	end;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(LightFunctionsEvent:new(self.object, self.eventType, self.data), nil, connection, self.object);
    end;
end;

function LightFunctionsEvent:writeStream(streamId, connection)
    	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUInt8(streamId, self.eventType);

	if self.eventType == LightFunctionsEventType.breaking then
		streamWriteBool(streamId, self.data);
	elseif self.eventType == LightFunctionsEventType.reversing then
		streamWriteBool(streamId, self.data);
	elseif self.eventType == LightFunctionsEventType.turnsignal then
		streamWriteInt8(streamId, self.data);
	end;
end;

function LightFunctionsEvent.sendEvent(vehicle, eventType, data)
	if g_server ~= nil then
		g_server:broadcastEvent(LightFunctionsEvent:new(vehicle, eventType, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(LightFunctionsEvent:new(vehicle, eventType, data));
	end;
end;