JLichterscriptEvent = {};
JLichterscriptEvent_mt = Class(JLichterscriptEvent, Event);

InitEventClass(JLichterscriptEvent, "JLichterscriptEvent");

JLichterscriptEventType = {
	rundumleuchte = 1,
	worklight = 2,
	worklight2 = 3,
}

function Event:emptyNew()
    local self = Event:new(JLichterscriptEvent_mt);
    self.className="JLichterscriptEvent";
    return self;
end;

function JLichterscriptEvent:new(object, eventType, data)
    local self = JLichterscriptEvent:emptyNew()
    self.object = object;
	self.eventType = eventType;
	self.data = data;
    return self;
end;

function JLichterscriptEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	
	self.eventType = streamReadUInt8(streamId);
	if self.eventType == JLichterscriptEventType.rundumleuchte then
		self.data = streamReadBool(streamId);
		self.object:setRundumleuchte(self.data, true);
	elseif self.eventType == JLichterscriptEventType.worklight then
		self.data = streamReadBool(streamId);
		self.object:setWorklightActive(self.data, true);
	elseif self.eventType == JLichterscriptEventType.worklight2 then
		self.data = streamReadBool(streamId);
		self.object.worklight2 = self.data;
	end;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(JLichterscriptEvent:new(self.object, self.eventType, self.data), nil, connection, self.object);
    end;
end;

function JLichterscriptEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUInt8(streamId, self.eventType);
	if self.eventType == JLichterscriptEventType.maxRpm then
		streamWriteInt32(streamId, self.data);
	elseif self.eventType >= JLichterscriptEventType.threshed then
		streamWriteFloat32(streamId, self.data);
	else
		streamWriteBool(streamId, self.data);
	end;
end;

function JLichterscriptEvent.sendEvent(vehicle, eventType, data)
	if g_server ~= nil then
		g_server:broadcastEvent(JLichterscriptEvent:new(vehicle, eventType, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(JLichterscriptEvent:new(vehicle, eventType, data));
	end;
end;

