--
-- JLichterscript
-- This is the specialization for JLichterscript
--
-- M@D Author  Headshot XXL
-- M@D date 17.07.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

JLichterscript = {};

function JLichterscript.prerequisitesPresent(specializations)
    return true;
end;

function JLichterscript:load(xmlFile)

	self.workLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLights#index"));
	self.workLight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLights#index2"));
	self.workLightVis = false;
	self.workLight2Vis = false;

	local i = 0;
	self.rundumleuchten = {};
    self.rundumleuchtenAn = false;
	while true do
		local rul = {};
		local objname = string.format("vehicle.rundumleuchten.rundumleuchte(%d)",i);
		local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
    if rotnode == nil then 
      	break;
    end;
    rul = {};
    rul.rotNode = Utils.indexToObject(self.components, rotnode);
    rul.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
    if(rul.rotNode == nil or rul.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
    else
	    rul.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	    rul.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	    if (rul.source == nil) then
	    	rul.emit = false;
	    else
      		rul.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul.emit then
      			setVisibility(rul.source, false);
      		end;
      	end;
      	table.insert(self.rundumleuchten, rul);
    end;
    i=i+1;
    end;
    self.rundumleuchtenAnz = table.getn(self.rundumleuchten);	
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	
end;

function JLichterscript:delete()
end;

function JLichterscript:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JLichterscript:keyEvent(unicode, sym, modifier, isDown)
end;

function JLichterscript:update(dt)

	if self.isEntered then
		if self.workLight ~= nil then
			if InputBinding.hasEvent(InputBinding.Jaguar900WORKLIGHT) then
				self.workLightVis = not self.workLightVis;
			end;
		end;
		if self.workLight2 ~= nil then
			if InputBinding.hasEvent(InputBinding.Jaguar900WORKLIGHT2) then
				self.workLight2Vis = not self.workLight2Vis;
			end;
		end;
	end;
	
	if self.workLight ~= nil then
		setVisibility(self.workLight, self.workLightVis);
	end;
	if self.workLight2 ~= nil then
		setVisibility(self.workLight2, self.workLight2Vis);
	end;
		
	if self.rundumleuchtenAnz > 0 and self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.Jaguar900RUNDUMLEUCHTE) then
			self.rundumleuchtenAn = not self.rundumleuchtenAn;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
		if self.rundumleuchtenAn then
			for i=1, self.rundumleuchtenAnz do
				rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
			end;
		end;
	end;

end;

function JLichterscript:onEnter()

	self.isActor = self.isEntered;
end;

function JLichterscript:onLeave()

	self.isActor = false;
end;

function JLichterscript:draw()
		if self.isEntered then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jaguar900WORKLIGHT"), self.typeDesc), InputBinding.Jaguar900WORKLIGHT);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jaguar900WORKLIGHT2"), self.typeDesc), InputBinding.Jaguar900WORKLIGHT2);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jaguar900RUNDUMLEUCHTE"), self.typeDesc), InputBinding.Jaguar900RUNDUMLEUCHTE);
		end;
end;

function JLichterscript:setworklightActive(state, noSendEvent)
	self.worklightActive = state;
	for k, worklight in pairs(self.worklight) do
		setVisibility(worklight, self.worklightActive);
	end;
	if noSendEvent ~= true then
		JLichterscriptEvent.sendEvent(self, JLichterscriptEventType.worklight, self.worklightActive);
	end;
end;

function JLichterscript:setworklight2Active(state, noSendEvent)
	self.worklight2Active = state;
	for k, worklight2 in pairs(self.worklight2) do
		setVisibility(worklight2, self.worklight2Active);
	end;
	if noSendEvent ~= true then
		JLichterscriptEvent.sendEvent(self, JLichterscriptEventType.worklight2, self.worklight2Active);
	end;
end;

function JLichterscript:setRundumleuchte(state, noSendEvent)
	self.rundumleuchtenAn = state;
	for i=1, self.rundumleuchtenAnz do
		setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
	end;
	if noSendEvent ~= true then
		JLichterscriptEvent.sendEvent(self, JLichterscriptEventType.rundumleuchte, self.rundumleuchtenAn);
	end;
end;