Z930 = {};

function Z930.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function Z930:load(xmlFile)
	self.customAttacher = {};
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#minRot"));
	self.customAttacher.minRot = {};
	self.customAttacher.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#maxRot"));
	self.customAttacher.maxRot = {};
	self.customAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	self.attacherBackup = {};
	
	self.extraRollNodes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.extraRolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#speed"));
        if rollNode ~= nil then
			local speed = {};
			speed.x = Utils.getNoNil(x, 0);
			speed.y = Utils.getNoNil(y, 0);
			speed.z = Utils.getNoNil(z, 0);
            table.insert(self.extraRollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;

	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
end;

function Z930:delete()
end;

function Z930:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z930:keyEvent(unicode, sym, modifier, isDown)
end;

function Z930:update(dt)
	if self.reelStarted then
		for _, rollNode in pairs(self.extraRollNodes) do
			rotate(rollNode.node, -dt*rollNode.speed.x, -dt*rollNode.speed.y, -dt*rollNode.speed.z);
		end;
	end;
end;

function Z930:updateTick(dt)
end;

function Z930:draw()
end;

function Z930:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, jointDesc in pairs(attacherVehicle.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			self.attacherBackup.minRot = jointDesc.minRot;
			self.attacherBackup.maxRot = jointDesc.maxRot;
			jointDesc.minRot = self.customAttacher.minRot;
			jointDesc.maxRot = self.customAttacher.maxRot;
		end;
	end;
end;

function Z930:onDetach()
	for k, jointDesc in pairs(self.av.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			jointDesc.minRot = self.attacherBackup.minRot;
			jointDesc.maxRot = self.attacherBackup.maxRot;
		end;
	end;
end;

function Z930:onLeave()
end;

function Z930:onDeactivate()
end;