-- CamSpecV2 Specialization
-- Rotates the indoorcam front/back if you press a key
-- translate the indorrcam forward / backward if you press a key
--
-- by modelleicher  @date 12.12.10
-- www.schwabenmodding.bplaced.net
-- 
-- @date 14.1.10 V2 addet translation forwards / backwards 

CamSpecV2 = {};

function CamSpecV2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function CamSpecV2:load(xmlFile)
    self.transCam = CamSpecV2.transCam  
    self.rotateCam = CamSpecV2.rotateCam
	self.camSpecHasRot = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.CameraRotation#hasRotBool"));  
	self.camSpecHasTrans = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.CameraRotation#hasTransBool"));
	
	self.camRotTrans = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CameraRotation#rotationTransformIndex"));	
	self.camTrTrans = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.CameraRotation#translationTransformIndex"));	
	
	-- indoorcamera is <camera2 (...)/> in xml. If it's <camera1 (...)/> in xml then there write 1, or if it's <camera3 (...)/> in xml write 3 and so on.. 
	self.camInTableIndex = 2  
	
	self.camFrontTrans = 0.5
	self.camBackTrans = 0
	self.camCurTrans = 0
end;

function CamSpecV2:delete()
end;

function CamSpecV2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CamSpecV2:keyEvent(unicode, sym, modifier, isDown)   
end;

function CamSpecV2:update(dt)
   if self:getIsActiveForInput() then

    if self.camIndex == self.camInTableIndex then
	    if self.camSpecHasRot == true then
        if InputBinding.hasEvent(InputBinding.Rot_Front) then
	       self:rotateCam(0, 0, 0)
        end;
	    if InputBinding.hasEvent(InputBinding.Rot_Back) then
	       self:rotateCam(0, 180, 0)
		end;
		end;
		if self.camSpecHasTrans == true then
	    if InputBinding.isPressed(InputBinding.TransForward) then
			if self.camCurTrans < self.camFrontTrans then
				self.camCurTrans = self.camCurTrans + 0.008
			end;
		end;
	    if InputBinding.isPressed(InputBinding.TransBackward) then
			if self.camCurTrans > self.camBackTrans then
				self.camCurTrans = self.camCurTrans - 0.008
			end;
		end;
        setTranslation(self.camTrTrans, 0, 0, self.camCurTrans);		
		end;
	end;
   end;	
end;

--[[function CamSpecV2:transCam(direction)
	if direction == "forward" then
       if self.camCurTrans < self.camFrontTrans then
	      self.camCurTrans = self.camCurTrans + 0.01
	   end;
	elseif direction == "backward" then
       if self.camCurTrans > self.camBackTrans then
	      self.camCurTrans = self.camCurTrans - 0.01
	   end;
	end;
end;--]]

function CamSpecV2:rotateCam(x, y, z)
	local rx = Utils.degToRad(x);
	local ry = Utils.degToRad(y);
	local rz = Utils.degToRad(z);
	setRotation(self.camRotTrans, rx, ry, rz);
end;

function CamSpecV2:draw()
end;

function CamSpecV2:onLeave()
    if self.camSpecHasTrans == true then
	   setTranslation(self.camRotTrans, 0, 0, 0);
	end;
    if self.camSpecHasRot == true then
	self:rotateCam(0, 0, 0)
	end;
end;



