--
-- rpmLimiter
-- Specialization for a rpm limiter
--
-- @author  Templaer
-- @date  01/05/09
--

rpmLimiter = {};

function rpmLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function rpmLimiter:load(xmlFile)
	local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;
	self.translationMax2 = false;
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
end;

function rpmLimiter:delete()
end;

function rpmLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rpmLimiter:keyEvent(unicode, sym, modifier, isDown)
	if InputBinding.isPressed(InputBinding.Hvor) then
		self.translationMax3 = isDown;
	end;
	if InputBinding.isPressed(InputBinding.Hzurueck) then
		self.translationMin3 = isDown;
	end;	
	if sym == Input.KEY_KP_4 then
		self.translationMax3 = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationMin3 = isDown;
	end;

end;

function rpmLimiter:update(dt)

		local doTranslate = self.translationMax or self.translationMin
		if self.translationPart ~= nil and doTranslate then
			--translate = button { }  = isDown
			local x, y, z = getTranslation(self.translationPart.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
			setTranslation(self.translationPart.node, unpack(newTrans));
		end;
		if self.translationPart3 ~= nil and doTranslate then
			--translate = button { }  = isDown
			local x, y, z = getTranslation(self.translationPart3.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
			setTranslation(self.translationPart3.node, unpack(newTrans));
		end;

    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
			
	    end;
		
	end;
end;

function rpmLimiter:draw()
    if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Taste NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Taste NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
end;

