--
-- Fortschritt
-- Specialization for New Holland CR 9090 Elevation mod
--
-- @author  wohlstandskind
-- @date  20/12/09
-- @beacon-lights by Sven777b
-- @last edit 26/12/09 by yekk1

Fortschritt = {};

function Fortschritt.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fortschritt:load(xmlFile)
    hornSoundFile = Utils.getFilename("superHorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("LizardHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;

self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;
		--[[Blinker start]]------------------------------------------------------------	
	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
--[[Blinker ende]]------------------------------------------------------------	

local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartteto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;
	local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
    local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;
    local rotationPartNodehidra1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra1#index"));
    if rotationPartNodehidra1 ~= nil then
        self.rotationParthidra1 = {};
        self.rotationParthidra1.node = rotationPartNodehidra1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra1#minRot"));
        self.rotationParthidra1.minRot = {};
        self.rotationParthidra1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra1#maxRot"));
        self.rotationParthidra1.maxRot = {};
        self.rotationParthidra1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#rotTime"), 2)*1000;
        self.rotationParthidra1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#touchRotLimit"), 10));
    end;
        local rotationPartNodehidra2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra2#index"));
    if rotationPartNodehidra2 ~= nil then
        self.rotationParthidra2 = {};
        self.rotationParthidra2.node = rotationPartNodehidra2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra2#minRot"));
        self.rotationParthidra2.minRot = {};
        self.rotationParthidra2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra2#maxRot"));
        self.rotationParthidra2.maxRot = {};
        self.rotationParthidra2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#rotTime"), 2)*1000;
        self.rotationParthidra2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#touchRotLimit"), 10));
    end;
      local rotationPartNodehidra3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra3#index"));
    if rotationPartNodehidra3 ~= nil then
        self.rotationParthidra3 = {};
        self.rotationParthidra3.node = rotationPartNodehidra3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra3#minRot"));
        self.rotationParthidra3.minRot = {};
        self.rotationParthidra3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra3#maxRot"));
        self.rotationParthidra3.maxRot = {};
        self.rotationParthidra3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#rotTime"), 2)*1000;
        self.rotationParthidra3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#touchRotLimit"), 10));
    end;

    local attachNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attach#index"));
    if attachNode ~= nil then
        self.attach = {};
        self.attach.node = attachNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attach#minRot"));
        self.attach.minRot = {};
        self.attach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attach#maxRot"));
        self.attach.maxRot = {};
        self.attach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.attach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.attach#rotTime"), 2)*1000;
        self.attach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.attach#touchRotLimit"), 10));
    end;
	self.worklightsActive = false;
   
end;

function Fortschritt:delete()
    delete(self.burnerSoundId);

	
end;

function Fortschritt:getSaveAttributesAndNodes(nodeIdent)
   
end;

 
function Fortschritt:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function Fortschritt:keyEvent(unicode, sym, modifier, isDown)

 if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
	 if isDown and sym == Input.KEY_k then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end; 
	if isDown and sym == Input.KEY_m then 
		self.rotationMaxteto = not self.rotationMaxteto;
	end;
	if isDown and sym == Input.KEY_n then 
		self.rotationMaxabl1 = not self.rotationMaxabl1;
	end;
	if isDown and sym == Input.KEY_n then 
		self.rotationMaxabl2 = not self.rotationMaxabl2;
	end;
	if isDown and sym == Input.KEY_o then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_n then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
        	if isDown and sym == Input.KEY_n then 
		self.rotationMaxhidra3 = not self.rotationMaxhidra3;
        end;
	if sym == Input.KEY_pagedown then
		self.attachMax = isDown;
	end;
	if sym == Input.KEY_pageup then
		self.attachMin = isDown;
	end;
	if sym == Input.KEY_8 then
		self.alsokarMax = isDown;
	end;
	if sym == Input.KEY_7 then
		self.alsokarMin = isDown;
	end;
	--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------
if isDown and sym == Input.KEY_l then
		self.worklightsActive = not self.worklightsActive;
		self.farlightsActive = false;
		self.frontlightsActive = false;
	end;


end;

function Fortschritt:update(dt)
if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.LIZARD2000_SILLYHORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
 if self.isEntered then
        if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------
  if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
       if self.rotationPartteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		   setRotation(self.rotationPartteto.node, unpack(newRot));
        end;
		if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
        end;
        if self.rotationParthidra1 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra1.maxRot, self.rotationParthidra1.minRot, 3, self.rotationParthidra1.rotTime, dt, not self.rotationMaxhidra1);
		   setRotation(self.rotationParthidra1.node, unpack(newRot));
        end;
        if self.rotationParthidra2 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra2.maxRot, self.rotationParthidra2.minRot, 3, self.rotationParthidra2.rotTime, dt, not self.rotationMaxhidra2);
		   setRotation(self.rotationParthidra2.node, unpack(newRot));
        end;
        if self.rotationParthidra3 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra3.maxRot, self.rotationParthidra3.minRot, 3, self.rotationParthidra3.rotTime, dt, not self.rotationMaxhidra3);
		   setRotation(self.rotationParthidra3.node, unpack(newRot));
        end;

	local doRotate = self.attachMax or self.attachMin 
	if self.attach ~= nil and doRotate then
        	local x, y, z = getRotation(self.attach.node);		
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.attach.maxRot, self.attach.minRot, 3, self.attach.rotTime, dt, not self.attachMax);
        	setRotation(self.attach.node, unpack(newRot));
	end;
		
end;

function Fortschritt:onLeave()
 self.worklightsActive = false;
	
end;

function Fortschritt:draw()
 if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.18, 0.02, "Gomb kp 0:204 Info ki");
		else
			renderText(0.8335, 0.18, 0.02, "Gomb kp 0:204 Info be");
		end;
		if self.helpPanel then
			renderText(0.72, 0.84, 0.025, "-Claas Mega 204 Info-");
			renderText(0.72, 0.815, 0.02, "Gomb M: letra");	
			renderText(0.72, 0.8, 0.02, "Gomb N: magtartaly");			
			renderText(0.72, 0.785, 0.02, "Gomb K: ajto");
			renderText(0.72, 0.77, 0.02, "Gomb O: szecskazo");
			renderText(0.72, 0.755, 0.02, "Gomb KP 1: bal iranyjelzo");			
			renderText(0.72, 0.74, 0.02, "Gomb KP 2: elakadasjelzo");
			renderText(0.72, 0.725, 0.02, "Gomb KP 3: jobb iranyjelzo");
			renderText(0.72, 0.71, 0.02, "Gomb PgDown: Ferde le");
                        renderText(0.72, 0.695, 0.02, "Gomb PgUp: Ferde fel");
                        renderText(0.72, 0.68, 0.02, "Gomb L: Munkalampa");
			renderText(0.72, 0.665, 0.02, "by Torndao");
			renderText(0.72, 0.65, 0.02, "http://lsportal.hu");
		end;
	end;

end;
function Fortschritt:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function Fortschritt:openPipe()
   
end;