-- ActivateConvertTrigger by raffnix
-- @date: April 2012
-- @author: rafftnix
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
-- history: 
--  		v1.0 (April 2012)


function onCreateActivateConvertTrigger(self, id)
	local trigger = ActivateConvertTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
	table.insert(MFCT_HelpClass.drawNeededObjects, trigger);
end;

ActivateConvertTrigger = {}
local ActivateConvertTrigger_mt = Class(ActivateConvertTrigger, Object);
	
function ActivateConvertTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, ActivateConvertTrigger_mt);
    self.className = "ActivateConvertTrigger";
    return self;
end;

function ActivateConvertTrigger:load(id)
	self.MFCTInputTrigger = getUserAttribute(id, "MFCTInputTrigger");
	addTrigger(id, "triggerCallback", self);
	self.triggerId = id;
	self.firstRun = true;
	self.playerIsInTrigger = false;
end;

function ActivateConvertTrigger:delete()
	removeTrigger(self.triggerId);
end;

function ActivateConvertTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ActivateConvertTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function ActivateConvertTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		if otherId == g_currentMission.player.rootNode then
			self.playerIsInTrigger = true;
		end;
	end;
	if onLeave then
		if otherId == g_currentMission.player.rootNode then
			self.playerIsInTrigger = false;
		end;
	end;
end;

function ActivateConvertTrigger:update(dt)
	if self.firstRun then
		self.firstRun = false;
		for a=1, table.getn(MFCT_HelpClass.MapFruitChangeTriggers) do
			if MFCT_HelpClass.MapFruitChangeTriggers[a].myMapIndex == self.MFCTInputTrigger then
				self.inputTrigger = MFCT_HelpClass.MapFruitChangeTriggers[a];
				self.inputTrigger.isTurnedOn = false;
				break;
			end;
		end;
	end;
	if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
		if self.playerIsInTrigger then
			self.inputTrigger:setIsTurnedOn(not self.inputTrigger.isTurnedOn);
		end;
	end;
end;

function ActivateConvertTrigger:updateTick(dt)
	if g_server ~= nil then
		if self.inputTrigger.isTurnedOn then
			empty = true;
			for k, v in pairs(self.inputTrigger.inputlevels) do
				if v > 0 then
					empty = false;
				end;
			end;
			if empty then
				self.inputTrigger:setIsTurnedOn(false);
			end;
		end;
	end;
end;

function ActivateConvertTrigger:draw()
	if self.playerIsInTrigger then
		if not self.inputTrigger.isTurnedOn then
			g_currentMission:addHelpButtonText(" "..self.inputTrigger.stationName.." "..g_i18n:getText("ActivateConvertTrigger_activate"), InputBinding.ACTIVATE_OBJECT);
		else
			g_currentMission:addHelpButtonText(" "..self.inputTrigger.stationName.." "..g_i18n:getText("ActivateConvertTrigger_deactivate"), InputBinding.ACTIVATE_OBJECT);
		end;
	end;
end;