-- MapFruitChangeTrigger by raffnix
-- @date: 18.12.2011
-- @author: rafftnix
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
-- history: 
--  		v1.0 (April 2012)

function onCreate(self, id)
	local trigger = MapFruitChangeTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
	table.insert(MFCT_HelpClass.MapFruitChangeTriggers, trigger);
	--table.insert(MFCT_HelpClass.drawNeededObjects, trigger);
end;

MapFruitChangeTrigger = {}
local MapFruitChangeTrigger_mt = Class(MapFruitChangeTrigger, Object);
	
function MapFruitChangeTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, MapFruitChangeTrigger_mt);
    self.className = "MapFruitChangeTrigger";
    return self;
end;

function MapFruitChangeTrigger:load(id)
	self.trailers = {}
	self.inputlevels = {}
	self.outputlevels = {}
	self.changedInput = {}
	self.changedOutput = {}
	self.fruitInfos = {}
	
	-- Thanks to Heady
	self.priceMultipliers = {}
	for i=1, FruitUtil.NUM_FRUITTYPES do
		self.priceMultipliers[i] = 0;
	end;
 
	local parent = getParent(id);
	self.MFCTId = id;
	self.isTurnedOn = true;
	self.firstRun = true;
	self.sendTimer = 0;
	self.sendTimerBackup = 1000;
	self.playerCount = 1;
	self.myMapIndex = getUserAttribute(id, "myMapNumber");
	self.stationName = Utils.getNoNil(getUserAttribute(id, "stationName"), "Station");
	self.convertLitersPerSecond = Utils.getNoNil(getUserAttribute(id, "convertSpeed"), 5);
	self.convertPrizePerLiter = Utils.getNoNil(getUserAttribute(id, "convertPrize"), 0);
	self.inputSiloCapacity = Utils.getNoNil(getUserAttribute(id, "inputSiloCapacity"), 150000);
	self.outputSiloCapacity = Utils.getNoNil(getUserAttribute(id, "outputSiloCapacity"), 150000);
	self.massScale = Utils.getNoNil(getUserAttribute(id, "massScale"), 1);
	self.inputSiloName = Utils.getNoNil(getUserAttribute(id, "inputSiloName"), "inputSiloName");	
	self.outputSiloName = Utils.getNoNil(getUserAttribute(id, "outputSiloName"), "outputSiloName");	
	self.unloadWhileDriving = Utils.getNoNil(getUserAttribute(id, "unloadWhileDriving"), false);
	self.triggerId = id;
	
	local num = 0;
	while true do
		-- load fruit settings
		num = num + 1;
		local inputstr = getUserAttribute(id, "inputFruitType"..tostring(num));
		local outputstr = getUserAttribute(id, "outputFruitType"..tostring(num));	
		local planeIndex = getUserAttribute(id, "planeIndex"..tostring(num));	
		local planeMinY = getUserAttribute(id, "planeMinY"..tostring(num));	
		local planeMaxY = getUserAttribute(id, "planeMaxY"..tostring(num));	
		local planeMultiplicator = getUserAttribute(id, "planeMultiplicator"..tostring(num));	
		local input = Fillable.fillTypeNameToInt[inputstr];
		local output = Fillable.fillTypeNameToInt[outputstr];
		if input == nil or output == nil then
			break;
		else
			-- register fruits
			self.inputlevels[input] = 0;
			self.outputlevels[output] = 0;
			self.fruitInfos[input] = {}
			local fruit = {}
			fruit.output = output; 
			if planeIndex ~= nil and planeMinY ~= nil and planeMaxY ~= nil and planeMultiplicator ~= nil then
				-- plane
				fruit.plane = Utils.indexToObject(parent, planeIndex);
				fruit.planeMinY = PlaneMinY;
				fruit.planeMaxY = PlaneMaxY;
				fruit.multiplicatorY = planeMultiplicator;
			end;
			self.fruitInfos[input] = fruit;
		end;
	end;
	
	-- feed plane
	local feederPlaneIndex = getUserAttribute(id, "feederPlaneIndex");
	if feederPlaneIndex ~= nil then
		self.feederPlaneIndex = Utils.indexToObject(parent, feederPlaneIndex);
	end;
	
	-- take bales
	local takeBales = getUserAttribute(id, "takeBales");	
	local convertBalesTo = Fillable.fillTypeNameToInt[getUserAttribute(id, "convertBalesTo")];
	local baleMass = getUserAttribute(id, "baleMass");
	if takeBales ~= nil and convertBalesTo ~= nil and baleMass ~= nil then
		self.convertBalesTo = convertBalesTo;
		self.baleMass = baleMass;
		self.takeBales = takeBales;
		self.inputlevels[self.convertBalesTo] = 0;	
	else
		self.takeBales = false;
	end;
	
	-- combined plane
	local combinedPlaneIndex = getUserAttribute(id, "combinedPlaneIndex");
	local combinedPlaneMinY = getUserAttribute(id, "combinedPlaneMinY");
	local combinedPlaneMaxY = getUserAttribute(id, "combinedPlaneMaxY");
	local combinedPlaneMultiplicator = getUserAttribute(id, "combinedPlaneMultiplicator");
	if combinedPlaneIndex ~= nil and combinedPlaneMinY ~= nil and combinedPlaneMaxY ~= nil and combinedPlaneMultiplicator ~= nil then
		self.combinedPlane = Utils.indexToObject(parent, combinedPlaneIndex);
		self.combinedPlaneMinY = combinedPlaneMinY;
		self.combinedPlaneMaxY = combinedPlaneMaxY;
		self.combinedPlaneMultiplicator = combinedPlaneMultiplicator;
	end;
	
	addTrigger(id, "triggerCallback", self);
end;

function MapFruitChangeTrigger:delete()
	removeTrigger(self.MFCTId);
	delete(self.MFCTId);
end;

function MapFruitChangeTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapFruitChangeTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapFruitChangeTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local trailer = g_currentMission.objectToTrailer[otherShapeId];
	if trailer ~= nil then
		if onEnter then
			if trailer ~= nil and trailer.allowTipDischarge then
				table.insert(self.trailers, trailer);
			end;
		end;
		if onStay then
			if self:getIsInputAllowed(trailer) and self.inputlevels[trailer.currentFillType] ~= nil then
				g_currentMission.trailerInTipRange = trailer;
			end;
		end;
		if onLeave then
			for a=1, table.getn(self.trailers) do
				if self.trailers[a] == trailer then
					self.trailers[a]:onEndTip();
					table.remove(self.trailers, a);
				end;
			end;
		end;
	end;
	-- bales
	if self.takeBales then
		if (self.inputlevels[self.convertBalesTo] + self.baleMass) <= self.inputSiloCapacity then
			local object = g_currentMission:getNodeObject(otherId);
			if object ~= nil and object:isa(Bale) then
				object:delete();
				self:changeInput(self.convertBalesTo, self.inputlevels[self.convertBalesTo] + self.baleMass);
			end;
		end;
	end;
end;

function MapFruitChangeTrigger:update(dt)
	if InputBinding.hasEvent(InputBinding.ATTACH) then
		for a=1, table.getn(self.trailers) do
			if self:getIsInputAllowed(self.trailers[a]) and self.inputlevels[self.trailers[a].currentFillType] ~= nil then
				self.trailers[a]:toggleTipState(self);
			end;
		end;
	end;
end;

function MapFruitChangeTrigger:updateTick(dt)
	if g_server ~= nil then
		-- unload trailers
		for a=1, table.getn(self.trailers) do
			local trailer = self.trailers[a];
			local defaultWork = true;
			if trailer.MFCTInterfaceFunc ~= nil then
				defaultWork = trailer:MFCTInterfaceFunc(self);
			end;
			if trailer.isReadyForUnloading ~= nil then
				if not trailer.isReadyForUnloading then
					defaultWork = false;
				end;
			end;
			if defaultWork and (trailer.tipState == Trailer.TIPSTATE_OPENING or trailer.tipState == Trailer.TIPSTATE_OPEN) then
				if self.inputlevels[trailer.currentFillType] ~= nil and (self.inputlevels[trailer.currentFillType] - trailer.lastFillDelta) < self.inputSiloCapacity then
					local backup = self.inputlevels[trailer.currentFillType];
					local level = self.inputlevels[trailer.currentFillType] - trailer.lastFillDelta;
					if backup ~= level then
						self:changeInput(trailer.currentFillType, (self.inputlevels[trailer.currentFillType] - trailer.lastFillDelta));
					end;
				else
					trailer:onEndTip();
				end;
			end;
		end;
	
		-- convert fruits
		if self.isTurnedOn then
			for k, level in pairs(self.inputlevels) do
				if level > 0 then 
					local inputlevelbackup = self.inputlevels[k];
					local outputType = self.fruitInfos[k].output;
					local amount = math.min(self.convertLitersPerSecond, self.inputlevels[k]);
					
					local olevel = self.outputlevels[outputType] + (amount * self.massScale);
					if level > 0 and amount > 0 then						
						level = level - amount;
						self:changeOutput(outputType, olevel);
						self:changeInput(k, level);
						local money = self.convertPrizePerLiter * amount;
						local multiplier = 0;
						if g_currentMission.missionStats.difficulty == 1 then
							multiplier = 1;
						elseif g_currentMission.missionStats.difficulty == 2 then
							multiplier = 0.6;
						else
							multiplier = 0.3;
						end;
						money = money * multiplier;
						g_currentMission:addSharedMoney(-money);
					end;
				end;
			end;
		end;
		
		-- MP Update Timer
		self.sendTimer = self.sendTimer - dt;
		if self.sendTimer <= 0 then
			self.sendTimer = self.sendTimerBackup;
			self:synchStates();
		end;
		
		-- Thanks to Heady
		local playerCount = 0;
		for key, value in pairs(g_currentMission.players) do			
			playerCount = playerCount + 1;
		end;
		if playerCount > self.playerCount then
			for k, v in pairs(self.inputlevels) do
				self.changedInput[k] = true;
			end;
			for k, v in pairs(self.outputlevels) do
				self.changedOutput[k] = true;
			end;
		end;
		self.playerCount = playerCount;
	end;
	
	if self.feederPlaneIndex ~= nil then
		local feederPlaneActive = false;
		for a=1, table.getn(self.trailers) do
			if self.trailers[a].tipState == Trailer.TIPSTATE_OPENING or self.trailers[a].tipState == Trailer.OPEN and self.trailers[a].isReadyForUnloading == nil then 
				feederPlaneActive = true;
				break;
			elseif self.trailers[a].isReadyForUnloading ~= nil then
				if self.trailers[a].isReadyForUnloading and self.trailers[a].fillLevel > 0 and self.inputlevels[self.trailers[a].currentFillType] ~= nil then
					feederPlaneActive = true;
					break;
				end;
			end;
		end;
		setVisibility(self.feederPlaneIndex, feederPlaneActive);
	end;	
		
	-- update fruit planes
	for k, v in pairs(self.fruitInfos) do
		if v.Plane ~= nil then
			local x, y, z = getTranslation(self.fruitInfos[k].plane);
			local calculatedY = self.fruitInfos[k].planeMinY + (self.fruitInfos[k].multiplikatorY * self.inputlevels[k]);
			local newY = math.min(calculatedY, self.fruitInfos[k].planeMaxY);
			setTranslation(v.Plane, x, newY, z);
		end;
	end;
		
	-- combined plane
	if self.combinedPlane ~= nil then
		local value = 0;
		local numLevels = 0;
		for k, v in pairs(self.inputlevels) do
			numLevels = numLevels + 1;
			value = value + v;
		end;
		local average = value/numLevels;
		local x, y, z = getTranslation(self.combinedPlane);
		local yCalculated = self.combinedPlaneMinY + (self.combinedPlaneMultiplicator*average);
		local newY = math.min(self.combinedPlaneMaxY, yCalculated);
		setTranslation(self.combinedPlane, x, newY, z);
	end;
end;

function MapFruitChangeTrigger:updateMoving()
	-- This Funktion is called by the Trailer while unloading. But I update the moving of the planes with my code in function updateTick(dt);
end;

function MapFruitChangeTrigger:draw()
	for a=1, table.getn(self.trailers) do
		if self:getIsInputAllowed(self.trailers[a]) and self.inputlevels[self.trailers[a].currentFillType] ~= nil then -- Bug wenn man den Hnger im Trigger stehen lsst und was anderen ankuppeln will. Aufgetreten mit dem ZX von heady
			g_currentMission.hudTipperOverlay:render();
			break;
		end;
	end;
end;

function MapFruitChangeTrigger:setIsTurnedOn(isTurnedOn, noEventSend)
	self.isTurnedOn = isTurnedOn;
	if not noEventSend then
		MFCT_ActivateConvert.sendEvent(self, self.isTurnedOn, noEventSend);
	end;
end;

function MapFruitChangeTrigger:getIsInputAllowed(trailer)
	if not SpecializationUtil.hasSpecialization(Trailer, trailer.specializations) then
	--	return false;
	end;
	
	if not g_currentMission:getIsTrailerInTipRange(trailer, self) then
		return false;
	end;
	if g_gui.currentGui ~= nil then
		return false;
	end;
	if trailer:getIsActiveForInput() then
		return true;
	end;
	if g_currentMission.controlledVehicle == nil then
		return false;
	end;
	if g_currentMission.controlledVehicle == trailer.attacherVehicle then
		return true;
	end;
	if g_currentMission.controlledVehicle == trailer then
		return true;		
	end;
	return false;
end;

function MapFruitChangeTrigger:changeInput(key, level)
	self.inputlevels[key] = level;
	if self.changedInput[key] == nil then
		self.changedInput[key] = true;
	end;
end;

function MapFruitChangeTrigger:changeOutput(key, level)
	self.outputlevels[key] = level;
	if self.changedOutput[key] == nil then
		self.changedOutput[key] = true;
	end;
end;

function MapFruitChangeTrigger:synchStates()
	for key, v in pairs(self.changedInput) do
		MFCT_InputLevelEvent.sendEvent(self, key, self.inputlevels[key]);
	end;
	self.changedInput = {}
	for key, level in pairs(self.changedOutput) do
		MFCT_OutputLevelEvent.sendEvent(self, key, self.outputlevels[key]);
	end;
	self.changedOutput = {}
end;