-- MFCT_HelpClass by raffnix
-- @date: December 2011
-- @author: rafftnix
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
-- history: 
--  		v1.0 (April 2012)

print("MapFruitChangeTrigger 1.0 by rafftnix loaded");
MFCT_HelpClass = {};
MFCT_HelpClass.MapFruitChangeTriggers = {}
MFCT_HelpClass.MapFruitChangeOutputTriggers = {}
MFCT_HelpClass.drawNeededObjects = {}
MFCT_HelpClass.modDir = g_currentModDirectory;

function MFCT_HelpClass:loadMap(name)
	if self.firstLoadRun == nil then
		self.firstLoadRun = true;
		self.InfoAktive = false;
		self.selectedMFCT = 1;
		self.firstRun = true;
		self.runTime = 0;
		self.overwriteTipRangeFunc = true;
		self.currentMapPath = string.gsub(name, "map01.i3d", "");
		self.HUDoben = createImageOverlay(MFCT_HelpClass.modDir.."HUDoben.dds");
		self.HUDmitte = createImageOverlay(MFCT_HelpClass.modDir.."HUDmitte.dds");
		self.HUDunten = createImageOverlay(MFCT_HelpClass.modDir.."HUDunten.dds");
		if g_currentMission.missionStats.traveledDistanceTotal == 0 then
			local savegame = g_currentMission.missionInfo.savegameIndex;
			self.fileName = getUserProfileAppPath().."savegame"..tostring(savegame).."/MapFruitChangeTrigger.xml"; 
			os.remove(self.fileName);
		end;
	end;
	if MapBGASilo ~= nil then
		if MapBGASilo.ModEvent.loadInfFunction ~= nil then
			MapBGASilo.ModEvent.loadInfFunction = false;
		end;
	end;
end;

-- add save sallback
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame; 
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MFCT_HelpClass:saveStates();
end;
		
function MFCT_HelpClass:deleteMap()
	MFCT_HelpClass.MapFruitChangeTriggers = {}
end;

function MFCT_HelpClass:mouseEvent(posX, posY, isDown, isUp, button)

end;

function MFCT_HelpClass:keyEvent(unicode, sym, modifier, isDown)
end;

function MFCT_HelpClass:loadStates()
	if g_server ~= nil then
		local savegame = g_currentMission.missionInfo.savegameIndex;
		self.fileName = getUserProfileAppPath().."savegame"..tostring(savegame).."/MapFruitChangeTrigger.xml"; 
		if io.open(self.fileName, "r") then
			self.xmlFile = loadXMLFile("MFCTSaves", self.fileName);
			if self.xmlFile == nil then
				self.xmlFile = createXMLFile("MFCTSaves", self.filename, "kpWasDahinSoll_MFCT");
			else
				for a=1, table.getn(self.MapFruitChangeTriggers) do
					local trigger = self.MapFruitChangeTriggers[a];
					local key = "MapFruitChangeTriggers.Trigger"..tostring(a);
					for k, v in pairs(trigger.inputlevels) do
						local fullKey = key..".Input#"..Fillable.fillTypeIntToName[k];
						local value = getXMLFloat(self.xmlFile, fullKey);
						if value ~= nil and trigger.inputlevels[k] ~= nil then
							value = math.min(value, trigger.inputSiloCapacity);
							trigger.inputlevels[k] = value;
						end;
					end;
					for k, v in pairs(trigger.outputlevels) do
						local fullKey = key..".Output#"..Fillable.fillTypeIntToName[k];
						local value = getXMLFloat(self.xmlFile, fullKey);
						if value ~= nil and trigger.outputlevels[k] ~= nil then
							value = math.min(value, trigger.outputSiloCapacity);
							trigger.outputlevels[k] = value;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function MFCT_HelpClass:saveStates()
	io.output(io.open(self.fileName,"w"));
	io.write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
	io.write('<MapFruitChangeTriggers>\n');
	for a=1, table.getn(self.MapFruitChangeTriggers) do
		local trigger = self.MapFruitChangeTriggers[a];
		local tag = '	<Trigger'..tostring(a)..'>\n';
		io.write(tag);
		tag = '		<Input ';
		for k, v in pairs(trigger.inputlevels) do
			tag = tag..Fillable.fillTypeIntToName[k]..'="'..tostring(v)..'" ';
		end;
		tag = tag..'/>\n';
		io.write(tag);
		
		tag = '		<Output ';
		for k, v in pairs(trigger.outputlevels) do
			tag = tag..Fillable.fillTypeIntToName[k]..'="'..tostring(v)..'" ';
		end;
		tag = tag..'/>\n'
		io.write(tag);
		local endtag = '	</Trigger'..tostring(a)..'>\n';
		io.write(endtag);
	end;
	io.write('</MapFruitChangeTriggers>');
	io.close();
end;


function MFCT_HelpClass:update(dt)
	if self.firstRun then
		if MapBGASilo ~= nil then
			if MapBGASilo.ModEvent.loadInfFunction ~= nil then
				MapBGASilo.ModEvent.loadInfFunction = false;
			end;
		end;
		self.firstRun = false;
		self:loadStates();
		if self.overwriteTipRangeFunc then
			-- Thanks to Heady
			local BaseMissionGetIsTrailerInTipRange = BaseMission.getIsTrailerInTipRange;
			BaseMission.getIsTrailerInTipRange = function(self, trailer, tipTrigger)
				if tipTrigger.unloadWhileDriving == true or tipTrigger.specialTriggerId ~= nil or tipTrigger.triggerId == nil then
					return true;
				else
					return BaseMissionGetIsTrailerInTipRange(self, trailer, tipTrigger);
				end;
			end;
		end;
			
		-- get number for MP synchro
		for a=1, table.getn(MFCT_HelpClass.drawNeededObjects) do
			MFCT_HelpClass.drawNeededObjects[a].number = a;
		end;
		for a=1, table.getn(MFCT_HelpClass.MapFruitChangeOutputTriggers) do
			MFCT_HelpClass.MapFruitChangeOutputTriggers[a].number = a;
		end;
		for a=1, table.getn(MFCT_HelpClass.MapFruitChangeTriggers) do
			MFCT_HelpClass.MapFruitChangeTriggers[a].number = a;
		end;
	end;
	
	-- HUD
	if InputBinding.hasEvent(InputBinding.MFCT_INFO) and InputBinding.isPressed(InputBinding.MFCT_INFO2) and InputBinding.isPressed(InputBinding.MFCT_INFO3) then
		self.InfoAktive = not self.InfoAktive;
	end;	
	if self.InfoAktive then
		if InputBinding.hasEvent(InputBinding.MFCT_NEXTFRUIT) and MFCT_HelpClass.MapFruitChangeTriggers[(self.selectedMFCT + 1)] ~= nil then
			self.selectedMFCT = self.selectedMFCT + 1;
		end;
		if InputBinding.hasEvent(InputBinding.MFCT_LASTFRUIT) and MFCT_HelpClass.MapFruitChangeTriggers[(self.selectedMFCT - 1)] ~= nil then
			self.selectedMFCT = self.selectedMFCT - 1;
		end;
	end;
end;

function MFCT_HelpClass:draw()
	for a=1, table.getn(MFCT_HelpClass.MapFruitChangeTriggers) do
		MFCT_HelpClass.MapFruitChangeTriggers[a]:draw();
	end;
	for a=1, table.getn(MFCT_HelpClass.drawNeededObjects) do
		MFCT_HelpClass.drawNeededObjects[a]:draw();
	end;
	for a=1, table.getn(MFCT_HelpClass.MapFruitChangeOutputTriggers) do
		MFCT_HelpClass.MapFruitChangeOutputTriggers[a]:draw();
	end;
	
	
	if self.InfoAktive then
		-- header
		setTextBold(false);
		setTextColor(0, 0, 0, 1);
		local trigger = MFCT_HelpClass.MapFruitChangeTriggers[self.selectedMFCT];
		renderText(0.65, 0.85, 0.030, g_i18n:getText("fillLevels").." "..self:getHasText(trigger.stationName));
		renderText(0.65, 0.815, 0.025, self:getHasText(trigger.inputSiloName));
		renderText(0.825, 0.815, 0.025, self:getHasText(trigger.outputSiloName));
	
		local y = 0.815;	
		for k, v in pairs(trigger.inputlevels) do
			y = y - 0.025;
			local percent = tostring(math.floor((v/trigger.inputSiloCapacity)*100)).."%";
			renderText(0.65, y, 0.020, tostring(math.floor(v)).."l "..self:getHasText(Fillable.fillTypeIntToName[k]).." ("..percent..")");
		end;
		local yBackup = y;
		
		local y = 0.815;
		for k, v in pairs(trigger.outputlevels) do
			y = y - 0.025;
			local percent = tostring(math.floor((v/trigger.outputSiloCapacity)*100)).."%";
			renderText(0.825, y, 0.020, tostring(math.floor(v)).."l "..self:getHasText(Fillable.fillTypeIntToName[k]).." ("..percent..")");
		end;
		y = math.min(yBackup, y);
		if MFCT_HelpClass.MapFruitChangeTriggers[(self.selectedMFCT + 1)] ~= nil then
			y = y-0.025;
			renderText(0.65, y, 0.020, "-->>"..MFCT_HelpClass.MapFruitChangeTriggers[(self.selectedMFCT + 1)].stationName.." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.MFCT_NEXTFRUIT));
		end;
		if MFCT_HelpClass.MapFruitChangeTriggers[(self.selectedMFCT - 1)] ~= nil then
			y = y-0.025;
			renderText(0.65, y, 0.020, "<<--"..MFCT_HelpClass.MapFruitChangeTriggers[(self.selectedMFCT - 1)].stationName.." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.MFCT_LASTFRUIT));
		end;
		--renderOverlay(self.overlay, 0.65, 0.85-(0.85-y), 0.35, (0.85-y+0.04));
		renderOverlay(self.HUDoben, 0.64, 0.81, 0.33, 0.10);
		local posY = 0.84-(0.85-y);
		renderOverlay(self.HUDmitte, 0.64, posY + 0.06, 0.33, 0.80 - (posY + 0.05));
		renderOverlay(self.HUDunten, 0.64, posY, 0.33, 0.06);
		
		setTextColor(1, 1, 1, 1);
	end;
end;

function MFCT_HelpClass:getHasText(name)
	local text = g_i18n:getText(name);
	if text ~= nil and text ~= "Missing "..name.." in l10n_de.xml" then
		return text;
	else
		return name;
	end;
end;

addModEventListener(MFCT_HelpClass);