--
-- MapFruitTrigger
--
-- M@D Author:  Heady
-- M@D date: 20.01.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

print("  Map: MapFruitTrigger v1.0 loaded");

if BaseMission.modMapShovelTrigger == nil then
	BaseMission.modMapShovelTrigger = {};
	print("  Register Variable: BaseMission.modMapShovelTrigger");
end;

ModEvent = {};

ModEvent.triggers = {};

function ModEvent:loadMap(name)

	local pathToCurrentModMap, nTimes = string.gsub(name, "/map01.i3d", "");
	if nTimes > 0 then
		self.pathToCurrentModMap = pathToCurrentModMap;
	end;
	
end;

function ModEvent:deleteMap()
	
	ModEvent.triggers = {};
	BaseMission.modMapShovelTrigger = {};	

end;

function ModEvent:delete()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)
end;

function ModEvent:draw()

	for i=1, table.getn(ModEvent.triggers) do
		ModEvent.triggers[i]:draw();
	end;
	
end;


addModEventListener(ModEvent);



function onCreate(self, id)
	--print("created MapFruitTrigger, id: ", id);
	local instance = MapFruitTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true); -- add update routine, 
	table.insert(ModEvent.triggers, instance);
end;

MapFruitTrigger = {};

local MapFruitTrigger_mt = Class(MapFruitTrigger, Object);

function MapFruitTrigger:new(isServer, isClient)

	local self = Object:new(isServer, isClient, MapFruitTrigger_mt);
	self.className = "MapFruitTrigger";

	return self;
end;

function MapFruitTrigger:load(id)


	local fruitType = getUserAttribute(id, "fillType");		
	local key = "FILLTYPE_"..string.upper(fruitType);
	self.fillType = Fillable[key];
	self.fillSpeed = getUserAttribute(id, "fillSpeed");	
	self.autoFill = Utils.getNoNil(getUserAttribute(id, "autoFill"), false);
	self.sell = Utils.getNoNil(getUserAttribute(id, "buy"), false);

	addTrigger(id, "triggerCallback", self);
	
	self.specialTriggerId = id;
	
	self.emptyNode = Utils.indexToObject(getParent(id), getUserAttribute(id, "emptyNode"));
	self.capacity = 999999999;
	self.fillLevel = 0;
	
	if self.emptyNode ~= nil then
		table.insert(g_currentMission.modMapShovelTrigger, self);
	end;
	
	self.attachableID = nil;
	
	self.fillingActive = false;	
	
	self.firstTimeRun = true;
	
end;


function MapFruitTrigger:loadFirstTimeRun(id)
	
	local particleSystemIndex = getUserAttribute(id, "particleSystemIndex")	
	if particleSystemIndex ~= nil then
		self.particleSystemNode = Utils.indexToObject(getParent(id), particleSystemIndex);
        local particleSystem = Utils.getNoNil(getUserAttribute(id, "particleSystem"), "wheatParticleSystemLong")
        self.particleSystemRoot = loadI3DFile(ModEvent.pathToCurrentModMap .. "/" .. particleSystem .. ".i3d");

        link(self.particleSystemNode, self.particleSystemRoot);

        for i=0, getNumOfChildren(self.particleSystemRoot)-1 do
            local child = getChildAt(self.particleSystemRoot, i);
            if getClassName(child) == "Shape" then
                local geometry = getGeometry(child);
                if geometry ~= 0 then
                    if getClassName(geometry) == "ParticleSystem" then
                        self.particleSystem = geometry;
                    end;
                end;
            end;
        end;

        if self.particleSystem ~= nil then
            setEmittingState(self.particleSystem, false);
        end;

    end;
	
	self.particleSystemActive = false;


end;

function MapFruitTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapFruitTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapFruitTrigger:delete()

	for i=1, table.getn(g_currentMission.modMapShovelTrigger) do
		if g_currentMission.modMapShovelTrigger == self then
			table.remove(g_currentMission.modMapShovelTrigger, i);
		end;
	end;

	removeTrigger(self.specialTriggerId);	

	if self.particleSystem ~= nil then
        delete(self.particleSystem);
    end;

end;

function MapFruitTrigger:update(dt)
	
	if self.firstTimeRun then
		self:loadFirstTimeRun(self.specialTriggerId)
		self.firstTimeRun = false;
	end;
	

	if self.attachableID ~= nil then
		
		if self.attachableID.attacherVehicle == g_currentMission.controlledVehicle or self.attachableID == g_currentMission.controlledVehicle or Utils.getNoNil(Utils.getNoNil(self.attachableID.attacherVehicle, self).attacherVehicle, self) == g_currentMission.controlledVehicle then
	
			if g_gui.currentGui == nil and not self.autoFill then

				if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
					self.fillingActive = not self.fillingActive; 
					self:updateSendEvent();
				end; 
				if self.fillingActive then
					g_currentMission:addExtraPrintText(g_i18n:getText("MAPFRUITTRIGGER_1").. " " ..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT)); 
				else
					g_currentMission:addExtraPrintText(g_i18n:getText("MAPFRUITTRIGGER_2").. " " ..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT)); 
				end; 
				
			end;
			
		end;
		

		

		self.particleSystemActive = false;
		
		if self.fillingActive or self.autoFill then		
			if self.attachableID.fillLevel < self.attachableID.capacity then
			
				if g_server ~= nil then
				
					local deltaFillLevel = dt*self.fillSpeed;
					self.attachableID:setFillLevel(self.attachableID.fillLevel+deltaFillLevel, self.fillType);
					
					if self.sell then
						local desc = FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[self.fillType]]
						
						if desc ~= nil then						
							local price = deltaFillLevel*desc.seedPricePerLiter;
							g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + price;
							g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + price;
							g_currentMission:addSharedMoney(-price);
						end;
					end;	
					
				end;
				
				self.particleSystemActive = true;
			end;			
		end;
		
		if self.attachableID.fillLevel >= self.attachableID.capacity then							
			self.fillingActive = false;
		end;	

		
	end;
	
	
	if self.particleSystem ~= nil then
		setEmittingState(self.particleSystem, self.particleSystemActive);
	end;
	
end;

function MapFruitTrigger:draw()
end;

function MapFruitTrigger:setFillLevel(fillLevel, fillType)
end;

function MapFruitTrigger:allowFillType(fillType, allowEmptying)
    local allowed = false;

    if self.fillType == fillType then
        allowed = true;
    end;
    return allowed;
end;

function MapFruitTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	
    if onEnter then
		if otherId ~= nil then	
			local attachable = g_currentMission.nodeToVehicle[otherId];
			if attachable ~= nil then
				if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil and attachable.capacity ~= nil then
					if attachable:allowFillType(self.fillType, true) then
						self.attachableID = attachable;	
					end;
				end;
			end;
		end;		
	elseif onLeave then
		if otherId ~= nil then	
			local attachable = g_currentMission.nodeToVehicle[otherId];
			if attachable ~= nil then
				if attachable == self.attachableID then
					self.attachableID = nil;
					self.fillingActive = false;
					self.particleSystemActive = false;
				end;
			end;
		end;					
	end;	
	
end;

function MapFruitTrigger:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end

end;
