--
-- ChurnEstates
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ChurnEstates = {}

local ChurnEstates_mt = Class(ChurnEstates, Mission00);

function ChurnEstates:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = ChurnEstates_mt;
    end;
    local self = ChurnEstates:superClass():new(baseDirectory, mt);
    return self;
end;

function ChurnEstates:delete()
    ChurnEstates:superClass().delete(self);
end;

function ChurnEstates:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    ChurnEstates:superClass().load(self);
end
function ChurnEstates:loadFinished()
    ChurnEstates:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
--
    -- List of mod-filenames, that are required for this map.
    -- Please note that these filenames are CaSe-SeNsItIvE!
    local requiredMods = {
	    "FertBag",
		"SeedBag",
	  	"ChurnEstatesObjects",
        "FMCMapTrigger",
		"loadShovel",
		"MapBGASilo",
		"MapFruitChangeTrigger",
		"MapFruitTrigger",
		"PDAmod_WorkersAndMultiFruit",
    };
    --
    self.missingMods = nil;
    for k,modFilename in pairs(requiredMods) do
        if g_modIsLoaded[modFilename] == nil then
            if self.missingMods == nil then
                self.missingMods = {};
            end;
            table.insert(self.missingMods, modFilename);
        end;
    end;
--
end;

function ChurnEstates:mouseEvent(posX, posY, isDown, isUp, button)
    ChurnEstates:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function ChurnEstates:keyEvent(unicode, sym, modifier, isDown)
    ChurnEstates:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function ChurnEstates:update(dt)
    ChurnEstates:superClass().update(self, dt);
end;

function ChurnEstates:draw()
    ChurnEstates:superClass().draw(self);
--
    if self.missingMods ~= nil then
        setTextAlignment(RenderText.ALIGN_CENTER);
        setTextBold(true);
        setTextColor(1.0, 1.0, 1.0, 0.75);
        renderText(0.5, 0.75, 0.05, "Required mods not found!");
        local y = 0.70;
        for k,modFilename in pairs(self.missingMods) do
            renderText(0.5, y, 0.03, modFilename);
            y = y - 0.031;
        end;
        setTextAlignment(RenderText.ALIGN_LEFT);
        setTextBold(false);
    end;
--
end;
