--
-- KrAZ256
-- Specialization for KrAZ256 mod
--
-- @author  unknown
-- @date  27/05/11
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

KrAZ256 = {};

function KrAZ256.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function KrAZ256:load(xmlFile)
    hornSoundFile = Utils.getFilename("superHorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("LizardHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function KrAZ256:delete()
    delete(self.burnerSoundId);
end;

function KrAZ256:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KrAZ256:keyEvent(unicode, sym, modifier, isDown)
end;

function KrAZ256:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.KrAZ256_SILLYHORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function KrAZ256:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("Silly Horn"), InputBinding.KrAZ256_SILLYHORN);
end;

