---
--- Biso Schneidwerkswagen
---
--- by Matthias " MxY.rlp" B.
--- @date 19/April/2009
--- MxY.rlp@online.de
--- 
--- (c) by MxY.rlp --> Thanks to GIANTS Software for a great game and perfect scriptwork!

BISO = {}

function BISO.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function BISO:load(xmlFile)
  self.sipka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sipka#index"));
  if self.sipka ~= nil then
    self.showSipku = (table.getn(self.attachedImplements)==0);
    setVisibility(self.sipka, self.showSipku and (g_currentMission.showHelpText));
    local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sipka#minTrans"));
    if x == nil or y == nil or z == nil then
      x,y,z = getTranslation(self.sipka);
    end;
    self.sipkaMinTrans = {x,y,z};
    x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sipka#maxTrans"));    
    if x == nil or y == nil or z == nil then
      x,y,z = getTranslation(self.sipka);
    end;
    self.sipkaMaxTrans = {x,y,z};
    self.nahoru = true;
  end;
end;
function BISO:update(dt)
  if InputBinding.hasEvent(InputBinding.TOGGLE_HELP_TEXT) then
    setVisibility(self.sipka, self.showSipku and (not g_currentMission.showHelpText));
  end;
  if self.showSipku then
    local x, y, z = getTranslation(self.sipka);
    local trans = {x,y,z};
    local newtrans = Utils.getMovedLimitedValues(trans, self.sipkaMinTrans, self.sipkaMaxTrans, 3, 500, dt, self.nahoru);
    setTranslation(self.sipka, unpack(newtrans));
    if self.nahoru then
      if (self.sipkaMaxTrans[2] - newtrans[2]) < 0.001 then
        self.nahoru=false;
      end;
    else
      if (newtrans[2] - self.sipkaMinTrans[2]) < 0.001 then
        self.nahoru=true;
      end;    
    end; 
  end;
end;
function BISO:keyEvent(unicode, sym, modifier, isDown)
end;
function BISO:mouseEvent(posX, posY, isDown, isUp, button)
end;
function BISO:delete()
end;

function BISO:draw()
  g_currentMission:addExtraPrintText(g_i18n:getText("BISO_1"))
end;

function BISO:onAttach()
  self.showSipku = false;
  setVisibility(self.sipka, false);
end;

function BISO:onDetach()
  for i=table.getn(self.attachedImplements), 1, -1 do
    self:detachImplement(1);
  end;
  self.showSipku = true;
  setVisibility(self.sipka, self.showSipku and (g_currentMission.showHelpText));
end;