--
-- silageShovel
--
-- M@D Author:  Heady
-- M@D date: 08.02.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--


if BaseMission.modMapShovelTrigger == nil then
	BaseMission.modMapShovelTrigger = {};
	print("  Register Variable: BaseMission.modMapShovelTrigger");
end;

silageShovel = {};

function silageShovel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function silageShovel:load(xmlFile)

	self.fallOut = false;
	self.fallOutParticle = false;
	self.isShovel = true;
	self.lastFillLevel = self.fillLevel;

end;


function silageShovel:delete()
end;
	
function silageShovel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function silageShovel:keyEvent(unicode, sym, modifier, isDown)
end;

--function silageShovel:readStream(streamId, connection)
--end;

--function silageShovel:writeStream(streamId, connection)
--end;

function silageShovel:update(dt)
end;

function silageShovel:updateTick(dt)

	if self:getIsActive() then	

		if self.isServer then 		
			
			if self.attacherVehicle ~= nil then
				local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 1, 0));
				if z > 0 then
					self.fallOut = true;
				else
					self.fallOut = false;
				end;
				self.kippWinkel = z;
			end;
			
			
			
			if self.fallOut then
				
				local nearestDistance = 5.0;
				local px, py, pz = getWorldTranslation(self.tipReferencePoint);
				for i=1, table.getn(g_currentMission.attachables) do
					local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

					if distance < nearestDistance then
						local attachable = g_currentMission.attachables[i];	
						if attachable.rootNode ~= self.rootNode then
							if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
								if attachable:allowFillType(self.currentFillType, true) then
									if attachable.fillLevel < attachable.capacity and self.fillLevel > 0 then							
										local deltaLevel = (self.kippWinkel*self.kippWinkel)*(self.capacity/200)*dt							
										local fillDelta = math.min(deltaLevel, self.fillLevel)
										self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
										attachable:setFillLevel(attachable.fillLevel + fillDelta, self.currentFillType);
									end; 
								end;
							end;
						end;
					end;
				end;	

				local nearestDistance = 5.0;
				local px, py, pz = getWorldTranslation(self.tipReferencePoint);
				for i=1, table.getn(g_currentMission.modMapShovelTrigger) do
					local vx, vy, vz = getWorldTranslation(g_currentMission.modMapShovelTrigger[i].emptyNode);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

					if distance < nearestDistance then
						local object = g_currentMission.modMapShovelTrigger[i];		
						if object.fillLevel ~= nil and object.capacity ~= nil and object.setFillLevel ~= nil and object.allowFillType ~= nil then
							if object.fillLevel < object.capacity and self.fillLevel > 0 and object:allowFillType(self.currentFillType, true) then							
								local deltaLevel = (self.kippWinkel*self.kippWinkel)*(self.capacity/200)*dt							
								local fillDelta = math.min(deltaLevel, self.fillLevel)
								self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
								object:setFillLevel(object.fillLevel + fillDelta, self.currentFillType);
							end; 
						end;
					end;
				end;
				
				if self.fillLevel == 0 then
					self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
				end;
				
			end;
			
		end;
		
		if self.lastFillLevel > self.fillLevel then
			self.fallOutParticle = true;
		else
			self.fallOutParticle = false;
		end;
		self.lastFillLevel = self.fillLevel;
			
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.fallOutParticle);
	
	end;
	

end;

function silageShovel:draw()
end;

function silageShovel:onDetach()
    self.fallOut = false;
	self.fallOutParticle = false;
end;
