
movingAttacher = {};

function movingAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function movingAttacher:load(xmlFile)

	self.moveableAttacher = {};
	self.moveableAttacher.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttacher#index"));
	self.moveableAttacher.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher#maxY"), 0); 
	self.moveableAttacher.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher#minY"), 0); 
	
end;

function movingAttacher:delete()
end;

function movingAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function movingAttacher:keyEvent(unicode, sym, modifier, isDown)

end;

function movingAttacher:update(dt)

	if self.moveableAttacher ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher.index);
		local maxY = self.moveableAttacher.max;
		local minY = self.moveableAttacher.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.ATTACHER_UP) and InputBinding.isPressed(InputBinding.ACTIVATION2) then
				if yAttacher < maxY then
					yAttacher = yAttacher + moveSpeed;
				else
					yAttacher = maxY;
				end;
			elseif InputBinding.isPressed(InputBinding.ATTACHER_DOWN) and InputBinding.isPressed(InputBinding.ACTIVATION2) then
				if yAttacher > minY then
					yAttacher = yAttacher - moveSpeed;
				else
					yAttacher = minY;
				end;
			end;
		setTranslation(self.moveableAttacher.index, xAttacher, yAttacher, zAttacher);
	end;
				
end;

function movingAttacher:onLeave()

end;

function movingAttacher:draw()

end;

function movingAttacher:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

