﻿-- RabaCultivator specialization
-- Script Modifications by: Tubman
-- http://www.ls-uk.info/

RabaCultivator = {};

function RabaCultivator.prerequisitesPresent(specializations)
    return true;
end;

function RabaCultivator:load(xmlFile)
	
	self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel;
	self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;
	self.safeMode = true
	self.rotationMaxRight = true;
	self.rotationMaxLeft = true;
	self.rotationMaxRight2 = true;
	self.rotationMaxLeft2 = true;
	self.translationMax = true;
	self.translationMax2 = false;
		
	self.SVMT = 6000;
	self.SVT = self.SVMT;

	numDrums = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.drum#count"), 0);
	self.drumNodes = {};
	for i=1, numDrums do
		local drumnum = string.format("vehicle.drum#index".."%d",i);
		self.drumNodes[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, drumnum));
	end;

	self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);

	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 100)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

	local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 100)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;

	local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 100)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;

	local rotationPartNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight2#index"));
    if rotationPartNodeRight2 ~= nil then
        self.rotationPartRight2 = {};
        self.rotationPartRight2.node = rotationPartNodeRight2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#minRot"));
        self.rotationPartRight2.minRot = {};
        self.rotationPartRight2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#maxRot"));
        self.rotationPartRight2.maxRot = {};
        self.rotationPartRight2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        self.rotationPartRight2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        self.rotationPartRight2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        self.rotationPartRight2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#rotTime"), 100)*1000;
        self.rotationPartRight2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#touchRotLimit"), 10));
	end;


	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;

	local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;

	local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;

	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        self.workSound = createSample("workSound");
		self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
		self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
        loadSample(self.workSound, workSound, false);
    end;

	self.fieldWorkParticleSystem1 = {};
    local psName = "vehicle.fieldWorkParticleSystem1";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem1, psName, self.rootNode, false)

	self.fieldWorkParticleSystem2 = {};
    local psName = "vehicle.fieldWorkParticleSystem2";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem2, psName, self.rootNode, false)

	self.fieldWorkParticleSystem3 = {};
    local psName = "vehicle.fieldWorkParticleSystem3";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem3, psName, self.rootNode, false)

	self.fieldWorkParticleSystem4 = {};
    local psName = "vehicle.fieldWorkParticleSystem4";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem4, psName, self.rootNode, false)

	self.fieldWorkParticleSystem5 = {};
    local psName = "vehicle.fieldWorkParticleSystem5";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem5, psName, self.rootNode, false)

	self.fieldWorkParticleSystem6 = {};
    local psName = "vehicle.fieldWorkParticleSystem6";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem6, psName, self.rootNode, false)

	self.fieldWorkParticleSystem7 = {};
    local psName = "vehicle.fieldWorkParticleSystem7";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem7, psName, self.rootNode, false)

	self.fieldWorkParticleSystem8 = {};
    local psName = "vehicle.fieldWorkParticleSystem8";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem8, psName, self.rootNode, false)

	self.fieldWorkParticleSystem9 = {};
    local psName = "vehicle.fieldWorkParticleSystem9";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem9, psName, self.rootNode, false)

	self.fieldWorkParticleSystem10 = {};
    local psName = "vehicle.fieldWorkParticleSystem10";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem10, psName, self.rootNode, false)

	self.fieldWorkParticleSystem11 = {};
    local psName = "vehicle.fieldWorkParticleSystem11";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem11, psName, self.rootNode, false)

	self.fieldWorkParticleSystem12 = {};
    local psName = "vehicle.fieldWorkParticleSystem12";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem12, psName, self.rootNode, false)

	self.fieldWorkParticleSystem13 = {};
    local psName = "vehicle.fieldWorkParticleSystem13";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem13, psName, self.rootNode, false)

	self.fieldWorkParticleSystem14 = {};
    local psName = "vehicle.fieldWorkParticleSystem14";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem14, psName, self.rootNode, false)

	self.fieldWorkParticleSystem15 = {};
    local psName = "vehicle.fieldWorkParticleSystem15";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem15, psName, self.rootNode, false)

	self.fieldWorkParticleSystem16 = {};
    local psName = "vehicle.fieldWorkParticleSystem16";
    Utils.loadParticleSystem(xmlFile, self.fieldWorkParticleSystem16, psName, self.rootNode, false)
	
end;

function RabaCultivator:delete()
end;

function RabaCultivator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RabaCultivator:keyEvent(unicode, sym, modifier, isDown)
end;

function RabaCultivator:update(dt)

	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	if self: getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxlsafe) then
			self.safeMode = not self.safeMode
		end;
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxllow) then
			self.translationMax2 = not self.translationMax2;
		end;
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxltwo) then
			self.rotationMaxRight = not self.rotationMaxRight;
			self.rotationMaxLeft = not self.rotationMaxLeft;
			if not self.rotationMaxLeft2 then
				self.rotationMaxRight2 = not self.rotationMaxRight2;
				self.rotationMaxLeft2 = not self.rotationMaxLeft2;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.GregoireBessonxxlthree) and not self.rotationMaxLeft then
			self.rotationMaxRight2 = not self.rotationMaxRight2;
			self.rotationMaxLeft2 = not self.rotationMaxLeft2;
		end;
		if InputBinding.isPressed(InputBinding.GregoireBessonxxlup) then
			self.translationMax = true;
		else
			self.translationMax = false;
		end;
		if InputBinding.isPressed(InputBinding.GregoireBessonxxldn) then
			self.translationMin = true;
		else
			self.translationMin = false;
		end;
	end;
	
	if self.attacherVehicle then

		self.isExpandedMode = 1;

        if self.rotationPartRight ~= nil then
            local x, y, z = getRotation(self.rotationPartRight.node);
            local minRot = self.rotationPartRight.minRot;
            local eps = self.rotationPartRight.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.isExpandedMode = 2;
				local x, y, z = getRotation(self.rotationPartRight2.node);
				local minRot = self.rotationPartRight2.minRot;
				local eps = self.rotationPartRight2.touchRotLimit;
				if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
					self.isExpandedMode = 3;
				end;
            end;
        end;

		if self.aiLeftMarker ~= self.cuttingAreas[self.isExpandedMode].start or self.aiRightMarker ~= self.cuttingAreas[self.isExpandedMode].width then
			self.aiLeftMarker = self.cuttingAreas[self.isExpandedMode].start;
			self.aiRightMarker = self.cuttingAreas[self.isExpandedMode].width;
			AITractor.updateToolsInfo(self.attacherVehicle);
		end;

		if self.translationMax2 and self.isExpandedMode ~= nil then

			if self.isExpandedMode == 1 then
				numDrums = 2;
			elseif self.isExpandedMode == 2 then
				numDrums = 6;
			elseif self.isExpandedMode == 3 then
				numDrums = 10;
			end;
			
			for i=1, numDrums do
				if self.drumNodes[i] ~= nil then
					rotate(self.drumNodes[i], self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
				end;
			end;

			if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[self.isExpandedMode].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[self.isExpandedMode].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[self.isExpandedMode].height);
				Utils.updateCultivatorArea (x+0.5, z+0.3, x1-0.5, z1+0.3, x2, z2, not self.safeMode);    --corrected for more ai overlap
			end;

		end;

		if self.translationMax2 and self.attacherVehicle.lastSpeed * 3600 > 2 then

			while true do
				Utils.setEmittingState(self.fieldWorkParticleSystem1, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem2, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem3, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem4, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				if self.isExpandedMode == 1 then
					Utils.setEmittingState(self.fieldWorkParticleSystem5, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem6, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem7, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem8, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem9, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem10, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem11, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem12, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem13, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem14, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem15, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem16, false);
					break;
				end;
				Utils.setEmittingState(self.fieldWorkParticleSystem5, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem6, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem7, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem8, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem9, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem10, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				if self.isExpandedMode == 2 then
					Utils.setEmittingState(self.fieldWorkParticleSystem11, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem12, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem13, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem14, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem15, false);
					Utils.setEmittingState(self.fieldWorkParticleSystem16, false);
					break;
				end;
				Utils.setEmittingState(self.fieldWorkParticleSystem11, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem12, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem13, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem14, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem15, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				Utils.setEmittingState(self.fieldWorkParticleSystem16, (self.attacherVehicle.lastSpeed*3600 > 2 ));
				break;
			end;
			
			if not self.attacherVehicle.isAITractorActivated then 
				if self:doCheckSpeedLimit() and self.lastSpeed * 3600 > 21 then 
					self.SVT = self.SVT - dt;
					if self.SVT < 0 and self.attacherVehicle ~= nil then
						self.translationMax2 = not self.translationMax2;
						self.attacherVehicle:detachImplementByObject(self);
						self.SVT = self.SVMT;
					end;
				else
					self.SVT = self.SVMT;       
				end;

				if not self.workSoundRunning then
					setSamplePitch(self.workSound, self.workSoundPitchOffset);
					playSample(self.workSound, 0, 1.6, 0);
					self.workSoundRunning = true;
				end;
			else
				stopSample(self.workSound);
                self.workSoundRunning = false;
			end;
		else
			self.SVT = self.SVMT;       
		end;   -- is lowered

		if not self.translationMax2 or self.attacherVehicle.lastSpeed * 3600 < 2 then
			if self.workSoundRunning then
                stopSample(self.workSound);
                self.workSoundRunning = false;
			end;
			Utils.setEmittingState(self.fieldWorkParticleSystem1, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem2, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem3, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem4, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem5, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem6, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem7, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem8, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem9, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem10, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem11, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem12, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem13, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem14, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem15, false);
			Utils.setEmittingState(self.fieldWorkParticleSystem16, false);
		end;
	end;


	local doTranslate = self.translationMax or self.translationMin
	if self.translationPart ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPart.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart.node, unpack(newTrans));
	end;

	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;

	if self.rotationPartRight2 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight2.maxRot, self.rotationPartRight2.minRot, 3, self.rotationPartRight2.rotTime, dt, not self.rotationMaxRight2);
        setRotation(self.rotationPartRight2.node, unpack(newRot));
    end;

    if self.rotationPartLeft2 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
        setRotation(self.rotationPartLeft2.node, unpack(newRot));
    end;

	if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
	end;

	if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
end;

function RabaCultivator:aiLower()
self.translationMax2 = not self.translationMax2;
end;

function RabaCultivator:aiRaise()
self.translationMax2 = not self.translationMax2;
end;

function RabaCultivator:aiTurnOn()
self.safeMode = true;
end;

function RabaCultivator:aiTurnOff()
end;

function RabaCultivator:draw()

	if self.safeMode then
		g_currentMission: addHelpButtonText ("Switch to normal mode", InputBinding.GregoireBessonxxlsafe);
	else
		g_currentMission: addHelpButtonText ("Switch to safe mode", InputBinding.GregoireBessonxxlsafe);
	end; 
	if self.rotationMaxLeft then
		g_currentMission:addExtraPrintText(string.format("%s: Unfold Stage Two", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxltwo)));
	else
		g_currentMission:addExtraPrintText(string.format("%s: Fold Stage Two", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxltwo)));
		if self.rotationMaxLeft2 then
			g_currentMission:addExtraPrintText(string.format("%s: Unfold Stage Three", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxlthree)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Fold Stage Three", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxlthree)));
		end;
	end;
		g_currentMission:addExtraPrintText(string.format("%s: Height Adjust Raise", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxlup)));
		g_currentMission:addExtraPrintText(string.format("%s: Height Adjust Lower", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxldn)));
	if self.translationMax2 then
		g_currentMission:addExtraPrintText(string.format("%s: Raise", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxllow)));
	else
		g_currentMission:addExtraPrintText(string.format("%s: Lower", InputBinding.getKeyNamesOfDigitalAction(InputBinding.GregoireBessonxxllow)));
	end;
	if math.abs(self.SVT - self.SVMT) > 2 then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)), 0.092, 0.048)
	end;
end;

function RabaCultivator:onAttach()
self.translationMax3 = true;
end;

function RabaCultivator:onDetach()
self.translationMax3 = false;
end;

function RabaCultivator:getSaveAttributesAndNodes(nodeIdent)
	if self.isExpandedMode == nil then 
		self.isExpandedMode = 0;
	end;
    local attributes = 'isExpandedMode="'..self.isExpandedMode..'"';
	return attributes, nil;
end;

function RabaCultivator:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   self.isExpandedMode = Utils.getNoNil(getXMLFloat(xmlFile, key.."#isExpandedMode"),0);
if self.isExpandedMode >= 2 then   
	self.rotationMaxRight = false;
	self.rotationMaxLeft = false;
end;
if self.isExpandedMode == 3 then
	self.rotationMaxRight2 = false;
	self.rotationMaxLeft2 = false;
end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

--[[
self
self.translationPart3(table) = table: 0A1D9DD0
self.aiTurnOff(function) = function: 0D3F2960
self.aiTerrainDetailChannel1(number) = 2
self.allowFillFromAir(boolean) = true
self.fillLevel(number) = 0
self.onlyActiveWhenLowered(boolean) = true
self.attachedImplements(table) = table: 0A1E4AC8
self.workSound(number) = 24757
self.lights(table) = table: 0A1E4D98
self.onReleaseBrake(function) = function: 0D3F2BC0
self.resetFillLevelIfNeeded(function) = function: 095F9BC8
self.fillTypeChangeThreshold(number) = 0.05
self.SVT(number) = 6000
self.contactReportNodes(table) = table: 0A1D93D0
self.requiredDriveMode(number) = 1
self.fieldWorkParticleSystem15(table) = table: 0A1DE010
self.isBroken(boolean) = false
self.downForce(number) = 0
self.exactFillRootNode(number) = 24709
self.onSetLowered(function) = function: 0D3F2CA0
self.aiRotateLeft(function) = function: 0D3F32E0
self.lightCones(table) = table: 0A1E4CF8
self.emptyMass(number) = 6.9787197113037
self.attachTime(number) = 12466.192154884
self.fillMassNode(number) = 24709
self.maxRotTime(number) = 0
self.allowFillType(function) = function: 095F9BA8
self.hydraulicSoundEnabled(boolean) = false
self.fillAutoAimTargetNode(number) = 24709
self.autoRotateBackSpeed(number) = 1
self.translationPart(table) = table: 0A1D9A10
self.componentsVisibility(boolean) = true
self.checkSpeedLimit(boolean) = true
self.vehicleDirtyFlag(number) = 1
self.dynamicWheelFrictionCosAngleMin(number) = 0.64278760968654
self.aiTrafficCollisionTrigger(number) = 24752
self.attacherJoints(table) = table: 0A1E4B40
self.drumNodes(table) = table: 0A1D9470
self.workSoundPitchOffset(number) = 0.5
self.onBrake(function) = function: 0D3F28A0
self.lowerAnimationSpeed(number) = 1
self.tickDt(number) = 33.384399414063
self.componentJoints(table) = table: 0A1E4F78
self.cuttingAreas(table) = table: 0A1E4F28
self.translationMax(boolean) = true
self.steeringAxleAngleScaleEnd(number) = 30
self.rootNode(number) = 24709
self.allowsDetaching(boolean) = true
self.sizeWidth(number) = 8
self.fieldWorkParticleSystem16(table) = table: 0A1DE4C0
self.configFileName(string) = C:/Users/amaclellan/Documents/My Games/FarmingSimulator2011/mods/GregoireBessonxxl/GregoireBessonxxl.xml
self.customEnvironment(string) = GregoireBessonxxl
self.fieldWorkParticleSystem7(table) = table: 0A1DBA90
self.speedDisplayDt(number) = 60.771890640259
self.isDefaultLowered(boolean) = false
self.beaconLights(table) = table: 0A1E4E60
self.wheels(table) = table: 0A1E4D20
self.specializations(table) = table: 0A573138
self.lastPosition(table) = table: 23181910
self.time(number) = 18060.77189064
self.onEndTip(function) = function: 0D3F2B60
self.isVehicleSaved(boolean) = true
self.aiBackMarker(number) = 24753
self.startActivationTime(number) = 14466.192154884
self.steeringAxleNode(number) = 24709
self.fieldWorkParticleSystem6(table) = table: 0A1DB5E0
self.fieldWorkParticleSystem12(table) = table: 0A1DD200
self.tipReferencePoint(number) = 24709
self.setFillLevel(function) = function: 0A1D92B8
self.lightConesActive(boolean) = false
self.fieldWorkParticleSystem5(table) = table: 0A1DB130
self.dynamicWheelFrictionMinScale(number) = 0.001
self.lastSpeedReal(number) = 3.0517559002717e-007
self.realLightsActive(boolean) = false
self.components(table) = table: 0A1E4CA8
self.hire(function) = function: 0D3F2AE0
self.speedViolationMaxTime(number) = 2500
self.translationMax2(boolean) = false
self.wheelRpm(number) = 0.00014038515898089
self.isBraking(boolean) = false
self.positionIsDirty(boolean) = false
self.dismiss(function) = function: 0D3F2AA0
self.forceIsActive(boolean) = false
self.widthOffset(number) = 0
self.attacherJoint(table) = table: 0A1D90D8
self.baseDirectory(string) = C:/Users/amaclellan/Documents/My Games/FarmingSimulator2011/mods/GregoireBessonxxl/
self.sentFillType(number) = 0
self.attacherVehicle(table) = table: 1465F490
self.vehicleNodes(table) = table: 0A1E4C08
self.groundContactReport(function) = function: 0D3F2B40
self.sentFillLevel(number) = 0
self.currentMass(number) = 6.9787197113037
self.isActive(boolean) = true
self.rotationPartRight2(table) = table: 0A1D99C0
self.fieldWorkParticleSystem14(table) = table: 0A1DDB60
self.fieldWorkParticleSystem13(table) = table: 0A1DD6B0
self.onStartTip(function) = function: 0D3F2BA0
self.lengthOffset(number) = 0
self.rotationPartLeft2(table) = table: 0A1D9920
self.onDetach(function) = function: 0D3F2900
self.fillRootNode(number) = 24709
self.selectedImplement(number) = 0
self.minRotTime(number) = 0
self.fieldWorkParticleSystem10(table) = table: 0A1DC8A0
self.tipAnimCharSet(number) = 0
self.wheelFrictionScale(number) = 1
self.fieldWorkParticleSystem9(table) = table: 0A1DC3F0
self.onDeselect(function) = function: 0D3F2840
self.isSelected(boolean) = true
self.interpolationAlpha(number) = 0
self.lastFillDelta(number) = 0
self.lightCoronas(table) = table: 0A1E4EB0
self.fieldWorkParticleSystem8(table) = table: 0A1DBF40
self.cultivatorLimitToField(boolean) = false
self.isHired(boolean) = false
self.fieldWorkParticleSystem4(table) = table: 0A1DAC80
self.maxSpeedLevel(number) = 1
self.drumRotationScale(number) = 100
self.fieldWorkParticleSystem3(table) = table: 0A1DA7D0
self.cultivatorHasGroundContact(boolean) = true
self.SVMT(number) = 6000
self.updateWheels(boolean) = true
self.fieldWorkParticleSystem1(table) = table: 0A1D9E70
self.isRegistered(boolean) = true
self.speedDisplayScale(number) = 1
self.workSoundVolume(number) = 0.60000002384186
self.translationPart2(table) = table: 0A1D9CB8
self.aiTurnOn(function) = function: 0D3F3480
self.aiRightMarker(number) = 24750
self.className(string) = Vehicle
self.cuttingAreasSend(table) = table: 0A1D9510
self.aiNeedsLowering(boolean) = true
self.typeName(string) = GregoireBessonxxl.RabaCultivator
self.rotationPartLeft(table) = table: 0A1D96A0
self.brakeForce(number) = 0
self.toggleTipState(function) = function: 0D3F2C20
self.aiRotateRight(function) = function: 0D3F2820
self.rotationMaxLeft2(boolean) = true
self.rotationMaxRight2(boolean) = true
self.steeringAxleAngle(number) = 0.13065012343873
self.rotationMaxRight(boolean) = true
self.lastSpeed(number) = 4.7059655512931e-007
self.nextDirtyFlag(number) = 8
self.rotatedTime(number) = 0
self.pricePerMS(number) = 0.00055555555555556
self.rotationPartRight(table) = table: 0A1D9650
self.allowTipDischarge(boolean) = true
self.cultivatorContactReportsActive(boolean) = true
self.aiRaise(function) = function: 0D3F3400
self.startActivationTimeout(number) = 2000
self.onAttach(function) = function: 0D3F3260
self.dynamicWheelFrictionCosAngleMax(number) = 0.76604444311898
self.cultivatorForceLimitToField(boolean) = true
self.speedViolationTimer(number) = 2500
self.newGroundParticleSystems(table) = table: 0A1D9498
self.groundParticleSystems(table) = table: 0A1D92E0
self.movingDirection(number) = 0
self.lastMovedDistance(number) = 0
self.capacity(number) = 0
self.speedRotatingParts(table) = table: 0A1D9308
self.cultivatorGroundContactFlag(number) = 4
self.fillSoundEnabled(boolean) = false
self.needsLowering(boolean) = true
self.onSelect(function) = function: 0D3F28C0
self.typeDesc(string) = cultivator
self.dischargeParticleSystems(table) = table: 0A1D93A8
self.tipState(number) = 0
self.currentFillType(number) = 0
self.fieldWorkParticleSystem2(table) = table: 0A1DA320
self.fillableDirtyFlag(number) = 2
self.groundReferenceThreshold(number) = 0.2
self.lightsActive(boolean) = false
self.aiLower(function) = function: 0D3F2EC0
self.getCurrentFruitType(function) = function: 095F94A8
self.safeMode(boolean) = true
self.allowsLowering(boolean) = true
self.fillTypes(table) = table: 0A1D9150
self.isServer(boolean) = true
self.isAddedToMission(boolean) = true
self.isClient(boolean) = true
self.massScale(number) = 9.1e-005
self.translationMin(boolean) = false
self.lastWheelRpm(number) = 0
self.lastSoundSpeed(number) = 0
self.updateSteeringAxleAngle(boolean) = true
self.isExpandedMode(number) = 1
self.id(number) = 241
self.aiForceTurnNoBackward(boolean) = true
self.sizeLength(number) = 8
self.deactivateOnDetach(boolean) = true
self.aiTerrainDetailChannel2(number) = 0
self.dirtyMask(number) = 0
self.aiLeftMarker(number) = 24749
self.firstTimeRun(boolean) = true
self.translationMax3(boolean) = true
self.steeringAxleAngleScaleStart(number) = 10
self.fieldWorkParticleSystem11(table) = table: 0A1DCD50
self.rotationMaxLeft(boolean) = true
--]]